/*
 * CursdII - curses interface for Appleblossom
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>

void if_print_help(char * myname)
{
	printf("\n");
	printf("%s [-nocurses] [-option <param>] [-option <param>] ...\n\n", myname);
	printf("Options:\n\n");
	printf(" -d1 <file>     loads .dsk or .nib disk image into slot 6 drive 1.\n");
	printf(" -d2 <file>     loads .dsk or .nib disk image into slot 6 drive 2.\n");
	printf(" -d1do          specifies DOS 3.3 order for drive 1. Must come after -d1.\n");
	printf(" -d2do          specifies DOS 3.3 order for drive 2. Must come after -d2.\n");
	printf(" -d1po          specifies ProDOS order for drive 1. Must come after -d1.\n");
	printf(" -d2po          specifies ProDOS order for drive 2. Must come after -d2.\n");
	printf(" -d1n           specifies nibblized for drive 1. Must come after -d1.\n");
	printf(" -d2n           specifies nibblized for drive 2. Must come after -d2.\n");
	printf("                If none of the above six options is specified, disk order\n");
	printf("                is based on file extension (nibblized for .nib, ProDOS\n");
	printf("                for .po, DOS 3.3 for all others).\n");
	printf(" -h1 <file>     loads .hdv disk image into slot 7 drive 1.\n");
	printf(" -h2 <file>     loads .hdv disk image into slot 7 drive 2.\n");
	printf(" -s1 <file>     connects a file to the Apple II's serial port in slot 1.\n");
	printf(" -s2 <file>     connects a file to the Apple II's serial port in slot 2.\n");
	printf(" -d <file>      reports top eight bytes of stack, registers, and the\n");
	printf("                current instruction to <file> for each instruction executed.\n");
	printf("                (This file gets very big very fast.)\n");
	printf(" -j <file>      reports every JMP or JSR the Apple II makes to <file>.\n");
	printf(" -don           starts with dumping on (-d or -j) instead of waiting for F13.\n");
	printf(" -disktest      runs a test of Disk II support and exits.\n");
	printf(" -help          displays this screen and exits.\n");
	printf(" -keys          displays a list of keys and exits.\n");
	printf("\n");
}

void if_print_keys(void)
{
	printf("\n");
	printf(" F5 - Open Apple Down\n");
	printf(" F6 - Solid Apple Down\n");
	printf(" F7 - Open Apple Up\n");
	printf(" F8 - Solid Apple Up\n");
	printf(" F9 - Dump Memory\n");
	printf("F10 - Quit\n");
	printf("F11 - Control-C (BASIC Soft-Reentry from Monitor; Break)\n");
	printf("F12 - Control-Reset\n");
	printf("F13 - Turn on disassembly dump (if file specified by -d or -j)\n");
	printf("F14 - Turn off disassembly dump\n");
	printf("\n");
}
