/*
 * CursdII - curses interface for Appleblossom
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <curses.h>
#include "../a2includes.h"

MEVENT a2_mouse_event;
unsigned long a2_mouse_mask = (
	BUTTON1_PRESSED | BUTTON1_RELEASED |
	BUTTON2_PRESSED | BUTTON2_RELEASED |
	REPORT_MOUSE_POSITION
);
unsigned long a2_mouse_pmask;
int a2_max_x;
int a2_max_y;

int a2_char_refmt(unsigned char ch)
{
	switch (ch & 0xE0) {
	case 0xA0:
	case 0xC0:
	case 0xE0:
		if (ch == 0xFF) return '#';
		return (ch & 0x7F);
		break;
	case 0x80:
		return ('@' + (ch & 0x1F));
		break;
	case 0x00:
		return (('@' + (ch & 0x1F)) | A_REVERSE);
		break;
	case 0x20:
		return ((' ' + (ch & 0x1F)) | A_REVERSE);
		break;
	case 0x40:
		if (A2_ALTCHAR) {
			switch (ch & 0x1F) {
			case 0x00: return '?'; break;
			case 0x01: return '?'; break;
			case 0x02: return '?'; break;
			case 0x03: return ACS_LANTERN; break;
			case 0x04: return '?'; break;
			case 0x05: return '?'; break;
			case 0x06: return '?'; break;
			case 0x07: return '?'; break;
			case 0x08: return ACS_LARROW; break;
			case 0x09: return '?'; break;
			case 0x0A: return ACS_DARROW; break;
			case 0x0B: return ACS_UARROW; break;
			case 0x0C: return ACS_S1; break;
			case 0x0D: return '?'; break;
			case 0x0E: return ACS_BLOCK; break;
			case 0x0F: return ACS_LARROW; break;
			case 0x10: return ACS_RARROW; break;
			case 0x11: return ACS_DARROW; break;
			case 0x12: return ACS_UARROW; break;
			case 0x13: return ACS_HLINE; break;
			case 0x14: return '?'; break;
			case 0x15: return ACS_RARROW; break;
			case 0x16: return ACS_CKBOARD; break;
			case 0x17: return ACS_CKBOARD; break;
			case 0x18: return '?'; break;
			case 0x19: return '?'; break;
			case 0x1A: return '?'; break;
			case 0x1B: return ACS_DIAMOND; break;
			case 0x1C: return '?'; break;
			case 0x1D: return '?'; break;
			case 0x1E: return '?'; break;
			case 0x1F: return '?'; break;
			}
			return '?';
		}
		return (('@' + (ch & 0x1F)) | A_REVERSE | A_BLINK);
		break;
	case 0x60:
		if (A2_ALTCHAR) {
			if (ch == 0x7F) return ('#' | A_REVERSE);
			return (ch | A_REVERSE);
		}
		return ((' ' + (ch & 0x1F)) | A_REVERSE | A_BLINK);
		break;
	}
}

void a2_curses_init(void)
{
	initscr();
	cbreak();
	noecho();
	nodelay(stdscr, 1);
	keypad(stdscr, 1);
#ifdef NCURSES_MOUSE_VERSION
	mousemask(a2_mouse_mask, &a2_mouse_pmask);
#endif
	getmaxyx(stdscr, a2_max_y, a2_max_x);
}

void a2_curses_dump(void)
{
	int y, x;
	unsigned short b;
	if (A2_80VIDEO) {
		for (y=0; y<24; y++) {
			b = a2_text_base(y);
			for (x=0; x<40; x++) {
				move(y,x*2);
				addch(a2_char_refmt(A2_AUX[b+x]));
				addch(a2_char_refmt(A2_MAIN[b+x]));
			}
		}
	} else {
		for (y=0; y<24; y++) {
			b = a2_text_base(y);
			for (x=0; x<40; x++) {
				move(y,x);
				addch(a2_char_refmt(A2_MAIN[b+x]));
			}
		}
	}
	refresh();
}

void a2_curses_free(void)
{
#ifdef NCURSES_MOUSE_VERSION
	mousemask(a2_mouse_pmask, &a2_mouse_mask);
#endif
	endwin();
}

int a2_curses_kbd(void)
{
	int i = getch();
	switch (i) {
	case ERR:			return ERR;		break;
	case 10:			return 13;		break;
	case KEY_DOWN:		return 10;		break;
	case KEY_UP:		return 11;		break;
	case KEY_LEFT:		return 8;		break;
	case KEY_RIGHT:		return 21;		break;
	case KEY_BACKSPACE:	return 8;		break;
	case KEY_F(11):		return 3;		break;
#ifdef NCURSES_MOUSE_VERSION
	case KEY_MOUSE:
		getmouse(&a2_mouse_event);
		getmaxyx(stdscr, a2_max_y, a2_max_x);
		A2_PDL0_VALUE = a2_mouse_event.x * 255 / a2_max_x;
		A2_PDL1_VALUE = a2_mouse_event.y * 255 / a2_max_y;
		A2_PB0 = (a2_mouse_event.bstate & BUTTON1_PRESSED);
		A2_PB1 = (a2_mouse_event.bstate & BUTTON2_PRESSED);
		return ERR;
		break;
#endif
	default: 			return i;		break;
	}
	return i;
}

