/*
 * Apple iiPod - Appleblossom Interface for iPodLinux
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../a2includes.h"
#include "ifvars.h"
#include "nano-X.h"

const char a2_charlist[] = " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz=+\x1B\x7F\xFF?!@#$%^&*()[]{}_-<>~`\x09\x08\x15\x0B\x0A\x0D\"\'1234567890\\/|:;.,";
const int a2_numchars = 104;

extern void a2_draw_char_40(GR_WINDOW_ID wid, GR_GC_ID gc, unsigned char ch, int x, int y);

unsigned char a2_kbd_vchar(unsigned char ch, int inv) {
	if (inv) {
		if (ch < 32) return ch+192;
		if (ch < 64) return ch;
		if (ch < 96) return ch-64;
		return ch;
	} else {
		if (ch < 32) return ch;
		return ch+128;
	}
	return 0;
}

void a2_draw_keyboard(GR_WINDOW_ID wid, GR_GC_ID gc)
{
	int nc = (a2_keyboard_orientation?25:40);
	int bx = (a2_keyboard_orientation?156:0);
	int by = (a2_keyboard_orientation?0:123);
	int dx = (a2_keyboard_orientation?0:4);
	int dy = (a2_keyboard_orientation?5:0);
	int s = (a2_keyboard_pos - nc/2);
	int i;
	if (s<0) s=0;
	if (s>(a2_numchars - nc)) s=(a2_numchars - nc);
	for (i=0; i<nc; i++) {
		a2_draw_char_40(wid, gc, a2_kbd_vchar(a2_charlist[s+i], ((s+i)==a2_keyboard_pos)), bx, by);
		bx += dx;
		by += dy;
	}
}

void a2_do_keypress(unsigned char ch)
{
	int p;
	/* a2_pb_up(0);
	a2_pb_up(1);
	a2_pb_up(2); */
	switch (ch) {
	case 0:
		/* bring up menu */
		GrClose(); exit(0);
		break;
	case 128:
	case 129:
	case 130:
		a2_pb_down(ch & 3);
		break;
	case 140:
	case 141:
	case 142:
		a2_pb_up(ch & 3);
		break;
	case 132: p = A2_PDL0_VALUE - 1; if (p>=0) A2_PDL0_VALUE = p; break;
	case 133: p = A2_PDL0_VALUE + 1; if (p<256) A2_PDL0_VALUE = p; break;
	case 134: p = A2_PDL1_VALUE - 1; if (p>=0) A2_PDL1_VALUE = p; break;
	case 135: p = A2_PDL1_VALUE + 1; if (p<256) A2_PDL1_VALUE = p; break;
	case 136: p = A2_PDL2_VALUE - 1; if (p>=0) A2_PDL2_VALUE = p; break;
	case 137: p = A2_PDL2_VALUE + 1; if (p<256) A2_PDL2_VALUE = p; break;
	case 138: p = A2_PDL3_VALUE - 1; if (p>=0) A2_PDL3_VALUE = p; break;
	case 139: p = A2_PDL3_VALUE + 1; if (p<256) A2_PDL3_VALUE = p; break;
	case 144: a2_keyboard_pos = ((a2_keyboard_pos - 1) % a2_numchars); a2_draw_keyboard(a2_wid, a2_gc); break;
	case 145: a2_keyboard_pos = ((a2_keyboard_pos + 1) % a2_numchars); a2_draw_keyboard(a2_wid, a2_gc); break;
	case 146: a2_do_keypress(a2_charlist[a2_keyboard_pos]); break;
	case 255:
		c02_reset(a2_mmu_peek, a2_mmu_poke);
		break;
	default:
		a2_key_down(ch);
		break;
	}
}

void a2_ipl_keypress(unsigned char ch)
{
	switch (ch) {
	case '\r':
	case '\n':
		a2_do_keypress(a2_act_key);
		break;
	case 'w':
		a2_do_keypress(a2_rew_key);
		break;
	case 'm':
		a2_do_keypress(a2_menu_key);
		break;
	case 'd':
		a2_do_keypress(a2_play_key);
		break;
	case 'f':
		a2_do_keypress(a2_ff_key);
		break;
	case 'l':
		a2_do_keypress(a2_wl_key);
		break;
	case 'r':
		a2_do_keypress(a2_wr_key);
		break;
	default:
		a2_do_keypress(ch);
		break;
	}
}


