/*
 * Apple iiPod - Appleblossom Interface for iPodLinux
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include "../a2includes.h"
#include "ifvars.h"
#include "nano-X.h"

int a2_event_handler(GR_EVENT * event)
{
	switch (event->type) {
	case GR_EVENT_TYPE_KEY_DOWN:
		if (a2_emulating) {
			if (event->keystroke.ch < 256) {
				a2_ipl_keypress(event->keystroke.ch);
			}
			return 0;
		} else {
			
		}
		return 1;
		break;
	case GR_EVENT_TYPE_EXPOSURE:
	case GR_EVENT_TYPE_TIMER:
		if (a2_emulating) a2_do_draw();
		return 0;
		break;
	case GR_EVENT_TYPE_MOUSE_POSITION:
		A2_PDL0_VALUE = ((event->mouse.x)*255)/159;
		A2_PDL1_VALUE = ((event->mouse.y)*255)/127;
		break;
	case GR_EVENT_TYPE_BUTTON_UP:
		a2_pb_up(0);
		break;
	case GR_EVENT_TYPE_BUTTON_DOWN:
		a2_pb_down(0);
		break;
	}
	return 1;
}

int main(int argc, char * argv[])
{
	int i;
	int vbl = 0;
	GR_EVENT e;
	
	/* Open Graphics Mode */
	if (!GrOpen()) {
		printf("Could not enter graphics mode.\n");
		return 0;
	}
	
	/* Initialize Appleblossom */
	if (!a2_init(1)) {
		printf("Could not find APPLE2E.ROM.\n");
		return 0;
	}
	if (argc>1) {
		for (i=1; i<argc; i++) {
			if (!strcmp(argv[i],"-d1po")) { A2_DISK_PRODOS_ORDER[0] = 1; }
			if (!strcmp(argv[i],"-d2po")) { A2_DISK_PRODOS_ORDER[1] = 1; }
			if (!strcmp(argv[i],"-d1do")) { A2_DISK_PRODOS_ORDER[0] = 0; }
			if (!strcmp(argv[i],"-d2do")) { A2_DISK_PRODOS_ORDER[1] = 0; }
			if (!strcmp(argv[i],"-d1n")) { A2_DISK_PRODOS_ORDER[0] = 2; }
			if (!strcmp(argv[i],"-d2n")) { A2_DISK_PRODOS_ORDER[1] = 2; }
			if (i<(argc-1)) {
				if (!strcmp(argv[i],"-d1")) { a2_load_disk(0,-1,argv[i+1]); }
				if (!strcmp(argv[i],"-d2")) { a2_load_disk(1,-1,argv[i+1]); }
				if (!strcmp(argv[i],"-h1")) { a2_load_hdisk(0,argv[i+1]); }
				if (!strcmp(argv[i],"-h2")) { a2_load_hdisk(1,argv[i+1]); }
				if (!strcmp(argv[i],"-s1")) {
					A2_SERIAL_OUT[0] = fopen(argv[i+1], "ab");
					A2_SERIAL_IN[0] = fopen(argv[i+1], "rb");
				}
				if (!strcmp(argv[i],"-s2")) {
					A2_SERIAL_OUT[1] = fopen(argv[i+1], "ab");
					A2_SERIAL_IN[1] = fopen(argv[i+1], "rb");
				}
			}
		}
	}
	
	/* Initialize Interface */
	a2_emulating = 1;
	a2_selected_palette = 0;
	a2_keyboard_orientation = 0;
	a2_keyboard_pos = 0;
	a2_rew_key = 8;
	a2_menu_key = 0;
	a2_play_key = 255;
	a2_ff_key = 32;
	a2_wl_key = 144;
	a2_wr_key = 145;
	a2_act_key = 146;
	
	/* Initialize MicroWindows */
	
	a2_wid = GrNewWindow(GR_ROOT_WINDOW_ID, 0, 0, 160, 128, 0, BLACK, BLACK);
	a2_bufwid = GrNewPixmap(160, 128, NULL);
	a2_gc = GrNewGC();
	GrSelectEvents(a2_wid,
		GR_EVENT_MASK_TIMER | GR_EVENT_MASK_EXPOSURE | GR_EVENT_MASK_KEY_DOWN
		| GR_EVENT_MASK_BUTTON_UP | GR_EVENT_MASK_BUTTON_DOWN | GR_EVENT_MASK_MOUSE_POSITION
	);
	GrMapWindow(a2_wid);
	a2_do_draw();
	//a2_tid = GrCreateTimer(a2_wid, 250);
	
	/* Main Event Loop */
	while (1) {
		GrCheckNextEvent(&e);
		if (e.type != GR_EVENT_TYPE_NONE) a2_event_handler(&e);
		if (a2_emulating) a2_cycle();
		if ((A2_CLOCK - vbl) > 60000) {
			a2_do_draw();
			vbl = A2_CLOCK;
		}
	}
	
	/* Close Up Shop */
	//GrDestroyTimer(a2_tid);
	GrDestroyGC(a2_gc);
	GrDestroyWindow(a2_bufwid);
	GrDestroyWindow(a2_wid);
	GrClose();
}
	