/*
 * Appleblossom - Portable Open-Source Apple IIe Emulator
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "a2includes.h"

int a2_init(int initFiles)
{
	/* Call this when your emulator starts up. */
	int ret = a2_read_rom("APPLE2E.ROM");
	a2_clear_periph_rom();
	a2_read_disk_rom("DISK2.ROM");
	a2_read_hdisk_rom("HDDRVR.ROM");
	a2_read_serial_rom("SERIAL.ROM");
	a2_read_serial_xrom("SERIALX.ROM");
	a2_clear_memory();
	if (initFiles) {
		a2_disk_reset();
		a2_hdisk_reset();
		a2_serial_reset();
	}
	a2_iou_reset();
	a2_mmu_reset();
	c02_init(a2_mmu_peek, a2_mmu_poke);
	A2_CLOCK = 0;
	return ret
}

void a2_cycle(void)
{
	/* Call this in your main event loop. It executes the next instruction. */
	a2_iou_poll();
	c02_exec(a2_mmu_peek, a2_mmu_poke, &A2_CLOCK);
}
