/*
 * Appleblossom - Portable Open-Source Apple IIe Emulator
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __A2INCLUDES_H__
#define __A2INCLUDES_H__

#include <stdio.h>
#include <string.h>
#include "a2vars.h"

/* a2main.c */
extern int a2_init(int initFiles);
extern void a2_cycle(void);

/* 65c02.c */
extern void c02_init(unsigned char (*peek)(unsigned short), void (*poke)(unsigned short, unsigned char));
extern void c02_clear(void);
extern void c02_brk(unsigned char (*peek)(unsigned short), void (*poke)(unsigned short, unsigned char));
extern void c02_irq(unsigned char (*peek)(unsigned short), void (*poke)(unsigned short, unsigned char));
extern void c02_nmi(unsigned char (*peek)(unsigned short), void (*poke)(unsigned short, unsigned char));
extern void c02_reset(unsigned char (*peek)(unsigned short), void (*poke)(unsigned short, unsigned char));
extern void c02_exec(unsigned char (*peek)(unsigned short), void (*poke)(unsigned short, unsigned char), int * timing);
extern void c02_dump(FILE * fp, unsigned char (*peek)(unsigned short));
extern void c02_dumpjump(FILE * fp, unsigned char (*peek)(unsigned short));

/* a2mmu.c */
extern unsigned char a2_mmu_peek(unsigned short addr);
extern void a2_mmu_poke(unsigned short addr, unsigned char ch);
extern void a2_mmu_reset(void);
extern void a2_clear_memory(void);
extern int a2_read_rom(char * fn);
extern void a2_read_periph_rom(char * fn, int card);
extern void a2_read_periph_xrom(char * fn, int card);
extern void a2_clear_periph_rom(void);
extern void a2_dump_memory(char * fn);
extern void a2_dump_switches(char * fn);

/* a2iou.c */
extern void a2_iou_reset(void);
extern void a2_iou_poll(void);
extern void a2_key_down(char ch);
extern void a2_pb_down(int i);
extern void a2_pb_up(int i);
extern void a2_set_paddle(int i, int v);
extern void a2_cassette_input(void);
extern void a2_reset_strobe(void);
extern int a2_speaker_output(void);
extern int a2_strobe_output(void);
extern int a2_cassette_output(void);
extern int a2_annunciator(int i);
extern void a2_set_vbl(int i);

/* a2disk.c */
extern void a2_disk_reset(void);
extern void a2_read_disk_rom(char * fn);
extern void a2_load_disk(int drive2, int pdorder, char * fn);
extern void a2_write_disk(int drive2);
extern void a2_eject_disk(int drive2);
extern void a2_disk_test(void);

/* a2hdisk.c */
extern void a2_hdisk_reset(void);
extern void a2_read_hdisk_rom(char * fn);
extern void a2_load_hdisk(int drive2, char * fn);
extern void a2_write_hdisk(int drive2);
extern void a2_eject_hdisk(int drive2);

/* a2serial.c */
extern void a2_serial_reset(void);
extern void a2_read_serial_rom(char * fn);
extern void a2_read_serial_xrom(char * fn);

/* a2clock.c */
extern void a2_read_rtc_input(void);
extern void a2_read_rtc_prodos(void);
extern void a2_rtc_install_driver(void);

/* a2video.c */
extern int a2_video_mode(void);
extern int a2_video_split_mode(void);
extern int a2_video_page(void);
extern unsigned short a2_text_base(int row);
extern unsigned short a2_hires_base(int row);
extern char a2_char_strip_fmt(unsigned char ch);

/* Macros */

#define a2_text_base(r) (0x0400|(((r)&0x7)<<7)|(((r)&0x18)<<2)|((r)&0x18))
#define a2_hires_base(r) (0x2000|(((r)&0x07)<<10)|(((r)&0x38)<<4)|(((r)&0xC0)>>1)|(((r)&0xC0)>>3))

#endif
