/*
 * Appleblossom - Portable Open-Source Apple IIe Emulator
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include "a2vars.h"
#include "a2font.h"

void a2_load_default_font(void)
{
	memcpy(A2_FONT, A2_DEFAULT_FONT, 2048);
}

void a2_load_font(char * fn)
{
	FILE * f;
	f = fopen(fn, "rb");
	if (f) {
		fread(A2_FONT, 8, 256, f);
		fclose(f);
	}
}

A2_CHARACTER_BITMAP a2_get_font_char(unsigned char ch)
{
	if (A2_ALTCHAR || (ch >= 0x80)) {
		return A2_FONT[ch];
	} else {
		return A2_FONT[ch & 0x3F];
	}
}

