/*
 *  Apple II emulator preferences file routines
 *
 *  by Aaron Culliney - chernabog@baldmountain.bbn.com - (C) 1998
 *
 *  prefs.l - simple lexical parser for the preferences file.
 *
 *  $Id: prefs.l,v 1.10 1998/08/23 17:12:55 chernabog Exp $
 *
 *   v0.4 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Jun 1997.
 *   v0.5 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Feb 1998.
 *   v0.6 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Aug 1998.
 *	This code has nothing to do with my employer, GTE Internetworking,
 *	BBN Technologies.  It was written completely on my own time and on
 *	my own machine.
 *
 *  ASSUMPTIONS:
 *	flex version 2.5.2 or later
 *
 *	this file is processed in several steps.  the Makefile first
 *	runs it through cpp so that we can eliminate whole rules which
 *	are unnecessary.  the generated file is then run through flex
 *	to generate the actual c code which is then compiled.
 *
 */

%{

/* process includes only the second time we parse this file. */
#define INC(HASH,STR) HASH ## include STR
INC(#,"misc.h")
INC(#,"disk.h")
INC(#,"keys.h")
INC(#,"interface.h")
INC(#,<unistd.h>)
INC(#,<strings.h>)
INC(#,<ctype.h>)

int line_num = 1;
void lowercase_string(char *s);
void strip_percent(char *s);


#ifdef PC_JOYSTICK
/* in joystick.c */
extern void c_calculate_joystick_parms();
extern void c_open_joystick();
extern long js_timelimit;
extern int js_center_x;
extern int js_center_y;
extern int js_max_x;
extern int js_max_y;
extern int js_min_x;
extern int js_min_y;
#endif

%}


DIGIT		[0-9]
HEXDIGIT	[0-9a-fA-F]
WS		[\n\r\t" "]
CHAR		[^\n\r\t" "]
BOS		^{WS}*
EOS		{WS}*\0
BOL		^{WS}*
EOL		{WS}*$

%%

{BOL}speed{WS}*\={WS}*{DIGIT}+\%?{EOL} {
    /* speed of emulation */
    int speed;
    while (!isdigit(*prefstext)) ++prefstext;		/* advance to parm */
    strip_percent(prefstext);
    speed = atoi(prefstext);
    if (speed < 0)
	speed = 1;
    else if (speed > MAX_APPLE_DELAY)
	speed = MAX_APPLE_DELAY;
    apple_speed = MAX_APPLE_DELAY + 1 - speed;
}

{BOL}mode{WS}*\={WS}*\]\[\+{EOL} {
    apple_mode = 0;
}

{BOL}mode{WS}*\={WS}*\]\[\+{WS}*undocumented{EOL} {
    apple_mode = 1;
}

{BOL}mode{WS}*\={WS}*\/\/\e{EOL} {
#ifdef APPLE_IIE
    apple_mode = 2;
#endif
}

{BOL}("disk path"|disk_path|path){WS}*\={WS}*{CHAR}+{EOL} {
    /* disk path = toplevel path to disks directory */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    strcpy(disk_path, prefstext);
}

{BOL}color{WS}*\={WS}*{CHAR}+{WS}*{CHAR}*{EOL} {
    /* color settings */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    lowercase_string(prefstext);
    if (!strcmp(prefstext, "black/white"))
	color_mode = 0;
    else if (!strcmp(prefstext, "off"))
	color_mode = 0;

    else if (!strcmp(prefstext, "lazy color"))
	color_mode = LAZY_COLOR;

    else if (!strcmp(prefstext, "color"))
	color_mode = COLOR;
    else if (!strcmp(prefstext, "on"))
	color_mode = COLOR;

    else if (!strcmp(prefstext, "lazy interpolated"))
	color_mode = LAZY_INTERP;
    else if (!strcmp(prefstext, "interpolated"))
	color_mode = INTERP;
    else printf(
	"Illegal value to color parameter at line %d in .apple2\n", line_num);

    if (color_mode == COLOR)
	strict_color = 1;	/* strict colors */
    else if (color_mode == INTERP)
	strict_color = 2;	/* strict interpolation */
    else
	strict_color = 0;	/* lazy coloration */
}

{BOL}sound{WS}*\={WS}*{CHAR}+{WS}*{CHAR}*{EOL} {
    /* sound output settings */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    lowercase_string(prefstext);
    if (!strcmp(prefstext, "off" ))
	sound_mode = 0;
    else if (!strcmp(prefstext, "on" ))
	sound_mode = 1;
    else if (!strcmp(prefstext, "pc speaker" ))
	sound_mode = 1;
    else printf(
	"Illegal value to sound parameter at line %d in .apple2\n", line_num);
}

{BOL}joystick{WS}*\={WS}*{CHAR}+{WS}*{CHAR}*{EOL} {
    /* joystick preference setting */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    lowercase_string(prefstext);
    if (!strcmp(prefstext, "linear" ) || !strcmp(prefstext,"keyboard"))
	joy_mode = JOY_KYBD;
    else if (!strcmp(prefstext, "pc joystick" ) ||
	     !strcmp(prefstext, "pc_joystick" ))
    {
#ifdef PC_JOYSTICK
	joy_mode = JOY_PCJOY;
#else
	joy_mode = JOY_KYBD;
#endif
    }
    else if (!strcmp(prefstext, "digital" ))
    {
#if 0
	joy_mode = JOY_DIGITAL;		/* currently unsupported */
#else
	joy_mode = JOY_KYBD;
#endif
    }
    else if (!strcmp(prefstext, "off" ))
	joy_mode = JOY_OFF;
    else printf(
	"Illegal value to joystick parameter at line %d in .apple2\n",
	line_num);
}

{BOL}("joy range"|"joystick range"|joy_range){WS}*\={WS}*{DIGIT}+{EOL} {
    /* range = range of x and y joystick values */
    while (!isdigit(*prefstext)) ++prefstext;	/* advance to origin parm */
    joy_range = atoi(prefstext);
    if (joy_range < 10)
	joy_range = 10;
    else if (joy_range > 256)
	joy_range = 256;
    half_joy_range = joy_range/2;

    if (joy_center_x > joy_range)
	joy_center_x = half_joy_range;
    if (joy_center_y > joy_range)
	joy_center_y = half_joy_range;
}

{BOL}origin_x{WS}*\={WS}*{DIGIT}+{EOL} {
    /* origin_x = x coordinate of joystick origin (byte value) */
    while (!isdigit(*prefstext)) ++prefstext;	/* advance to origin parm */
    joy_center_x = atoi(prefstext);
    if (joy_center_x < 0)
	joy_center_x = 0;
    else if (joy_center_x > 255)
	joy_center_x = 255;

    if (joy_center_x > joy_range)
	joy_center_x = half_joy_range;
}

{BOL}origin_y{WS}*\={WS}*{DIGIT}+{EOL} {
    /* origin_y = y coordinate of joystick origin (byte value) */
    while (!isdigit(*prefstext)) ++prefstext;	/* advance to origin parm */
    joy_center_y = atoi(prefstext);
    if (joy_center_y < 0)
	joy_center_y = 0;
    else if (joy_center_y > 255)
	joy_center_y = 255;

    if (joy_center_y > joy_range)
	joy_center_y = half_joy_range;
}

{BOL}("pc joystick parms"|pc_joystick_parms){WS}*\={WS}*{DIGIT}+{WS}+{DIGIT}+{WS}+{DIGIT}+{WS}+{DIGIT}+{WS}+{DIGIT}+{WS}+{DIGIT}+{WS}+{DIGIT}+{EOL} {
#ifdef PC_JOYSTICK
    /* pc joystick parms generated by the calibration routine
       (shouldn't need to hand tweak these) = origin_x origin_y max_x
       min_x max_y min_y js_timelimit */
    while (!isdigit(*prefstext)) ++prefstext;	/* advance to 1st parm */
    js_center_x = strtol(prefstext, &prefstext, 10);
    js_center_y = strtol(prefstext, &prefstext, 10);
    js_max_x = strtol(prefstext, &prefstext, 10);
    if (js_max_x < 0)
	js_max_x = 0;
    js_min_x = strtol(prefstext, &prefstext, 10);
    if (js_min_x < 0)
	js_min_x = 0;

    js_max_y = strtol(prefstext, &prefstext, 10);
    if (js_max_y < 0)
	js_max_y = 0;
    js_min_y = strtol(prefstext, &prefstext, 10);
    if (js_min_y < 0)
	js_min_y = 0;

    js_timelimit = strtol(prefstext, &prefstext, 10);
    if (js_timelimit < 2)
	js_timelimit = 2;

    c_open_joystick();
    c_calculate_joystick_parms();	/* calculate the associated parms */
#endif
}

{BOL}sensitivity{WS}*\={WS}*{DIGIT}+\%{EOL} {
    /* keyboard-emulated joystick sensitivity */
    while (!isdigit(*prefstext)) ++prefstext;		/* advance to parm */
    strip_percent(prefstext);
    joy_step = atoi(prefstext);
    if (joy_step < 1)
	joy_step = 1;
    else if (joy_step > 100)
	joy_step = 100;
}

{BOL}("system path"|system_path){WS}*\={WS}*{CHAR}+{EOL} {
    /* system path = path to rom files */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    strcpy(system_path, prefstext);
}


\n	{
    ++line_num;		/* count lines */
}

.	{		/* flag extraneous characters */
    printf("Random character `%c' at line %d in .apple2\n",
	   *prefstext, line_num);
}


%%


int prefswrap () {
    return 1;
}

void lowercase_string( char *s ) {
    char *p;

    for (p = s; *p != '\0'; p++)
	*p = tolower(*p);
}

void strip_percent( char *s ) {
    char *p = s + strlen(s) - 1;
    if (p >= s && *p == '%')
	*p = '\0';
}

void pad_string(char *s, char c, int len) {
    char *p;

    for (p = s; ((*p != '\0') && (p-s < len-1)); p++);
    while (p-s < len-1) {
	*p++ = c;
    }
    *p = '\0';
}

/* for testing */
/* void main( int argc, char **argv ) { */
/*     ++argv, --argc; */
/*     if ( argc > 0 ) */
/* 	prefsin = fopen( argv[0], "r" ); */
/*     else */
/* 	prefsin = stdin; */
    
/*     prefslex(); */
/* } */
