/*
 *  Apple II emulator by Alexander Jean-Claude Bottema (C) 1994
 *
 *  $Id: misc.h,v 1.3 1998/08/23 17:12:55 chernabog Exp $
 *
 *  Misc routines.  Common code moved here from misc.c.
 *
 *  MODIFICATION HISTORY
 *   v0.6 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Aug 1998.
 *     This code has nothing to do with my employer, GTE Internetworking,
 *     BBN Technologies.  It was written completely on my own time and on
 *     my own machine.
 *
 */

#ifndef MISC_H
#define MISC_H

#include <unistd.h>
#include <sys/types.h>

typedef void (*Function)();

#define IIE_MODE 2
#define IIU_MODE 1
#define II_MODE  0
#define LAZY_COLOR 1
#define COLOR 2
#define LAZY_INTERP 3
#define INTERP 4

#define SW_TEXT 0xC050
#define SW_MIXED 0xC052
#define SW_PAGE2 0xC054
#define SW_HIRES 0xC056
#ifdef APPLE_IIE
#define SW_80STORE 0xC000
#define SW_RAMRD 0xC002
#define SW_RAMWRT 0xC004
#define SW_ALTZP 0xC008
#define SW_80COL 0xC00C
#define SW_ALTCHAR 0xC00E
#define SW_SLOTC3ROM 0xC00B	/* anomaly */
#define SW_SLOTCXROM 0xC006
#define SW_DHIRES 0xC05E
#define SW_IOUDIS 0xC07E
#endif


/* video softswitch settings */
unsigned char	vmode_text;
unsigned char	vmode_mixed;
unsigned char	vmode_hires;
unsigned char	vmode_page2;
unsigned char	vmode_active;
unsigned char	vmode_screen;			/* current screen */

unsigned char	char_rom[0x800];/* rom characters */
unsigned char	expanded_font[0x800*16];/* ready to draw (*16 for 640x400) */

/* PSR */
unsigned char	table_encode_flags[256];
unsigned char	table_decode_flags[256];

/* --- Precalculated text page rows given offset addr --- */
unsigned int	text_row_offset[1024];
/*unsigned short	text_page_cols[1024];*/

/* --- Precalculated hi-res page offsets given addr --- */
unsigned int	hires_row_offset[8192];
unsigned char	hires_col_offset[8192];

/* --- Precalculated double hires auxiliary page offsets given addr --- */
unsigned short dhires_aux_page_offset[8192];

int table_opcodes[256];	/* current opcode table */
Function table_read_memory[65536]; /* read jump table */
Function table_write_memory[65536]; /* write jump table */
unsigned char apple_ii_64k[2][65536]; /* 128k memory */

/* language card memory and settings */
unsigned char language_card[2][8192], language_banks[2][8192];
unsigned char language_current_bank, language_card_second,
                     language_card_read, language_card_write;

/* misc stuff */
int		apple_mode; /* regular ][+ mode */
unsigned char	sound_mode; /* PC speaker or OFF */
unsigned char	exception_flag;
unsigned short	apple_speed;
unsigned char	color_mode;
unsigned char	strict_color;
int		soundAllowed;
unsigned char	random_value;

/* global ref to commandline args */
char		**argv;
int		argc;

/* misc arrays */
unsigned char	system_path[ 2048 ];
unsigned char	temp[ 4096 ];/* should be >=4096 (stuff depends on this) */


#ifdef APPLE_IIE
/* memory offsets from softswitches */
int lc_offset;
int zp_offset;
int ramrd_offset;
int ramwrt_offset;
int write_text_page_offset;
int read_text_page_offset;
int write_hires_page_offset;
int read_hires_page_offset;
int c3rom_offset;
int cxrom_offset;
int c8rom_offset;

unsigned char eighty_store_flag;
unsigned char eighty_col_flag;
unsigned char ramrd_flag;
unsigned char ramwrt_flag;
unsigned char altzp_flag;
unsigned char dhires_flag;
unsigned char ioudis_flag;
unsigned char cxrom_flag;
unsigned char c3rom_flag;
unsigned char c8rom_flag;
unsigned char altchar_flag;

unsigned char vmode_dhires;
#endif


/* -------------------------------------------------------------------------
    misc.c functions
   ------------------------------------------------------------------------- */

void c_initialize_sound();
void c_initialize_hires_values();
void c_initialize_font();
void c_save_settings();
void c_initialize_vm();
void c_read_random();

#endif
