/*
 *  Apple II debugger routines
 *
 *  by Aaron Culliney - chernabog@baldmountain.bbn.com - (C) 1998
 *
 *  This code has nothing to do with my employer, GTE Internetworking,
 *  BBN Technologies.  It was written completely on my own time and on
 *  my own machine.
 *
 *  debug.h - debugger header.
 *
 *  $Id: debug.h,v 1.3 1998/08/23 17:12:51 chernabog Exp $
 *
 *   v0.4 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Jun 1997.
 *   v0.5 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Feb 1998.
 *   v0.6 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Aug 1998.
 *
 */

#ifndef A2_DEBUG_H
#define A2_DEBUG_H

#include <stdio.h>

/* debugger defines */
#define BUF_X		39
#define BUF_Y		22
#define MAX_BRKPTS	16
#define SCREEN_X	41
#define SCREEN_Y	24
#define PROMPT_X	2
#define PROMPT_Y	BUF_Y - 1
#define PROMPT_END_X	BUF_X - 2
#define command_line	command_buf[PROMPT_Y]
#define uchar		unsigned char

/* debugger commands */
enum token_type { MEM, DIS, REGS, SETMEM, STEP, FINISH, UNTIL, GO, VM,
		  BREAK, WATCH, CLEAR, IGNORE, STATUS, OPCODES, LC, DRIVE,
		  SEARCH, HELP, LOG, BSAVE, BLOAD, SAVE, UNKNOWN };

/* opcode struct used for disassembling memory */
struct opcode_struct {
    char code[16];
    char fmt[32];
    unsigned char val;
    int numargs;
};

struct opcode_struct *opcodes[256];

int step_next;				/* stepping over instructions */
int debug_PC;				/* debugger's program counter */
int debug_scratch;			/* scratch variable */
char second_buf[BUF_Y][BUF_X];		/* scratch buffer for output */
int num_buffer_lines;			/* num lines of output */
int arg1, arg2, arg3;			/* command arguments */
int breakpoints[MAX_BRKPTS];		/* memory breakpoints */
int watchpoints[MAX_BRKPTS];		/* memory watchpoints */
unsigned char watch_data;		/* new byte */

void clear_debugger_screen();
void bload(FILE*, char*, int);
void show_misc_info();
unsigned char get_current_opcode();
void dump_mem(int, int, int, int, int);
void search_mem(char*, int, int);
void set_mem(int, char*);
void set_lc_mem(int, int, char*);
void disasm(int, int, int, int);
void clear_halt(int*, int);
void set_halt(int*, int);
void show_breakpts();
void show_regs();
void display_help();
void show_lc_info();
void show_disk_info();
void c_do_step(int);
int at_haltpt();
void end_step();
void set_halt_opcode(unsigned char opcode);
void set_halt_65c02();
void clear_halt_65c02();
void clear_halt_opcode(unsigned char opcode);
void show_opcode_breakpts();

#endif
