#define yy_create_buffer prefs_create_buffer
#define yy_delete_buffer prefs_delete_buffer
#define yy_scan_buffer prefs_scan_buffer
#define yy_scan_string prefs_scan_string
#define yy_scan_bytes prefs_scan_bytes
#define yy_flex_debug prefs_flex_debug
#define yy_init_buffer prefs_init_buffer
#define yy_flush_buffer prefs_flush_buffer
#define yy_load_buffer_state prefs_load_buffer_state
#define yy_switch_to_buffer prefs_switch_to_buffer
#define yyin prefsin
#define yyleng prefsleng
#define yylex prefslex
#define yyout prefsout
#define yyrestart prefsrestart
#define yytext prefstext
#define yywrap prefswrap

#line 20 "prefs.c"
/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /usr/local/cvs/apple2/src/prefs.c,v 1.3 1997/06/29 22:14:14 chernabog Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 14
#define YY_END_OF_BUFFER 15
static yyconst short int yy_accept[221] =
    {   0,
        0,    0,   15,   13,   12,   13,   12,   13,   13,   13,
       13,   13,   13,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    2,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    3,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        4,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    1,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    4,    0,    0,    0,    0,    0,    0,
        0,    5,    0,    7,    0,    8,    0,    0,    0,    0,
        0,    6,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    5,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   11,    0,    0,    0,   10,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    9,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    2,    1,    1,    5,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    1,    1,    1,
        7,    1,    1,    1,    9,    1,   10,   11,   12,    1,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
        1,   23,   24,   25,   26,   27,    1,   28,   29,    1,
        1,    1,    1,    1,    8,    1,    9,    1,   10,   11,

       12,    1,   13,   14,   15,   16,   17,   18,   19,   20,
       21,   22,    1,   23,   24,   25,   26,   27,    1,   28,
       29,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[30] =
    {   0,
        1,    2,    2,    2,    1,    1,    2,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    2,    1,    1,    1,    1,    1,    1
    } ;

static yyconst short int yy_base[232] =
    {   0,
      512,    0,  514,  516,  516,   23,    0,  492,  497,  490,
      487,    3,    7,    0,  488,  493,  486,  483,    5,   19,
      487,  480,  474,  487,  476,    1,  480,  473,  486,  473,
      475,  478,   34,  481,  479,  476,  475,  466,  469,  476,
      462,  463,   42,  435,  430,  423,  428,   49,  417,  412,
      413,  412,  407,  401,   57,  386,  381,  389,  384,  373,
      363,   63,    4,  353,  348,  351,   69,   75,  331,   81,
       87,  327,  326,  310,  305,  314,  302,   90,   93,  285,
      280,  288,   96,  102,  105,  111,  112,  119,  122,  252,
      247,  248,  243,  234,   26,  125,  128,  221,  210,  203,

      131,  134,  137,   12,  207,  193,  142,  145,  196,  195,
      192,  187,  148,  154,  160,  183,  175,  174,  166,  169,
      172,  175,  175,  174,  178,  184,   79,  190,  193,  199,
      204,  210,  156,  155,  135,  215,  218,  221,  134,  129,
      224,  230,  144,  235,  238,  241,  246,  251,  256,  125,
      102,   89,  261,  264,   97,   96,  267,  272,   81,  277,
      280,  283,  286,  289,  292,  295,   83,   73,  298,  304,
      310,  313,   67,  316,   53,   52,  319,  325,  330,  336,
       57,  339,  342,   59,   48,  345,   57,  350,  353,   26,
       20,  356,  359,  362,   18,   16,  365,  368,    8,    6,

      371,  377,  383,  388,  393,  398,  403,  408,  413,  418,
      423,  428,  433,  438,  443,  448,  453,  458,  461,  516,
      465,  467,  469,  471,  473,  475,   18,  477,  479,  481,
      483
    } ;

static yyconst short int yy_def[232] =
    {   0,
      221,  221,  220,  220,  220,  220,    6,  220,  220,  220,
      220,  220,  220,    6,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  222,  220,  220,  220,  220,  220,  220,  220,
      223,  220,  220,  220,  220,  220,  220,  222,  222,  220,
      220,  220,  220,  224,  220,  220,  220,  223,  223,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,

      225,  224,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  225,  226,
      226,  220,  220,  220,  220,  220,  227,  228,  220,  220,
      220,  220,  220,  220,  220,  226,  220,  220,  220,  220,
      220,  220,  220,  229,  228,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  229,
      230,  230,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  230,  220,  220,  220,  220,  220,  231,
      220,  220,  220,  220,  220,  220,  220,  231,  231,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,

      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,    0,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220
    } ;

static yyconst short int yy_nxt[546] =
    {   0,
      220,    6,    7,    6,   36,   79,   79,   79,   37,    8,
        9,   25,   26,   25,   26,   10,  122,  104,   27,  126,
       11,   12,  220,   13,   14,   14,   14,   28,   29,  201,
       27,  201,   15,   16,  200,   30,  199,   44,   17,   28,
       29,   45,  196,   18,   19,   56,   20,   30,  195,   57,
       62,   62,   62,  114,  115,   63,  191,   46,   70,   70,
       70,  192,  187,   71,   62,   62,   62,  190,  125,   63,
       83,   83,   83,  185,  184,   84,   85,   85,   85,  181,
      176,   86,   70,   70,   70,  128,  175,   71,   89,   89,
       89,   96,   97,   96,   79,   79,   79,   83,   83,   83,

      173,  143,   84,  102,  102,  102,   85,   85,   85,  170,
      170,   86,  103,  103,  103,  105,  104,  169,  168,  106,
      107,  108,  107,   89,   89,   89,   96,   97,   96,   96,
       97,   96,  120,  121,  120,  102,  102,  102,  103,  103,
      103,  167,  104,  107,  108,  107,  107,  108,  107,  126,
      126,  127,  159,  156,  128,  129,  129,  129,  155,  152,
      130,  131,  131,  131,  151,  150,  132,  120,  121,  120,
      120,  121,  120,  120,  121,  120,  137,  138,  137,  141,
      141,  141,  140,  139,  142,  126,  126,  126,  135,  134,
      128,  145,  145,  145,  129,  129,  129,  133,  125,  130,

      146,  146,  146,  125,  147,  131,  131,  131,   48,   48,
      132,  148,  148,  148,  124,  149,  153,  154,  153,  137,
      138,  137,  137,  138,  137,  141,  141,  141,  123,  118,
      142,  157,  157,  157,  117,  158,  161,  162,  161,  145,
      145,  145,  146,  146,  146,  116,  147,  163,  164,  163,
      113,  147,  148,  148,  148,  112,  149,  165,  166,  165,
      111,  149,  153,  154,  153,  153,  154,  153,  157,  157,
      157,  110,  158,  171,  172,  171,  109,  158,  161,  162,
      161,  161,  162,  161,  161,  162,  161,  163,  164,  163,
      163,  164,  163,  165,  166,  165,  165,  166,  165,  177,

      177,  177,  100,   99,  178,  179,  179,  179,   98,   95,
      180,  171,  172,  171,  171,  172,  171,  182,  183,  182,
      177,  177,  177,   94,   93,  178,  186,  186,  186,   92,
      187,  179,  179,  179,   91,   90,  180,  189,  189,  189,
      182,  183,  182,  182,  183,  182,  186,  186,  186,   87,
      187,  193,  194,  193,  189,  189,  189,  197,  198,  197,
      193,  194,  193,  193,  194,  193,  197,  198,  197,  197,
      198,  197,  202,  202,  202,   82,   81,  203,  202,  202,
      202,   80,   77,  203,  204,  204,  204,   76,  205,  204,
      204,  204,   75,  205,  206,  206,  206,   74,  205,  206,

      206,  206,   73,  207,  208,  208,  208,   72,  207,  208,
      208,  208,   69,  209,  210,  210,  210,   68,  209,  210,
      210,  210,   67,  211,  212,  212,  212,   66,  211,  212,
      212,  212,   65,  213,  214,  214,  214,   64,  213,  214,
      214,  214,   61,  215,  216,  216,  216,   60,  215,  216,
      216,  216,   59,  217,  218,  219,  218,   58,  217,  218,
      219,  218,  218,  219,  218,    4,    4,   78,   78,   88,
       88,  101,  101,  119,  119,  136,  136,  144,  144,  160,
      160,  174,  174,  188,  188,   55,   54,   53,   52,   51,
       50,   49,   48,   47,   43,   42,   41,   40,   39,   38,

       35,   34,   33,   32,   31,   24,   23,   22,   21,   24,
       23,   22,   21,  220,    5,    3,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220
    } ;

static yyconst short int yy_chk[546] =
    {   0,
        0,    2,    2,    2,   26,   63,   63,   63,   26,    2,
        2,   12,   12,   19,   19,    2,  104,  104,   13,  227,
        2,    2,    0,    2,    6,    6,    6,   13,   13,  200,
       20,  199,    6,    6,  196,   13,  195,   33,    6,   20,
       20,   33,  191,    6,    6,   43,    6,   20,  190,   43,
       48,   48,   48,   95,   95,   48,  185,   33,   55,   55,
       55,  187,  187,   55,   62,   62,   62,  184,  181,   62,
       67,   67,   67,  176,  175,   67,   68,   68,   68,  173,
      168,   68,   70,   70,   70,  127,  167,   70,   71,   71,
       71,   78,   78,   78,   79,   79,   79,   83,   83,   83,

      159,  127,   83,   84,   84,   84,   85,   85,   85,  156,
      155,   85,   86,   86,   86,   87,   86,  152,  151,   87,
       88,   88,   88,   89,   89,   89,   96,   96,   96,   97,
       97,   97,  101,  101,  101,  102,  102,  102,  103,  103,
      103,  150,  103,  107,  107,  107,  108,  108,  108,  113,
      113,  113,  143,  140,  113,  114,  114,  114,  139,  135,
      114,  115,  115,  115,  134,  133,  115,  119,  119,  119,
      120,  120,  120,  121,  121,  121,  122,  122,  122,  125,
      125,  125,  124,  123,  125,  126,  126,  126,  118,  117,
      126,  128,  128,  128,  129,  129,  129,  116,  112,  129,

      130,  130,  130,  111,  130,  131,  131,  131,  110,  109,
      131,  132,  132,  132,  106,  132,  136,  136,  136,  137,
      137,  137,  138,  138,  138,  141,  141,  141,  105,  100,
      141,  142,  142,  142,   99,  142,  144,  144,  144,  145,
      145,  145,  146,  146,  146,   98,  146,  147,  147,  147,
       94,  147,  148,  148,  148,   93,  148,  149,  149,  149,
       92,  149,  153,  153,  153,  154,  154,  154,  157,  157,
      157,   91,  157,  158,  158,  158,   90,  158,  160,  160,
      160,  161,  161,  161,  162,  162,  162,  163,  163,  163,
      164,  164,  164,  165,  165,  165,  166,  166,  166,  169,

      169,  169,   82,   81,  169,  170,  170,  170,   80,   77,
      170,  171,  171,  171,  172,  172,  172,  174,  174,  174,
      177,  177,  177,   76,   75,  177,  178,  178,  178,   74,
      178,  179,  179,  179,   73,   72,  179,  180,  180,  180,
      182,  182,  182,  183,  183,  183,  186,  186,  186,   69,
      186,  188,  188,  188,  189,  189,  189,  192,  192,  192,
      193,  193,  193,  194,  194,  194,  197,  197,  197,  198,
      198,  198,  201,  201,  201,   66,   65,  201,  202,  202,
      202,   64,   61,  202,  203,  203,  203,   60,  203,  204,
      204,  204,   59,  204,  205,  205,  205,   58,  205,  206,

      206,  206,   57,  206,  207,  207,  207,   56,  207,  208,
      208,  208,   54,  208,  209,  209,  209,   53,  209,  210,
      210,  210,   52,  210,  211,  211,  211,   51,  211,  212,
      212,  212,   50,  212,  213,  213,  213,   49,  213,  214,
      214,  214,   47,  214,  215,  215,  215,   46,  215,  216,
      216,  216,   45,  216,  217,  217,  217,   44,  217,  218,
      218,  218,  219,  219,  219,  221,  221,  222,  222,  223,
      223,  224,  224,  225,  225,  226,  226,  228,  228,  229,
      229,  230,  230,  231,  231,   42,   41,   40,   39,   38,
       37,   36,   35,   34,   32,   31,   30,   29,   28,   27,

       25,   24,   23,   22,   21,   18,   17,   16,   15,   11,
       10,    9,    8,    3,    1,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
char *yytext;
#line 1 "prefs.l"
#define INITIAL 0
/*
 *  Apple II emulator preferences file routines
 *  by Aaron Culliney - chernabog@baldmountain.bbn.com - (C) 1997
 *  This code has nothing to do with my employer, BBN.  It was written
 *  completely on my own time and on my own machine.
 *
 *  prefs.l - simple lexical parser for the preferences file.
 *
 *  $Id: prefs.c,v 1.3 1997/06/29 22:14:14 chernabog Exp $
 *
 *   v0.4 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Jun 1997.
 *
 *  ASSUMPTIONS:
 *	flex version 2.5.2
 *
 *	use the `-Pprefs' to compile this.
 *
 **/
#line 21 "prefs.l"

#include "defs.H"
#include <stdio.h>
#include <ctype.h>
#include <string.h>

int line_num = 1;
void lowercase_string(char *s);
void strip_percent(char *s);

extern unsigned char disk_path[1024];
extern unsigned char system_path[2048];
extern unsigned short apple_speed;
extern short color_mode;
extern short sound_mode;

/* in keys.c */
extern joystick_mode joy_mode;
extern short joy_range, half_joy_range;
extern short joy_step;
extern short joy_center_x;
extern short joy_center_y;

#ifdef PC_JOYSTICK
/* in joystick.c */
extern void c_calculate_joystick_parms();
extern void c_open_joystick();
extern long js_timelimit;
extern short js_center_x;
extern short js_center_y;
extern short js_max_x;
extern short js_max_y;
extern short js_min_x;
extern short js_min_y;
#endif

#line 628 "prefs.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		yy_current_buffer->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 70 "prefs.l"


#line 781 "prefs.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 221 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 516 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 72 "prefs.l"
{
    /* speed of emulation, expressed as a percent (though it isn't!) */
    int speed;
    while (!isdigit(*prefstext)) ++prefstext;		/* advance to parm */
    strip_percent(prefstext);
    speed = atoi(prefstext);
    if (speed < 0)
	speed = 1;
    else if (speed > 100)
	speed = 100;
    apple_speed = 101 - speed;
}
	YY_BREAK
case 2:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 85 "prefs.l"
{
    /* disk path = toplevel path to disks directory */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    strcpy(disk_path, prefstext);
}
	YY_BREAK
case 3:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 92 "prefs.l"
{
    /* color settings */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    lowercase_string(prefstext);
    if (!strcmp(prefstext, "off"))
	color_mode = 0;
    else if (!strcmp(prefstext, "on"))
	color_mode = 1;
    else if (!strcmp(prefstext, "interpolated"))
	color_mode = 2;
    else printf(
	"Illegal value to color parameter at line %d in .apple2\n", line_num);
}
	YY_BREAK
case 4:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 107 "prefs.l"
{
    /* sound output settings */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    lowercase_string(prefstext);
    if (!strcmp(prefstext, "off" ))
	sound_mode = 0;
    else if (!strcmp(prefstext, "on" ))
	sound_mode = 1;
    else if (!strcmp(prefstext, "pc speaker" ))
	sound_mode = 1;
    else printf(
	"Illegal value to sound parameter at line %d in .apple2\n", line_num);
}
	YY_BREAK
case 5:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 122 "prefs.l"
{
    /* joystick preference setting */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    lowercase_string(prefstext);
    if (!strcmp(prefstext, "linear" ) || !strcmp(prefstext,"keyboard"))
	joy_mode = JOY_KYBD;
    else if (!strcmp(prefstext, "pc joystick" ) ||
	     !strcmp(prefstext, "pc_joystick" ))
    {
#ifdef PC_JOYSTICK
	joy_mode = JOY_PCJOY;
#else
	joy_mode = JOY_KYBD;
#endif
    }
    else if (!strcmp(prefstext, "digital" ))
    {
#if 0
	joy_mode = JOY_DIGITAL;		/* currently unsupported */
#else
	joy_mode = JOY_KYBD;
#endif
    }
    else if (!strcmp(prefstext, "off" ))
	joy_mode = JOY_OFF;
    else printf(
	"Illegal value to joystick parameter at line %d in .apple2\n",
	line_num);
}
	YY_BREAK
case 6:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 153 "prefs.l"
{
    /* range = range of x and y joystick values */
    while (!isdigit(*prefstext)) ++prefstext;	/* advance to origin parm */
    joy_range = atoi(prefstext);
    if (joy_range < 10)
	joy_range = 10;
    else if (joy_range > 256)
	joy_range = 256;
    half_joy_range = joy_range/2;

    if (joy_center_x > joy_range)
	joy_center_x = half_joy_range;
    if (joy_center_y > joy_range)
	joy_center_y = half_joy_range;
}
	YY_BREAK
case 7:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 169 "prefs.l"
{
    /* origin_x = x coordinate of joystick origin (byte value) */
    while (!isdigit(*prefstext)) ++prefstext;	/* advance to origin parm */
    joy_center_x = atoi(prefstext);
    if (joy_center_x < 0)
	joy_center_x = 0;
    else if (joy_center_x > 255)
	joy_center_x = 255;

    if (joy_center_x > joy_range)
	joy_center_x = half_joy_range;
}
	YY_BREAK
case 8:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 182 "prefs.l"
{
    /* origin_y = y coordinate of joystick origin (byte value) */
    while (!isdigit(*prefstext)) ++prefstext;	/* advance to origin parm */
    joy_center_y = atoi(prefstext);
    if (joy_center_y < 0)
	joy_center_y = 0;
    else if (joy_center_y > 255)
	joy_center_y = 255;

    if (joy_center_y > joy_range)
	joy_center_y = half_joy_range;
}
	YY_BREAK
case 9:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 195 "prefs.l"
{
#ifdef PC_JOYSTICK
    /* pc joystick parms generated by the calibration routine
       (shouldn't need to hand tweak these) = origin_x origin_y max_x
       min_x max_y min_y js_timelimit */
    while (!isdigit(*prefstext)) ++prefstext;	/* advance to 1st parm */
    js_center_x = strtol(prefstext, &prefstext, 10);
    js_center_y = strtol(prefstext, &prefstext, 10);
    js_max_x = strtol(prefstext, &prefstext, 10);
    if (js_max_x < 0)
	js_max_x = 0;
    js_min_x = strtol(prefstext, &prefstext, 10);
    if (js_min_x < 0)
	js_min_x = 0;

    js_max_y = strtol(prefstext, &prefstext, 10);
    if (js_max_y < 0)
	js_max_y = 0;
    js_min_y = strtol(prefstext, &prefstext, 10);
    if (js_min_y < 0)
	js_min_y = 0;

    js_timelimit = strtol(prefstext, &prefstext, 10);
    if (js_timelimit < 2)
	js_timelimit = 2;

    c_open_joystick();
    c_calculate_joystick_parms();	/* calculate the associated parms */
#endif
}
	YY_BREAK
case 10:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 226 "prefs.l"
{
    /* keyboard-emulated joystick sensitivity */
    while (!isdigit(*prefstext)) ++prefstext;		/* advance to parm */
    strip_percent(prefstext);
    joy_step = atoi(prefstext);
    if (joy_step < 1)
	joy_step = 1;
    else if (joy_step > 100)
	joy_step = 100;
}
	YY_BREAK
case 11:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 237 "prefs.l"
{
    /* system path = path to rom files */
    while (*prefstext != '=') ++prefstext; ++prefstext; /* advance past '=' */
    while (isspace(*prefstext)) ++prefstext;
    strcpy(system_path, prefstext);
}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 245 "prefs.l"
{
    ++line_num;		/* count lines */
}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 249 "prefs.l"
{		/* flag extraneous characters */
    printf("Random character `%c' at line %d in .apple2\n",
	   *prefstext, line_num);
}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 255 "prefs.l"
ECHO;
	YY_BREAK
#line 1123 "prefs.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a singled characater, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 221 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 221 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 220);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			yytext_ptr = yy_c_buf_p;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						{
						yy_c_buf_p =
						yytext_ptr + YY_MORE_ADJ;
						return EOF;
						}

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;
					break;

				case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
					YY_FATAL_ERROR(
					"unexpected last match in yyinput()" );
#else
					YY_FATAL_ERROR(
					"unexpected last match in input()" );
#endif
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;

	yy_current_buffer->yy_at_bol = (c == '\n');

	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *str )
#else
YY_BUFFER_STATE yy_scan_string( str )
yyconst char *str;
#endif
	{
	int len;
	for ( len = 0; str[len]; ++len )
		;

	return yy_scan_bytes( str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n - YY_MORE_ADJ; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 255 "prefs.l"



int prefswrap () {
    return 1;
}

void lowercase_string( char *s ) {
    char *p;

    for (p = s; *p != '\0'; p++)
	*p = tolower(*p);
}

void strip_percent( char *s ) {
    char *p = s + strlen(s) - 1;
    if (p >= s && *p == '%')
	*p = '\0';
}

void pad_string(char *s, char c, int len) {
    char *p;

    for (p = s; ((*p != '\0') && (p-s < len-1)); p++);
    while (p-s < len-1) {
	*p++ = c;
    }
    *p = '\0';
}

/* for testing */
/* void main( int argc, char **argv ) { */
/*     ++argv, --argc; */
/*     if ( argc > 0 ) */
/* 	prefsin = fopen( argv[0], "r" ); */
/*     else */
/* 	prefsin = stdin; */
    
/*     prefslex(); */
/* } */
