#include "apple.h"

#ifndef NOTIME
#include <time.h>
#endif

void doclock()
{
#ifndef NOTIME
	time_t t1;
	struct tm *t2;

	t1 = time(NULL);
	t2 = localtime(&t1);
/* convert into prodos form */

	MMemory[0xBF92] = t2->tm_min & 0xff;
	MMemory[0xBF93] = t2->tm_hour & 0xff;

	MMemory[0xBF90] = ((t2->tm_mday) + 32 * (t2->tm_mon + 1)) & 0xff;
	MMemory[0xBF91] = ((t2->tm_year * 2) + (t2->tm_mon / 8)) & 0xff;
#endif
	return;
}

/*	interface via $300 to UNIX system */
/*	To use: setup parameter block @ $300 in simulator and call $c0fe */
/*	Disk I/O parameter block:
		$300 = 0 for read 1 = write
		$301-$303 = file address
		$304-$305 = memory buffer address
		$306-$307 = length of I/O request
		$310-?    = zero terminated UNIX filename */
void dounix()
{
	int	len,maddr,faddr,operation,i,j;
	char	filename[256];
	unsigned char buffer[256*256];
	FILE 	*iofile;

	operation = MMemory[0x300];
	len = MMemory[0x306] + 256 * MMemory[0x307];
	maddr = MMemory[0x304] + 256 * MMemory[0x305];
	faddr = MMemory[0x301] + 256 * MMemory[0x302] + 65536 * MMemory[0x303];

/* copy the filename */
	i = 0;
	while (MMemory[i + 0x310] != 0) {
		filename[i] = MMemory[i + 0x310];
		i = i + 1;
	}
	filename[i] = '\0';

	switch (operation) {
		case 00:  /* read from UNIX */
/* open the file */
			iofile = fopen(filename,'r');
			if (iofile == 0) return;
			(void) fseek(iofile,faddr,0);
/* read the bytes */
			(void) fread(buffer,1,len,iofile);
/* parse the buffer */
			i = maddr;
			for(j = 0; j < len; j++) {
				MMemory[i++] = buffer[j];
				}
/* close the file */
			(void) fclose(iofile);
			break;


		case 01:  /* write to UNIX */
/* build the buffer */
			i = maddr;
			for(j = 0; j < len; j++) {
				buffer[j] = MMemory[i++] & 0xff ;
				}
/* open the file */
			iofile = fopen(filename,'w');
			if (iofile == 0) return;
			(void) fseek(iofile,faddr,0);
/* write the bytes */
			(void) fwrite(buffer,1,len,iofile);
/* close the file */
			(void) fclose(iofile);
			break;
	}

	return;
}

int readstate;
int writestate;
int area[256];
int modetable[8][64] = {
/* 0000 - 01ff */
	{0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1},
/* 0200 - 03ff,0800 - 1fff,6000 - bfff */
	{0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,
	 1,1,1,1,1,1,1,1,
	 1,1,1,1,1,1,1,1,
	 1,1,1,1,1,1,1,1,
	 1,1,1,1,1,1,1,1},
/* 0400 - 07ff */
	{0,0,0,0,0,0,1,1,
	 0,0,0,0,0,0,1,1,
	 0,0,0,0,0,0,1,1,
	 0,0,0,0,0,0,1,1,
	 1,1,0,0,1,1,1,1,
	 1,1,0,0,1,1,1,1,
	 1,1,0,0,1,1,1,1,
	 1,1,0,0,1,1,1,1},
/* 2000 - 3fff */
	{0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,1,1,
	 0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,1,1,
	 1,1,1,1,1,1,1,1,
	 1,1,0,0,1,1,1,1,
	 1,1,1,1,1,1,1,1,
	 1,1,0,0,1,1,1,1},
/* 4000 - 5fff */
	{0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,
	 1,1,1,1,1,1,1,1,
	 1,1,1,1,1,1,1,1,
	 1,1,1,1,1,1,1,1,
	 1,1,1,1,1,1,1,1},
/* c000 - cfff */
	{5,5,5,5,5,5,5,5,
	 5,5,5,5,5,5,5,5,
	 5,5,5,5,5,5,5,5,
	 5,5,5,5,5,5,5,5,
	 5,5,5,5,5,5,5,5,
	 5,5,5,5,5,5,5,5,
	 5,5,5,5,5,5,5,5,
	 5,5,5,5,5,5,5,5},
/* d000 - dfff */
	{4,4,4,4,4,4,4,4,
	 4,4,4,4,4,4,4,4,
	 2,3,2,3,2,3,2,3,
	 2,3,2,3,2,3,2,3,
	 4,4,4,4,4,4,4,4,
	 4,4,4,4,4,4,4,4,
	 2,3,2,3,2,3,2,3,
	 2,3,2,3,2,3,2,3},
/* e000 - ffff */
	{4,4,4,4,4,4,4,4,
	 4,4,4,4,4,4,4,4,
	 0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1,
	 4,4,4,4,4,4,4,4,
	 4,4,4,4,4,4,4,4,
	 0,1,0,1,0,1,0,1,
	 0,1,0,1,0,1,0,1},
};

void setupstates()
{
	readstate = ((ALTZP) | (STORE80 <<1) | (PAGE2 <<2) | (HIRES <<3) |
		(RamRead <<4) | (RAMRD <<5));
	writestate = ((ALTZP) | (STORE80 <<1) | (PAGE2 <<2) | (HIRES <<3) |
		(RamWrite <<4) | (RAMWRT <<5));
}

void speedinit()
{
	int i;
/* initialize the area table */
	for (i=0; i<256; i++) {
		area[i] = 1;
		if (i < 2) {       /* 0 - 1ff */
			area[i] = 0;
		} else if ((i >= 4) && (i < 8)) {    /* 400 - 7ff */
			area[i] = 2;
		} else if ((i >= 0x20) && (i < 0x40)) {  /* 2000 - 3fff */
			area[i] = 3;
		} else if ((i >= 0x40) && (i < 0x60)) {  /* 4000 - 5fff */
			area[i] = 4;
		} else if ((i >= 0xc0) && (i < 0xd0)) {  /* c000 - cfff */
			area[i] = 5;
		} else if ((i >= 0xd0) && (i < 0xe0)) {  /* d000 - dfff */
			area[i] = 6;
		} else if (i >= 0xe0) {  /* e000 - ffff */
			area[i] = 7;
		}
	}
}
