;SBTL "SOS 1.1  BFM.INIT2"
;.RELOC
             .SEGMENT  "CODE"
             .INCLUDE  "SOSORG"
             .ORG      ORGBFMI
ZZORG:
;MSB OFF
;***************************************************************************************************
;          COPYRIGHT (C) APPLE COMPUTER INC.  1980
;                    ALL RIGHTS RESERVED
;***************************************************************************************************
;
; BLOCK FILE MANAGER INIT2
;
;  SECONDARY INITIALIZATION ROUTINE FOR BLOCK FILE MANAGER
;
; MODIFIED: 03/25/81 TO UTILIZE NEW
;   DISK DRIVER'S SEEKDSK3 ROUTINE.
;  CHANGES MARKED BY 'D3RRA81084'
;
; MODIFIED: 08/19/81 TO WORK WITH NEW               
;   SOSLDR MODULE.
;***************************************************************************************************
;
             .EXPORT   BFM_INIT2
; 
;EXTRN I.BASE.P ; ENTRY IN SOSLDR 
             .IMPORT   SYSBANK
             .IMPORT   SXPAGE
             .IMPORT   CZPAGE
             .IMPORT   SEEKDSK3                                  ;IN DISKDH/D3RRA81084 
             .IMPORT   NMIDSBL                                   ;/D3RRA81084 
I_BASE_P     =         $2
;PAGE
;
; CONSTANTS
;
KERNEL_BASE  =         $B800                                     ; BASE ADDRESS OF SOS KERNEL
ROMID        =         $A0                                       ;$F1B9 OF NEW ROM/D3RRA81084 
SLOT         =         $60
BEGTRK       =         $9
BEGSECT      =         $2
ENDSECT      =         $6
;
; ZERO PAGE
;
TRACK        =         $99
SECTOR       =         $98
VOLUME       =         $9A
KEY          =         $E0                                       ; THRU $E7 
PREV_K       =         KEY+$8
XIDX         =         KEY+$9
I            =         KEY+$A                                    ; & $B 
;
; ROM ROUTINES
;
RDADR        =         $F1B9                                     ;REV1 
RDADRX       =         $F1BD                                     ;REV0 
;
; HARDWARE LOCATIONS
;
E_REG        =         $FFDF
B_REG        =         $FFEF
MOTORON      =         $C089
MOTOROFF     =         $C088
;PAGE
;***************************************************************************************************
;
; BFM_INIT2 ENTRY POINT 
;
;***************************************************************************************************
;
STATE:       .BYTE     $FE                                       ; FF=1ST ENTRY, 0=2ND ENTRY, 1=PROT 
;
BFM_INIT2:
             INC       STATE
             BMI       BFMI050
             JSR       GETK
             LDA       RETRY
             BEQ       BADNEWS
             BCC       BFMI050
             JSR       NMIDSBL
             JSR       DC
             INC       STATE
BFMI050:
             CLC
             RTS
BADNEWS:     SEC                                                 ; I/O ERROR
             RTS
;PAGE
;***************************************************************************************************
;
; DECODE SUBROUTINE
;
; TO ENCODE:
;    E0.E8:        - INIT KEY  & PREV.K
;    B84E:4C 64 B8 - JUMPS AROUND INTERP'S 3 BYTE OVERWRITE
;    1A02.1A03:    - NEW INTERP'S LOAD ADR (LO,HII)
;    B81DG:        - JSR FROM MONITOR
;
;***************************************************************************************************
DC:
             LDA       B_REG                                     ; SAVE BANK REGISTER
             PHA
             LDA       SYSBANK                                   ;    AND SWITCH TO SYSTEM BANK 
             STA       B_REG
             CLC                                                 ; FETCH LOADER'S INTERPRETER POINTER 
             LDA       CZPAGE+I_BASE_P
             ADC       #3
             STA       I
             PHA
             LDA       CZPAGE+I_BASE_P+1
             ADC       #0
             STA       I+1
             PHA
             LDA       #0
             STA       SXPAGE+I+1
; 
             LDY       I                                         ; ALIGN I PTR TO PAGE BOUNDARY 
             LDA       #0
             STA       I
             STA       PREV_K
;
             JSR       DCLOOP                                    ; DECODE 
;
             PLA                                                 ; RETRIEVE LOADER'S INTERPRETER POINTER 
             STA       I+1
             PLA
             STA       I
;
             LDY       #1                                        ; REPOSITION LOADER'S INTERPRETER POINTER (PUT ENCODE JMP HERE) 
             LDA       (I),Y
             STA       CZPAGE+I_BASE_P
             INY
             LDA       (I),Y
             STA       CZPAGE+I_BASE_P+1
;
             LDY       #2                                        ; WALK ON INTERPRETER'S FIRST INSTRUCTION (3 BYTES) 
             LDA       #0
DCA:         STA       (I),Y
             DEY
             BPL       DCA
             PLA                                                 ; RESTORE BANK REGISTER                 (ENCODE JMP JUMPS TO HERE) 
             STA       B_REG
             RTS
;PAGE 
;***************************************************************************************************
;
; DECODE LOOP SUBROUTINE
;
;***************************************************************************************************
DCLOOP:
             LDX       #7                                        ; SHIFT LEFT ONE BIT 
             CLC
             LDA       KEY
             BPL       DC1
             SEC
DC1:         ROL       KEY,X
             DEX
             BPL       DC1
;
DC2:
             TYA
             AND       #7
             EOR       #2
             TAX
             LDA       KEY,X
             PHA
             AND       #7
             TAX
             PLA
             CLC
             ADC       PREV_K
             CLC
             ADC       KEY,X
             STA       PREV_K
             EOR       (I),Y                                     ; DECODE BYTE 
             STA       (I),Y                                     ; AND PUT IT BACK 
             INY
             BNE       DC2
             INC       I+1
             LDA       I+1
             CMP       #>KERNEL_BASE
             BCC       DCLOOP
             RTS
;PAGE 
;***************************************************************************************************
;
; GETKEY SUBROUTINE
;
;***************************************************************************************************
;
RETRY:       .BYTE     10+1                                      ;TEN RETRIES 
OURTRACK:    .RES      1                                         ;CURRENT TRACK/D3RRA81084 
;
GETK:
             LDX       #7
             STX       XIDX
             LDX       #SLOT
             LDA       MOTORON,X                                 ;ENSURE MOTOR STAYS ON 
             LDA       E_REG                                     ; SELECT 1MHZ, ROM 
             ORA       #$83
             STA       E_REG
;
; NOTE: THE SEEKDSK3 ROUTINE HAS THESE /D3RRA81084 
;  CAVEATS: 1MHZ MODE, MOTOR IS ON, /D3RRA81084 
;  DRIVE CURRENTLY SELECTED, ROM+I/O ENABLED! /D3RRA81084 
;
GETK010:     LDA       #BEGTRK
             STA       OURTRACK                                  ;WHERE WE SEEK TO /D3RRA81084 
             JSR       SEEKDSK3                                  ;HAVE DISKDH SEEK FOR US /D3RRA81084 
GETK020:     LDX       #SLOT
             JSR       DOREAD                                    ;FIND A SECTOR HEADER 
             BCS       IOERROR                                   ;=>RETRY IF BAD 
             LDA       SECTOR                                    ;WHERE ARE WE? 
             CMP       #BEGSECT                                  ;AT THE RIGHT PLACE? 
             BNE       GETK020                                   ;=>NO, GET THERE 
;
GETK100:     LDX       #1
             JSR       WAIT                                      ; (X * 1284) + 15 MILISECONDS 
             LDX       XIDX
             LDA       VOLUME
             STA       KEY,X
             DEC       XIDX
             BMI       ENUFF
             INC       OURTRACK                                  ;BUMP FOR NEXT TRACK /D3RRA81084 
             LDA       OURTRACK                                  ;WHERE TO GO /D3RRA81084 
             LDX       #SLOT
             JSR       SEEKDSK3                                  ;DISKDH, PLEASE SEEK ME /D3RRA81084 
             LDX       #SLOT
             JSR       DOREAD
             BCC       GETK100
             BCS       IOERROR
;
ENUFF:       LDX       #SLOT
             LDA       MOTOROFF,X
             LDA       E_REG                                     ; SELECT 2MHZ, RAM 
             AND       #$7C
             STA       E_REG
;PAGE 
             LDA       SECTOR
             CMP       #ENDSECT                                  ;TRACKS SYNC'ED? 
             BNE       NOTPROT
             LDA       KEY
             EOR       KEY+1
             BEQ       NOTPROT                                   ;IF FIRST 2 VOLS ARE EQUAL
             SEC
             RTS
; 
NOTPROT:     LDA       #0
             CLC
             RTS
;
;
DOREAD:      JSR       WHICHROM
             BCS       OLDREAD
             JMP       RDADR
OLDREAD:     JMP       RDADRX
;
;
WHICHROM:    LDA       RDADR
             CMP       #ROMID
             CLC
             BEQ       NEWROM
             SEC
NEWROM:
             RTS
;
;
IOERROR:     DEC       RETRY
             BEQ       ERR1
             JMP       GETK                                      ; TRY, TRY AGAIN
ERR1:        JMP       ENUFF                                     ; I/O ERROR, CLEANUP AND EXIT 
;
;
WAIT:        LDY       #0
W1:
             DEY
             BNE       W1
             DEX
             BNE       W1
             RTS
ZZEND:
ZZLEN        =         ZZEND-ZZORG
; add padding to make $400 bytes long
PADDING      =         $400-ZZLEN
             .RES      PADDING
             .IF       $400-LENBFMI
             .FATAL    "SOSORG FILE IS INCORRECT FOR BFM.INIT2"
             .ENDIF

