
;       APEX  CONSOLE  HANDLER

        .DEF    HIAD=$B480      ;ACTUALLY GOES HERE
        .DEF    LOAD=$2480      ;BUT WE LOAD IT HERE
        .DEF    BIAS=HIAD-LOAD

;WHERE THE DEVICE HANDLER TABLE IS SO WE CAN PATCH INTO IT:
        .DEF    DEVTAB=$BFC0

; SOME SPECIAL CHARATERS:
        .DEF    RETYPE=$15      ;CTRL-U = RETYPE CHARACTER
        .DEF    LINDEL=$18      ;CTRL-X = DELETE LINE
        .DEF    KBABOR=$19      ;CTRL-Y = ABORT PROGRAM
        .DEF    KBEXIT=$3       ;CTRL-C = EXIT PROGRAM
        .DEF    DOBLSH=$F       ;CRTL-O = GET BACKSLASH
        .DEF    DOBRAK=$B       ;CTRL-K = GET LEFT BRACKET
        .DEF    HALTER=$13      ;CTRL-S = STOP OUTPUT
        .DEF    CASSHF=$1D      ;CTRL-SHIFT-M = SHIFT CASE
        .DEF    EOFCOD=$1A      ;CTRL-Z = END-OF-FILE

;ASCII CHARACTERS

        .DEF    BSPCOD=$8       ;BACKSPACE
        .DEF    CRCOD=$D        ;RETURN
        .DEF    LFCOD=$A        ;LINE FEED
        .DEF    ESCCOD=$1B      ;ESCAPE
        .DEF    RUBCHR=$7F      ;RUBOUT
        .DEF    TABCOD=$9       ;TAB
        .DEF    FORMCD=$C       ;FORM FEED
        .DEF    BELCOD=$7       ;BELL

;SOME ROM ROUTINES WE NEED
        .DEF    ESC1=$FC2C      ;ADDRESS OF ESC PROCESSOR
        .DEF    CLREOL=$FC9C    ;CLEAR TO END OF LINE
        .DEF    BELL=$FF3A      ;HONK
        .DEF    APPTVO=$FBFD    ;"VIDOUT"
        .DEF    APHOME=$FC58    ;"HOME"
        .DEF    APVTAB=$FC22    ;"VTAB"
        .DEF    XKBINP=$FD1B    ;"KEYIN"
        .DEF    APBELL=$FBDD    ;SNEAK ENTRY TO "BELL"

;SOME OTHER APPLE LOCATIONS WE NEED TO KNOW ABOUT
        .DEF    IN=$200         ;INPUT LINE BUFFER
        .DEF    BASL=$28        ;LINE BASE POINTER
        .DEF    CH=$24          ;HORIZONTAL INDEX
        .DEF    CV=$25          ;APPLE VERTICAL POSITION REG

;SYSTEM GLOBALS WE NEED TO KNOW ABOUT
        .DEF    VABORT=$BF0C    ;ABORT EXIT VECTOR
        .DEF    VEXIT=$BF06     ;NORMAL EXIT VECTOR
        .DEF    LINIDX=$BF5A    ;INPUT LINE INDEX
        .DEF    EXECUT=$BF5D    ;EXEC MODE FLAG
        .DEF    LOWER=$BF5E     ;LOWER CASE FLAG

;SOME HARDWARE LOCATIONS IN THE APPLE
        .DEF    XKBRES=$C010    ;RESET KEYFLAG
        .DEF    XKBDAT=$C000    ;KEYBOARD DATA PORT

        .DEF    XTEXTR=$C051    ;SET TEXT MODE

        .LOC    HIAD,HIAD-BIAS

;ENTRY POINTS:
CONOPI: JMP     KEYINI          ;0=OPEN FOR INPUT
CONOPO: JMP     TVINI           ;3=OPEN FOR OUTPUT
CONIN:  JMP     GETKY0          ;6=INPUT
CONOUT: JMP     TVOUT           ;9=OUTPUT
        JMP     CONCLO          ;12=CLOSE
        JMP     CONCUR          ;15=DIRECT CURSOR SET
        JMP     CHKUSR          ;18=CHECK FOR INTERRUPTS

;SINGLE CHARACTER KEYBOARD INPUT ROUTINE

GETKY0: LDY     CH              ;WE HAVE TO FAKE
        LDA@Y   BASL            ;THE ROM RDKEY ROUTINE
        PHA                     ;COS WE DONT WANT TO
        AND#    $3F             ;GO THRU $38 AT THIS POINT
        ORA#    $40
        STA@Y   BASL            ;SET SCREEN FLASHING
        PLA
KEYINS: JSR     XKBINP          ;GET A CHAR, UPDATING HASH COUNT
        AND#    $7F             ;KEEP ONLY 7 BIT ASCII
        CMP#    KBEXIT          ;EXIT?
        BEQ     FINEX           ;BRANCH IF YES
        CMP#    KBABOR          ;ABORT?
        BEQ     SAVEX           ;BRANCH IF YES
        CMP#    DOBLSH          ;WANTS A BACKSLASH?
        BEQ     BSLASH          ;YES, TURN IT INTO A "\"
        CMP#    DOBRAK          ;WANTS A SQUARE BRACKET?
        BEQ     LBRACK          ;YES, TURN IT INTO A "["
        CMP#    CASSHF          ;WANTS TO SHIFT CASE?
        BEQ     SWITCH          ;YES ,GO DO THAT
        CMP#    BSPCOD          ;BACKSPACE (THE LEFT ARROW)?
        BNE     KEYRET          ;BRANCH IF NOT
        LDA#    RUBCHR          ;YES, CHANGE TO RUBOUT
KEYRET: CMP#    $40             ;ALPHA?
        BLT     KEYSAM          ;NO LEAVE IT
        LDX     LOWER           ;LOWER CASE ON?
        BEQ     KEYSAM          ;NO LEAVE IT
        ORA#    $20             ;YES, MAKE LOWER CASE
KEYSAM: CLC                     ;INDICATE SUCCESS
        RTS                     ;AND RETURN

BSLASH: LDA#    '\              ;GET A BACKSLASH SINCE WE CAN'T
        BNE     KEYRET          ;GENERATE IT DIRECTLY.
LBRACK: LDA#    '[              ;GET A LEFT BRACKET SINCE
        BNE     KEYRET          ;WE CAN'T GENERATE IT DIRECTLY.

SWITCH: LDA     LOWER           ;TOGGLE CASE SWITCH
        EOR#    $FF
        STA     LOWER           ;SAVE IT BACK
        JMP     GETKY0          ;AND GO GET ANOTHER KEY


;ROUTINE TO INITIALISE THE CONSOLE FOR OUTPUT

TVINI:  BIT     XTEXTR          ;SET TEXT MODE, ETC.
CONCLO: CLC                     ;INDICATE SUCCESS
        RTS                     ;AND RETURN

KEYINI: LDA     XKBRES          ;DROP KEY STROBE IF ANY
        MOV#    0,LOWER         ;UPPER CASE.
        CLC                     ;ALL OK
        RTS

;ROUTINE TO CHECK TO SEE IF USER TYPED AN ABORT CHAR
;OR ASKED TO FREEZE OUTPUT. THIS ROUTINE MUST PRESERVE ALL
;THE REGISTERS. IT MAY DESTROY THE PROCESSOR STATUS.

CHKUSR: PHA                     ;SAVE THE ACCUMULATOR CONTENTS
        LDA     XKBDAT          ;KEY STRUCK WHILE WE WERE GONE?
        BPL     CHKURT          ;BRANCH IF NOT, RETURN
        CMP#    HALTER+$80      ;YES, WAS IT HALT REQUEST?
        BNE     NOHNG           ;BRANCH IF NOT
        LDA     XKBRES          ;YES, EAT THE CHAR
KYWAIT: LDA     XKBDAT          ;AND WAIT FOR ANY KEY
        BPL     KYWAIT
        LDA     XKBRES          ;EAT THE KEY
CHKURT: PLA                     ;RESTORE ACCUMULATOR CONTENTS
        RTS                     ;AND RETURN
NOHNG:  CMP#    KBEXIT+$80      ;ABORT?
        BNE     NOHNG1          ;BRANCH IF NOT
        LDA     XKBRES          ;YES, EAT THE CHAR
        PLA                     ;CLEAN UP STACK
FINEX:  JMP     VEXIT           ;NO,EXIT NORMALLY

NOHNG1: CMP#    KBABOR+$80      ;ABORT?
        BNE     CHKURT          ;BRANCH IF NOT, RETURN TO CALLER
        LDA     XKBRES          ;YES, EAT THE CHAR
        PLA                     ;CLEAN UP STACK
SAVEX:  JMP     VABORT          ;AND EXIT THROUGH USER ABORT VEC

;TV OUTPUT SUBROUTINE.
;CALL WITH THE ASCII CHAR TO OUTPUT IN THE ACCUMULATOR

TVOUT:  JSR     CHKUSR          ;CHECK FOR USER ABORT
        AND#    $7F             ;FOR SAFETY
        CMP#    TABCOD          ;TAB?
        BEQ     DOTAB           ;YES, FAKE IT
        CMP#    FORMCD          ;FORM FEED?
        BEQ     DOFORM          ;YES, FAKE IT
        CMP#    CRCOD           ;CARRIAGE RETURN?
        BEQ     DOCR            ;YES, FAKE IT
        CMP#    RUBCHR          ;RUBOUT CHARACTER?
        BEQ     RUBOUT          ;YES, FAKE IT
        CMP#    LFCOD           ;LINE FEED?
        BEQ     TVNOR           ;YES, LET IT PASS
        CMP#    BELCOD          ;BELL?
        BEQ     TVNOR           ;YES, LET IT PASS
        CMP#    BSPCOD          ;BACKSPACE?
        BEQ     BACKSP          ;YES, GO HANDLE
DIRTV:  CMP#    %141            ;TEST FOR LOWER CASE ALPHA
        BLT     CHKCTL          ;BRANCH IF NOT
        EOR#    $60             ;MAKE IT NON-BLINKING
        BPL     TOTV            ;BUT INVERSE VIDEO.
CHKCTL: CMP#    %40             ;TEST FOR OTHER CONTROL CHARS
        BCS     TVNOR           ;BRANCH IF NOT A CONTROL CHAR
        ORA#    $40             ;CONTROL CHAR. BLINK IT.
        BNE     TOTV            ;AND PLACE IN INVERSE VIDEO.
TVNOR:  EOR#    $80             ;NORMAL CHARACTER
TOTV:   JSR     APPTVO          ;CALL APPLE ROM TO OUTPUT
NOTV:   CLC                     ;INDICATE SUCCESS
        RTS                     ;AND RETURN

DOFORM: JSR     APHOME          ;DO APPLE HOME-ERASE
        CLC                     ;INDICATE SUCCESS
        RTS                     ;AND RETURN

DOTAB:  LDA#    '               ;GET A SPACE
        JSR     DIRTV           ;OUTPUT IT
        LDA     CH              ;TEST HORIZ POSITION
        AND#    $7              ;REACHED TAB STOP YET?
        BNE     DOTAB           ;BRANCH IF NOT, KEEP SPACING
        CLC                     ;YES, INDICATE SUCCESS
        RTS                     ;AND RETURN

RUBOUT: JSR     BACKSP          ;REMOVE IT WITH BACKSPACE
        LDA#    '               ;SPACE
        JSR     TVNOR
BACKSP: LDA#    BSPCOD          ;BACKSPACE
        BNE     TVNOR           ;OUTPUT AND RETURN

DOCR:   JSR     CLREOL          ;CLEAR TO END
        LDA#    0               ;INDICATE HORIZ POSITION OF ZERO
        BEQ     HOOK            ;MOVE THERE THEN RETURN

;TV CURSOR ADDRESSING ROUTINE.
;CALLED WITH ROW IN ACCUMULATOR, COLUMN IN Y REGISTER.

CONCUR: CMP#    24              ;IS IT WITHIN RANGE?
        BCC     VEROK           ;BRANCH IF YES
        SEC                     ;NO, THEN WRAP AROUND
        SBC#    24
        JMP     CONCUR
VEROK:  STA     CV              ;SET VERTICAL POSITION
        TYA                     ;GET THE COLUMN NUMBER
HORR:   CMP#    40              ;IS IT ON SCREEN?
        BCC     HOOK            ;YES
        SEC                     ;NO, WRAP AROUND
        SBC#    40
        JMP     HORR
HOOK:   STA     CH              ;SET HORIZONTAL POSITION
        JSR     CHKUSR          ;CHECK FOR USER ABORT
        JSR     APVTAB          ;EXECUTE VTAB ROUTINE
        CLC                     ;INDICATE SUCCESS
        RTS                     ;AND RETURN

        .DEF    HERE=$B5C0
        .LOC    HERE,HERE-BIAS

;THIS IS THE LINE BUFFERED CONSOLE HANDLER

LINCON: JMP     OPENLN          ;OPEN FOR INPUT
        JMP     CONOPO          ;OPEN FOR OUTPUT
        JMP     GETCH           ;GET A BYTE
        JMP     CONOUT          ;SEND A BYTE
        JMP     NULLOP          ;CLOSE

;OPEN FOR INPUT, I.E. FLUSH THE LINE:

OPENLN: JSR     CONOPI          ;OPEN NORMAL CONSOLE
        LDA     EXECUT          ;EXEC MODE?
        BEQ     NULLOP          ;NO FLUSH IF EXEC MODE
        MOV#    $FF,LINIDX      ;FLUSH BUFFER
NULLOP: CLC                     ;SAY OK
        RTS

;GET A CHARACTER:

GETCH:  LDA     LINIDX          ;PICK UP LINE BUFFER INDEX
        CMP#    $FF             ;ANY CONTENT?
        BEQ     NEWLIN          ;NO, GO GET SOME
        TAX                     ;YES, GET A BYTE
        LDAX    IN              ;FROM INPUT BUFFER
        INC     LINIDX          ;FOR NEXT CHAR
        CMP#    EOFCOD          ;END OF FILE?
        BEQ     ENDFIL          ;TERMINATE EXEC MODE
        CMP#    CRCOD           ;WAS A RETURN?
        BEQ     ENDLN           ;YES, EMPTY THE LINE
        CMP#    LFCOD           ;LINE FEED?
        BEQ     GETCH           ;YES, IGNORE IT
        CLC                     ;SUCESS
        RTS                     ;BACK HOME

;WHEN WE ENCOUTER AN END-OF-FILE:
ENDFIL: LDA#    $FF             ;SET EXEC FLAG TO FALSE=$FF
        STA     EXECUT
        STA     LINIDX          ;SET INPUT LINE EMPTY
        JMP     GETCH           ;AND GO GET FROM KEYBOARD

;WHEN WE ENCOUTER A RETURN CHARACTER
ENDLN:  LDA     EXECUT          ;CONTINUE IF EXEC MODE
        BEQ     NOEND
        MOV#    $FF,LINIDX      ;NOT EXEC SO FLAG IT EMPTY
NOEND:  LDA#    CRCOD           ;GIVE CALLER THE RETURN
        CLC
        RTS

NEWLIN: JSR     GETLN           ;GET A LINE
        MOV#    0,LINIDX        ;RESET POINTER
        JMP     GETCH           ;BACK IN LINE

;NORMAL ENTRY POINT TO GET A LINE IS HERE:

GETLN:  MOV#    0,LINIDX        ;RESET POINTER
NXTCHR: JSR     RDCHAR          ;GO READ A CHAR
        CMP#    RETYPE          ;IS IT A RETYPE CHAR?
        BNE     ADDINP          ;NO, GO ON
;WAS RETYPE SO WE GOTTA FIX SCREEN TO NORMAL CHAR
        LDY     CH
        LDA@Y   BASL            ;YES, PICK UP CHAR FROM SCREEN
        CMP#    $80             ;IS IT NORMAL?
        BGE     ADDINP          ;YES, FINE
        CMP#    $40             ;WAS IT INVERSE (LOWER CASE)
        BGE     CTST2           ;NO MUST BE A BLINKER (CTRL)
        ORA#    $60             ;YES, FORCE NORMAL LOWER CASE
        JMP     ADDINP          ;GO INSERT IT
CTST2:  AND#    $1F             ;MAKE NORMAL CONTROL CHAR
;GOT IT, EITHER FOR REAL OR FROM SCREEN
ADDINP: AND#    $7F             ;WE WANT NORMAL ASCII
        LDX     LINIDX          ;PICK UP THE INDEX
        STAX    IN              ;STUFF CHARACTER INTO BUFFER
        CMP#    CRCOD           ;WAS IT RETURN?
        BNE     NOTCR           ;NO, PROCEED
        JSR     CROUT           ;YES, JUST ECHO THE RETURN
        RTS                     ;AND EXIT

NOTCR:  JSR     ECHO            ;ECHO THE CHARACTER
        CMP#    RUBCHR          ;WAS IT BACKSPACE?
        BEQ     BCKSPC          ;YES, DO THAT
        CMP#    LINDEL          ;WAS IT LINE DELETE?
        BEQ     CANCEL          ;YES, CANCEL THE LINE
        LDX     LINIDX          ;NEAR END OF BUFFER?
        CPX#    $F8             ;248 TH CHAR?
        BLT     NOTCR1          ;NO, FINE
        JSR     BELL            ;YES, WARN HIM
NOTCR1: INC     LINIDX          ;READY FOR NEXT
        JMP     NXTCHR
ECHO:   PHA
        CMP#    LINDEL          ;WAS IT LINE CANCEL?
        BEQ     ECHO1           ;DONT ECHO CANCEL
        CMP#    RUBCHR          ;WAS IT "RUBOUT"?
        BNE     ECH02           ;NO, NORMAL ECHO
        LDA#    BSPCOD          ;YES, DO BACKSPACE
ECH02:  JSR     CONOUT          ;ECHO IT
ECHO1 : PLA
        RTS

BCKSPC: LDA     LINIDX          ;GET THE INDEX
        BEQ     GETLNZ          ;LINE EMPTY? IF SO NEW LINE
        DEC     LINIDX          ;DROP BACK ONE PLACE
        JMP     NXTCHR          ;BACK FOR MORE
CROUT:  LDA#    CRCOD           ;GET A RETURN
        JSR     CONOUT          ;PUT IT OUT & RETURN TO CALLER
        LDA#    LFCOD           ;ALSO NEEDS A LINE FEED
        JSR     CONOUT          ;SINCE CONSOLE HANDLER
        RTS                     ;DOES BOTH CORRECTLY

RDCHAR: JSR     CONIN           ;GET ONE
        CMP#    ESCCOD          ;ESCAPE?
        BEQ     ESC             ;YES, GO PROCESS
        RTS                     ;NO, RETURN IT

ESC:    JSR     CONIN           ;GET ARGUMENT CHARACTER
        JSR     ESCDO           ;PROCESS IT
        JMP     RDCHAR          ;AND GET ANOTHER CHAR

ESCDO:  CMP#    'N              ;CHECK >= N
        BGE     ESCOLD          ;YES SO OLD WAY
        CMP#    'I              ;CHECK < I
        BLT     ESCOLD          ;YES SO OLD WAY
        CMP#    'L              ;IS IT L?
        BEQ     ESCOLD          ;YES, DO IT THE OLD WAY
        TAY                     ;USE CHAR AS INDEX
        LDAY    XLTBL-'I        ;TRANSLATE TO OLD FORM
        JSR     ESCOLD          ;AND DO OLD WAY
        JSR     CONIN           ;PICK UP NEXT TRY
        JMP     ESCDO           ;KEEP THIS MODE
ESCOLD: ORA#    $80             ;HARDWARE WIERD WOZNIAK
        SEC                     ;SOFTWARE WIERD WOZNIAK
        JMP     ESC1            ;GO THRU TO EITHER ROM
CANCEL: LDA#    '\              ;SHOW WE DROPPED THE LINE
        JSR     CONOUT
GETLNZ: JSR     CROUT           ;GIVE RETURN, AND REENTER
        JMP     GETLN
XLTBL:  .BYTE   'D
        .BYTE   'B
        .BYTE   'A
        .BYTE   $FF
        .BYTE   'C

;NOW HOOK THE HANDLER INTO THE DEVICE HANDLER TABLE:
        .LOC    DEVTAB,DEVTAB-BIAS
        .WORD   LINCON          ;BUFFERED CONSOLE = DEVICE 1
        .WORD   CONOPI          ;CONSOLE = DEVICE 0

	.PAGE
	.END
