\FFSV20.XPL
\FFS-65V2.0 - OCT 78

'CODE'
ABS=0,		REM=2,		RESERVE=3,	SWAP=4,
CHIN=7,		CHOUT=8,	CRLF=9,		INTIN=10,
INTOUT=11,	TEXT=12,	INITI=13,	INITO=14,
CLOSE=15,	FRUN=28,	FSAVE=29,	FWRITE=30,
FREAD=31,	FASAVE=27,	FGET=26,	RESTORE=32,
SPACE=18,	RAN=1,		ABORT=16;


\THE DIRECTORY
'ADDRESS'
	TITLE,	\TITLE OF THE VOLUME
	RNAM,	\THE REMEMBERED FILE
	FNAME,	\THE FILE NAMES
	FSTAT,	\THE FILE STATUS
	FLAGS,	\FFS SPECIAL REQUEST FLAGS
	FREE1,	\UNUSED
	UNUSED;	\FREE DIRECTORY SPACE
\INTEGER ARRAYS IN THE DIRECTORY
'INTEGER'
	DIRDAT,	\DIRECTORY DATE
	VOLUME,	\UNIQUE DISK ID NUMBER
	FDATE,	\DATE OF FILES
	FBLK,	\THE FIRST BLOCK
	LBLK;	\THE LAST BLOCK

\SOME ABSOLUTE ADDRES
'ADDRESS'
	COMPAG,PARM,IOPAG,PG0;

\THE SYSTEM GLOBALS:
'ADDRESS'
	STAB,	\SORT POINTER ARRAY
	LOCNAM;	\LOCAL NAME OF FILE

'INTEGER'
	DIRSIZ,	\DIR SIZE
	SWAPSIZ,\SWAPPING SIZE
	DIRBLK,	\WHERE DIRECT IS
	SWAPBLK,\SWAPPING AREA
	SYSBLK,	\WHERE SYSTEM IS
	USERBLK,\FIRST USER BLOCK
	BACKBLK,\BLOCK TO PU BACKUP DIR IN
	FIRBLK,	\FIRST BLOCK OF FILE
	LASBLK,	\LAST BLOCK OF FILE
	FLNO,	\NUMBER OF FILE
	MAXBLK,	\HIGHEST BLOCK
	MAXFL,	\HIGHEST FILE NO
	CHAR,	\INPUT CHARACTER
	ERR,	\ERR CODE IF NON ZERO
	SWAPFLG,\=0 IF SWAPPING AREA IS INVALID
	SWITCH,	\USER FILE SWITCH
	ARG1,	\USER ARGUMENT
	ARG2,	\USER ARGUMENT
	SPECIAL,\SPECIAL BITS IN PROGRAM FILE REQUEST
	SYSDAT,	\SYSTEM DATE
	INSIZE,	\SIZE OF LAST OPENED INFILE
	INDATE,	\DATE OF LAST INFILE
	MAXSTB,	\SIZE OF STAB ARRAY
	FILENO;	\RUN FILE NUMBER

\FOR MAIN
'INTEGER'HASH,I,L;



\CONSTANTS

\FILE STATUS IN THE DIRECTORY
'DEFINE' NULL=0,TENTATIVE=255,REPLACE=254,VALID=1;

\FILE STATUS IN COMM AREA
'DEFINE' NOFILE=0,SETUP=1,CLOSED=255;

\SYSTEM REENTRY CONDITIONS
'DEFINE' SWAPIN=254,SAVEIN=255,BOOTIN=253;

\FAILED FLAG
'DEFINE' NONE=65535;




	'PROCEDURE'NEXT;
	'BEGIN'
	CHAR:=CHIN(0);
	'IF' CHAR=^/ 'THEN' [SWITCH:=CHIN(0);NEXT];
	'END';






	'PROCEDURE'CR;
	CRLF(0);






	'PROCEDURE'STR(TXT);
	'ADDRESS'TXT;
	TEXT(0,TXT);






	'PROCEDURE'NUM(I);
	'INTEGER'I;
	INTOUT(0,I);






	'PROCEDURE'ALPH;

\CHECK FOR ALPHANUMERIC OR "?"
'EXIT'((CHAR>=^0)&(CHAR<=^9))!((CHAR>=^A)&(CHAR<=^Z))!(CHAR=^?);






	'PROCEDURE'NAME(DEFAULT);
'ADDRESS'DEFAULT;
'INTEGER'K;

'BEGIN'
\READ IN A FILE NAME. INTO LOCFILE. SET TO DEFAULT EXTENTION
\IF NONE WAS GIVEN.  EXPAND *'S INTO FIELDS OF ?'S.
\LEAVE CHAR SET THE TERMINATION CHARACTER - FILE OR NOT.
\LEAVE THE NAME FIELD SET TO BLANKS IF NO FILE.
\THERE IS NO FILE IF CHAR IS RETURN OR A NON ALPHA IS
\THE FIRST NON-BLANK SEEN.  ALSO SET SWITCHES IF ANY.

'IF'CHAR#13\CR\'THEN'NEXT;
'WHILE'CHAR=^ 'DO'NEXT;
K:=0;
'IF'CHAR#^*'THEN'
	'BEGIN'
	'WHILE'ALPH'DO'
		'BEGIN'
		LOCNAM(K):=CHAR;
		'IF'K<8'THEN'K:=K+1;
		NEXT;
		'END';
	'FOR'K:=K,7'DO'LOCNAM(K):=^ ;
	'END'
'ELSE'['FOR'K:=0,7'DO'LOCNAM(K):=^?;NEXT];

K:=8;
'IF'CHAR=^.'THEN'
	'BEGIN'
	NEXT;
	'IF'CHAR#^*'THEN'
		'BEGIN'
		'WHILE'ALPH'DO'
			'BEGIN'
			LOCNAM(K):=CHAR;
			'IF'K<11'THEN'K:=K+1;
			NEXT;
			'END';
		'FOR'K:=K,10'DO'LOCNAM(K):=^ ;
		'END'
	'ELSE'['FOR'K:=8,10'DO'LOCNAM(K):=^?;NEXT];
	'END'
'ELSE''BEGIN'
	LOCNAM(8):=DEFAULT(0);
	LOCNAM(9):=DEFAULT(1);
	LOCNAM(10):=DEFAULT(2)&127;
	K:=11;
	'END';
'IF'CHAR=^='THEN'
	'BEGIN'
	ARG1:=INTIN(0);
	\KLUGE TO FIND THE TERMINATOR CHARACTER
	'IF'PG0(42)=^,'THEN'ARG2:=INTIN(0)
	'ELSE'ARG2:=NONE;
	'END'
'ELSE'[ARG1:=NONE;ARG2:=NONE];
'END';\NAME






	'PROCEDURE'PRDAT(DAT);
	'INTEGER'DAT,DAY,MO;

'BEGIN'
'IF'DAT<=0'THEN'[STR("NO DATE");'EXIT'];
DAT:=DAT/32;DAY:=REM(0);
DAT:=DAT/16;MO:=REM(0);
NUM(MO);CHOUT(0,^/);
NUM(DAY);CHOUT(0,^/);
NUM(DAT+76);
'END';






	'FPROC'DODAT;

	'PROCEDURE'RDDIR;
	'INTEGER'CHECK;

'BEGIN'
FREAD(DIRBLK,FNAME,DIRSIZ);
CHECK:= (PARM(34) = (255&('NOT'(PARM(32)&PARM(33)))) );
'IF'CHECK'THEN'SYSDAT:=PARM(32)+SWAP(PARM(33))
	'ELSE'SYSDAT:=0;
'IF'SYSDAT>=DIRDAT(0)'THEN'DIRDAT(0):=SYSDAT
'ELSE''BEGIN'
	STR("DATE FROM DISK: ");
	SYSDAT:=DIRDAT(0);
	PARM(32):=SYSDAT;
	PARM(33):=SWAP(SYSDAT);
	PARM(34):='NOT'(PARM(32)&PARM(33));
	DODAT;CR;
	'END';
'END';






	'PROCEDURE'WRTDIR;
	'INTEGER'BLK;

'BEGIN'
'IF'ERR#0'THEN''EXIT';
BLK:=RESERVE(256);
FREAD(3,BLK,1);
'IF'BLK(126)#VOLUME(0)'THEN'
	'BEGIN'
	STR("WRONG DISK! - REBOOT");CR;
	ABORT;
	'END';
FWRITE(DIRBLK,FNAME,DIRSIZ);
'END';






	'PROCEDURE'LOOKUP(FILE);
	'INTEGER'FILE,L;

'BEGIN'
\LOOKUP THE FILENAME IN LOCFILE BEGINNING AT
\DIRECTORY ENTRY NUMBER FILE.
\TAKE ? AS WILD
'LOOP'	'BEGIN'
	'IF'FSTAT(FILE)=VALID'THEN'
		'BEGIN'
		L:=0;
		'LOOP'
			'BEGIN'
			'IF'(LOCNAM(L)#^?)&(FNAME(FILE*11+L)#LOCNAM(L))
			'THEN''QUIT';
			L:=L+1;
			'IF'L=11'THEN''QUIT';
			'END';
		'IF'L=11'THEN''QUIT'\WE HAVE IT\;
		'END';
	FILE:=FILE+1;
	'IF'FILE>MAXFL'THEN''QUIT';
	'END';
'EXIT''IF'FILE<=MAXFL'THEN'FILE'ELSE'NONE;
'END';\LOOKUP






	'PROCEDURE'PRNAM(FILE);
	'ADDRESS'FILE;
	'INTEGER'K;

'BEGIN'
'FOR'K:=0,7'DO'CHOUT(0,FILE(K));
CHOUT(0,^.);
'FOR'K:=8,10'DO'CHOUT(0,FILE(K));
'END';






	'PROCEDURE'PRINT(FILE);
	'INTEGER'FILE,MIN,MAX,K,SIZE;

'BEGIN'
PRNAM(FNAME+FILE*11);
MIN:=FBLK(FILE);
MAX:=LBLK(FILE);
SIZE:=MAX-MIN+1;
STR("  ");NUM(SIZE);
'IF'SIZE<10'THEN'CHOUT(0,^ );
'IF'SIZE<100'THEN'CHOUT(0,^ );
CHOUT(0,^ );
'IF'SWITCH=^B'THEN'
	'BEGIN'
	NUM(MIN);
	CHOUT(0,^-);NUM(MAX);
	'END'
'ELSE'PRDAT(FDATE(FILE));
'END';






	'PROCEDURE'DODAT;
	'INTEGER'DAY,MO,YR,DAYWRD,X;

'BEGIN'
DAYWRD:=RESERVE(14);
DAYWRD(0):="MON";
DAYWRD(1):="TUE";
DAYWRD(2):="WED";
DAYWRD(3):="THR";
DAYWRD(4):="FRI";
DAYWRD(5):="SAT";
DAYWRD(6):="SUN";
'IF'SYSDAT<=0'THEN''EXIT';
YR:=SYSDAT/32;DAY:=REM(0);
YR:=YR/16;MO:=REM(0);
'IF'MO<=2'THEN'[MO:=MO+10;YR:=YR-1]'ELSE'MO:=MO-2;
X:=REM(((26*MO-2)/10+DAY+YR+YR/4+60)/7);
STR(DAYWRD(X));CHOUT(0,^ );PRDAT(SYSDAT);
'END';






	'PROCEDURE'RDDAT;
	'INTEGER'MO,DAY,FILE;

'BEGIN'
NAME(RNAM+8);
'IF'LOCNAM(0)#^ 'THEN'
	'BEGIN'
	FILE:=LOOKUP(0);
	'IF'FILE#NONE'THEN'FDATE(FILE):=SYSDAT
	'ELSE'[ERR:=4;'EXIT'];
	STR("REDATE: ");PRINT(FILE);CR;
	'END'
'ELSE'
	'BEGIN'
	'REPEAT'
		'BEGIN'
		STR("ENTER NEW DATE ");
		MO:=INTIN(0);
		DAY:=INTIN(0);
		SYSDAT:=((INTIN(0)-76)*16+MO)*32+DAY;
		DIRDAT(0):=SYSDAT;
		PARM(32):=SYSDAT;
		PARM(33):=SWAP(SYSDAT);
		PARM(34):='NOT'(PARM(32)&PARM(33));
		'END'
	'UNTIL'SYSDAT>0;
	STR("TODAY IS: ");DODAT;CR;
	'END';
WRTDIR;
'END';






	'PROCEDURE'SORT;
	'INTEGER'I,J,T;

'BEGIN'\BUBBLE SORT THE FILES INTO ACENDING FBLK
J:=0;
'FOR'I:=0,MAXFL'DO'
	'IF' FSTAT(I)=VALID'THEN'
		[STAB(J):=I;J:=J+1];
MAXSTB:=J-1;
'FOR'I:=0,MAXSTB-1'DO'
'IF'FBLK(STAB(I+1))<FBLK(STAB(I))'THEN'
	\WE ARE OUT OF ORDER SO...
	'BEGIN'
	J:=I;
	'REPEAT''BEGIN'
		T:=STAB(J);
		STAB(J):=STAB(J+1);
		STAB(J+1):=T;
		J:=J-1;
		'END'
	'UNTIL'(FBLK(STAB(J))<FBLK(STAB(J+1)))!(J<0);
	'END';
'END';






	'PROCEDURE'EMSIZ(I);
	'INTEGER'I;
'BEGIN'
FIRBLK:='IF'I<0'THEN'USERBLK'ELSE'(LBLK(STAB(I))+1);
LASBLK:='IF'(MAXSTB<0)!(MAXSTB=I)'THEN'MAXBLK'ELSE'
	(FBLK(STAB(I+1))-1);
'EXIT''IF'LASBLK>=FIRBLK'THEN'LASBLK-FIRBLK+1'ELSE'0;
'END';






	'PROCEDURE'BIGBLK;
	'INTEGER'LMAX,FMAX,I,SIZE;

'BEGIN'
\FIND THE BIGEST EMPTY-SET FIRBLK AND LASBLK TO IT
SORT;
LMAX:=EMSIZ(-1);
FMAX:=-1;
'FOR'I:=0,MAXSTB'DO'
	'BEGIN'
	SIZE:=EMSIZ(I);
	'IF'SIZE>LMAX'THEN'[LMAX:=SIZE;FMAX:=I];	
	'END';
'IF'LMAX=0'THEN'[ERR:=9;'EXIT'];
EMSIZ(FMAX);
'END';






	'PROCEDURE'DIR;
	'INTEGER'I,SUM,END,START,K,FILENO,A;

'BEGIN'
K:=0;
NAME(RNAM+8);
CHOUT(0,12);
DODAT;STR("  ");
STR("V:");NUM(VOLUME(0));
CR;STR(TITLE);
'IF'LOCNAM(0)#^ 'THEN'
	'BEGIN'
	FILENO:=LOOKUP(0);
	'WHILE'FILENO#NONE'DO'
		'BEGIN'
		CR;
		PRINT(FILENO);
		K:=K+1;
		'IF' K=14 'THEN' A:=CHIN(0);
		FILENO:=LOOKUP(FILENO+1);
		'END';
	'END'
'ELSE''BEGIN'
	SORT;
	'FOR'I:=0,MAXSTB'DO'
		'BEGIN'
		'IF' SWITCH=^F 'THEN'
			'BEGIN'
			'IF' REM(K/2)=0 'THEN' CR 'ELSE' STR("    ");
			PRNAM(FNAME+STAB(I)*11);
			'END'
		'ELSE'
			'BEGIN'
			CR;
			PRINT(STAB(I));
			'IF' K=14 'THEN' A:=CHIN(0);
			'END';
		K:=K+1;
		'END';
	'END';
SUM:=MAXBLK-USERBLK+1;
'FOR'I:=0,MAXFL'DO'
	'IF'FSTAT(I)=VALID'THEN'
		'BEGIN'
 		END:=LBLK(I);
		START:=FBLK(I);
		SUM:=SUM-(END-START+1);
		'END';
CR;STR("FREE: ");NUM(SUM);
STR("   MAX: ");BIGBLK;
'IF'ERR=0'THEN'SUM:=LASBLK-FIRBLK+1'ELSE'SUM:=0;
ERR:=0;
NUM(SUM);CR;
'END';






	'PROCEDURE'FIND(SIZE);
	'INTEGER'SIZE,I;

'BEGIN'
\FIND FIXED SIZE SPACE, SET FIRST AND LAST BLOCK TO IT
'IF'SIZE<=0'THEN'[ERR:=5;'EXIT'];
SORT;
I:=-1;
'WHILE'EMSIZ(I)<SIZE & I<=MAXSTB'DO'I:=I+1;
'IF'I>MAXSTB'THEN'[ERR:=1;'EXIT'];
LASBLK:=FIRBLK+SIZE-1;
'END';






	'PROCEDURE'VERIFY;

'BEGIN'
STR("VERIFY? ");
INITI(0);
'EXIT'CHIN(0)=^Y;
'END';






	'PROCEDURE'ZERO;
	'INTEGER'I,J;

'BEGIN'
'IF''NOT'VERIFY'THEN''EXIT';
'FOR'I:=0,MAXFL'DO'FSTAT(I):=NULL;
WRTDIR;
'END';






	'PROCEDURE'NEWTITLE;
	'INTEGER'I;

'BEGIN'
I:=0;
NEXT;
'IF'CHAR#\CR\13'THEN'
	'BEGIN'
	'WHILE''NOT'ALPH'DO'NEXT;
	'WHILE'CHAR#13\CR\'DO'
		'BEGIN'
		TITLE(I):=CHAR;
		'IF'I<31'THEN'I:=I+1;
		NEXT;
		'END';
	'END';
TITLE(I):=11+128;
VOLUME(0):=ABS(SYSDAT*256+RAN(256));
FWRITE(3,FREE1,1);
'END';






	'PROCEDURE'CLEAR(FILE);
	'INTEGER'FILE,MIN,MAX,I;

'BEGIN'
\REMOVE A ENTRY FROM THE DIRECTORY
'IF'FSTAT(FILE)#VALID'THEN''EXIT';
FSTAT(FILE):=NULL;
STR("REMOVING ");PRINT(FILE);CR;
'END';






	'PROCEDURE'REMOVE;
	'INTEGER'FILENO;
'BEGIN'
\REMOVE ANY COLLISIONS WITH LOCFILE
FILENO:=LOOKUP(0);
'IF'FILENO#NONE'THEN'CLEAR(FILENO);
'END';






	'PROCEDURE'GETNAM(FILE);
	'INTEGER'FILE,I;

'FOR'I:=0,10'DO'LOCNAM(I):=FNAME(FILE*11+I);






	'PROCEDURE'ENTER;
	'INTEGER'K;

'BEGIN'
\ENTER A TENTATIVE FILE AND ITS BLOCKS INTO THE DIRECTORY
\DONT RESERVE THE BLOCKS, DONT MARK IT VALID
'IF'(LOCNAM(8)=^B)&(LOCNAM(9)=^A)&(LOCNAM(10)=^K)
'THEN'[ERR:=6;'EXIT'];
'FOR'K:=0,10'DO'
	'IF'LOCNAM(K)=^?'THEN'[ERR:=6;'EXIT'];
\FIND AN EMPTY DIR SLOT
FLNO:=0;
'WHILE'FSTAT(FLNO)=VALID'DO'
	'BEGIN'
	FLNO:=FLNO+1;
	'IF'FLNO>MAXFL'THEN'[ERR:=2;'EXIT'];
	'END';
\NOW COPY THE NAME INTO IT
'FOR'K:=0,10'DO'FNAME(FLNO*11+K):=LOCNAM(K);
FBLK(FLNO):=FIRBLK;
LBLK(FLNO):=LASBLK;
FSTAT(FLNO):='IF'(SPECIAL&1)&FLAGS(1)
	'THEN'TENTATIVE'ELSE'REPLACE;
FDATE(FLNO):='IF'SPECIAL&4'THEN'INDATE'ELSE'SYSDAT;
'END';






	'PROCEDURE'COPY(FBLK,TBLK,SIZE);
	'INTEGER'FBLK,TBLK,SIZE,BUFSIZ;
	'ADDRESS'BUFFER;

'BEGIN'\CHECK ONLY IF TBLK<0
BUFSIZ:=(SPACE-256)/256;
'IF'BUFSIZ<=0'THEN'[ERR:=21;'EXIT'];
BUFFER:=RESERVE(BUFSIZ*256);
'WHILE'SIZE>BUFSIZ'DO'
	'BEGIN'
	FREAD(FBLK,BUFFER,BUFSIZ);
	FBLK:=FBLK+BUFSIZ;
	'IF'TBLK>=0'THEN'
		'BEGIN'
		FWRITE(TBLK,BUFFER,BUFSIZ);
		TBLK:=TBLK+BUFSIZ;
		'END';
	SIZE:=SIZE-BUFSIZ;
	'END';
FREAD(FBLK,BUFFER,SIZE);
'IF'TBLK>=0'THEN'FWRITE(TBLK,BUFFER,SIZE);
'END';\COPY






	'PROCEDURE'PACK(FILE);
	'INTEGER'FILE,SIZE;

'BEGIN'
'IF'FLAGS(0)'THEN''ELSE''EXIT';\PACKING IS OFF
SIZE:=LBLK(FILE)-FBLK(FILE)+1;
FIND(SIZE);
'IF'ERR#0 ! FBLK(FILE)<=FIRBLK'THEN''EXIT';
\WE CAN PACK IT, SO.....
STR("PACKING: ");PRINT(FILE);CR;
COPY(FBLK(FILE),FIRBLK,SIZE);
'IF'ERR#0'THEN''EXIT';
SWAPFLG:='FALSE';
FBLK(FILE):=FIRBLK;
LBLK(FILE):=LASBLK;
'END';\PACK






	'PROCEDURE'CLOFIL(FILE,PAF);
	'INTEGER'FILE,PAF,S;

'BEGIN'
\CLOSE THE TENTATIVE FILE BY DIRECTORY NUMBER
\ASSUME IT HAS BEEN ENTERED - REMOVE COLLISIONS
S:=FSTAT(FILE);
'IF'(S#TENTATIVE)&(S#REPLACE)'THEN'[ERR:=7;'EXIT'];
GETNAM(FILE);
REMOVE;
FSTAT(FILE):=VALID;
STR("CLOSING: ");PRINT(FILE);CR;
'IF'PAF'THEN'PACK(FILE);
'IF'FLAGS(2)'THEN'
	COPY(FBLK(FILE),-1,LBLK(FILE)-FBLK(FILE)+1);
'END';






	'PROCEDURE'MAKE;
	'INTEGER'K;

'BEGIN'
NAME(RNAM+8);
'IF'ARG1=NONE'THEN'[ERR:=3;'EXIT'];
REMOVE;
'IF'ARG2=NONE'THEN'FIND(ARG1)
'ELSE'	'BEGIN'
	FIRBLK:=ARG2;
	LASBLK:=ARG2+ARG1-1;
	'END';
ENTER;
'IF'ERR#0'THEN''EXIT';
CLOFIL(FLNO,'FALSE');
WRTDIR;
'END';






	'PROCEDURE'DELETE;
	'INTEGER'FLAG,FILENO;

'BEGIN'
FLAG:='FALSE';
'LOOP'	'BEGIN'
	NAME("BAK");
	FILENO:=LOOKUP(0);
	'WHILE'FILENO#NONE'DO'
		'BEGIN'
		CLEAR(FILENO);
 		FLAG:='TRUE';
		FILENO:=LOOKUP(FILENO+1);
		'END';
	'IF'CHAR#^,'THEN''QUIT';
	'END';
'IF'FLAG'THEN'
	'BEGIN'
	'IF'VERIFY'THEN'WRTDIR'ELSE'RDDIR;
	'END'
'ELSE'ERR:=4;
'END';






	'PROCEDURE'SAVE;
	'INTEGER'SIZE;
	'ADDRESS'BLOCK;

'BEGIN'
NAME("SAV");
'IF''NOT'SWAPFLG'THEN''IF''NOT'VERIFY'THEN''EXIT';
BLOCK:=RESERVE(256);
FREAD(SWAPBLK+1,BLOCK,1);
SIZE:=BLOCK(201);
FIND(SIZE);
ENTER;
'IF'ERR#0'THEN''EXIT';
WRTDIR;
PARM(10):=NOFILE;
PARM(11):=FLNO;
FSAVE(FIRBLK);
'END';






	'PROCEDURE'DEFEXT(EXT);
	'ADDRESS'EXT;
	'INTEGER'I;

'BEGIN'
'IF'LOCNAM(8)#^@'THEN''EXIT';
'FOR'I:=0,2'DO'LOCNAM(I+8):=EXT(I);
LOCNAM(10):=LOCNAM(10)&127;
EXT(2):=EXT(2)!128;
STR(EXT);CR;
'END';






	'PROCEDURE'OPENOT;
	'INTEGER'FILENO;

'BEGIN'
\IF SWITCH IS R THEN OPEN EXISTING FILE ELSE
\OPEN THE BIGGEST POSSIBLE TENTATIVE
\AS AN OUTPUT FILE FOR USER
\USE THE NAME IN LOCFILE
'IF'LOCNAM(0)=^ 'THEN''EXIT';
'IF'SWITCH=^R'THEN'
	'BEGIN'
	FILENO:=LOOKUP(0);
	'IF'FILENO=NONE'THEN'[ERR:=4;'EXIT'];
	PARM(0):=FBLK(FILENO);
	PARM(1):=SWAP(FBLK(FILENO));
	PARM(2):=LBLK(FILENO);
	PARM(3):=SWAP(LBLK(FILENO));
	PARM(4):=SETUP;
	PARM(5):=FILENO;
	STR("OUTFIL: ");PRINT(FILENO);CR;
	'END'
'ELSE'	'BEGIN'
	BIGBLK;
	ENTER;
	'IF'ERR#0'THEN''EXIT';
	'IF'(SPECIAL&2)&((LASBLK-FIRBLK)<INSIZE)
		'THEN'[ERR:=13;'EXIT'];
	WRTDIR;
	PARM(0):=FIRBLK;
	PARM(1):=SWAP(FIRBLK);
	PARM(2):=LASBLK;
	PARM(3):=SWAP(LASBLK);
	PARM(4):=SETUP;
	PARM(5):=FLNO;
	STR("OUTFILE: ");PRINT(FLNO);CR;
	'END';
'END';\OPENOT






	'PROCEDURE'OPENIN;
	'INTEGER'FILENO;

'BEGIN'
\OPEN USERS INPUT FILE
'IF'LOCNAM(0)=^ 'THEN''EXIT';
FILENO:=LOOKUP(0);
'IF'FILENO=NONE'THEN'[ERR:=4;'EXIT'];
PARM(6):=FBLK(FILENO);
PARM(7):=SWAP(FBLK(FILENO));
PARM(8):=LBLK(FILENO);
PARM(9):=SWAP(LBLK(FILENO));
PARM(10):=SETUP;
PARM(11):=FILENO;
INSIZE:=LBLK(FILENO)-FBLK(FILENO);
INDATE:=FDATE(FILENO);
STR(" INFILE: ");PRINT(FILENO);CR;
'END';






	'PROCEDURE'OPEN(DEFO,DEFI);
	'ADDRESS'DEFO,DEFI,OUTNAM;
	'INTEGER'I;

'BEGIN'
'IF'CHAR#^ 'THEN''EXIT';
OUTNAM:=RESERVE(11);
NAME("@@@");
'IF'CHAR=^<'THEN'
	'BEGIN'
	'FOR'I:=0,10'DO'OUTNAM(I):=LOCNAM(I);
	NAME("@@@");
	'END'
'ELSE'
	'BEGIN'
	'IF'LOCNAM(0)=^ 'THEN'
		'FOR'I:=0,7'DO'LOCNAM(I):=RNAM(I);
	'FOR'I:=0,7'DO'OUTNAM(I):=LOCNAM(I);
	OUTNAM(8):=^@;
	'END';
'IF'LOCNAM(8)=^@'THEN'
	'IF'DEFI(0)#^@'THEN''FOR'I:=0,2'DO'LOCNAM(8+I):=DEFI(I)
	'ELSE''FOR'I:=8,10'DO'LOCNAM(I):=RNAM(I);
'IF'DEFI(0)#^ 'THEN'OPENIN;

'IF'OUTNAM(8)=^@'THEN'
	'IF'DEFO(0)#^@'THEN''FOR'I:=0,2'DO'OUTNAM(8+I):=DEFO(I)
	'ELSE''FOR'I:=8,10'DO'OUTNAM(I):=LOCNAM(I);
'FOR'I:=0,10'DO'LOCNAM(I):=OUTNAM(I);
'IF'DEFO(0)#^ 'THEN'OPENOT;

'END';\OPEN






	'PROCEDURE'BACKDIR;
'BEGIN'
FREAD(BACKBLK,FNAME,DIRSIZ);
STR("BACKUP DIRECTORY READ");
'IF'SWITCH=^W'THEN'
	'BEGIN'
	FWRITE(DIRBLK,FNAME,DIRSIZ);
	STR("...AND WRITTEN");
	'END';
CR;
'END';






	'PROCEDURE'RUN(RUNFL);
	'INTEGER'RUNFL,FIRBLK,I;
	'ADDRESS'BLOCK,DEFO,DEFI;

'BEGIN'
FWRITE(BACKBLK,FNAME,DIRSIZ);
BLOCK:=RESERVE(256);
DEFO:=RESERVE(3);
DEFI:=RESERVE(3);
FIRBLK:=FBLK(RUNFL);
FREAD(FIRBLK+1,BLOCK,1);
'FOR'I:=0,2'DO'[DEFO(I):=BLOCK(209+I)];
'FOR'I:=0,2'DO'[DEFI(I):=BLOCK(212+I)];
SPECIAL:=BLOCK(215);
OPEN(DEFO,DEFI);
'IF'ERR#0'THEN''EXIT';
CR;
FRUN(FIRBLK);
'END';






	'PROCEDURE'GET;
	'INTEGER'FILENO;

'BEGIN'
NAME("SAV");
FILENO:=LOOKUP(0);
'IF'FILENO=NONE'THEN'[ERR:=4;'EXIT'];
FGET(FBLK(FILENO));
'END';






	'PROCEDURE'INIT;
	'INTEGER'I;

'BEGIN'
RESTORE;
'IF''NOT'VERIFY'THEN''EXIT';
FASAVE(SYSBLK);
'END';






	'PROCEDURE'RESTART(I);
	'INTEGER'I;

'BEGIN'
'IF''NOT'SWAPFLG'THEN''IF''NOT'VERIFY'THEN''EXIT';
'IF'I'THEN'FRUN(SWAPBLK)'ELSE'FGET(SWAPBLK);
'END';






	'PROCEDURE'RENAME;
	'INTEGER'I,FILENO;
	'ADDRESS'TEMP;

'BEGIN'
TEMP:=RESERVE(11);
NAME(RNAM+8);
'IF'(LOCNAM(0)=^ )!(CHAR#^<)'THEN'[ERR:=12;'EXIT'];
FILENO:=LOOKUP(0);
'IF'FILENO#NONE'THEN'[ERR:=11;'EXIT'];
'FOR'I:=0,10'DO'TEMP(I):=LOCNAM(I);
NAME(RNAM+8);
'IF'TEMP(8)=^@'THEN''FOR'I:=8,10'DO'TEMP(I):=LOCNAM(I);
FILENO:=LOOKUP(0);
'IF'FILENO=NONE'THEN'[ERR:=4;'EXIT'];
STR("RENAME: ");PRINT(FILENO);CR;
'FOR'I:=0,10'DO'FNAME(FILENO*11+I):=TEMP(I);
STR(" TO BE: ");PRINT(FILENO);CR;
WRTDIR;
'END';






	'PROCEDURE'UPDATE;
	'INTEGER'I,FL,RSAV,FILENO;

'BEGIN'
FL:=PARM(5);
'IF'FSTAT(FL)=TENTATIVE'THEN'
	'BEGIN'
	GETNAM(FL);
	FILENO:=LOOKUP(0);
	'IF'FILENO#NONE'THEN'
		'BEGIN'
		\RESOLVE THE COLLISION
		RSAV:=FILENO;
		LOCNAM(8):=^B;LOCNAM(9):=^A;LOCNAM(10):=^K;
		FILENO:=LOOKUP(0);
		'IF'FILENO#NONE'THEN'CLEAR(FILENO);
		STR("BACKING: ");PRINT(RSAV);CR;
		I:=RSAV*11+8;
		FNAME(I):=^B;
		FNAME(I+1):=^A;
		FNAME(I+2):=^K;
		'END';
	'END'
'ELSE''IF'FSTAT(FL)#REPLACE'THEN''EXIT';
LBLK(FL):=PARM(2)+SWAP(PARM(3));
CLOFIL(FL,'TRUE');
WRTDIR;
'END';






	'PROCEDURE'FIXSAV;
	'INTEGER'FL;

'BEGIN'
FL:=PARM(11);
CLOFIL(FL,'FALSE');
WRTDIR;
'END';






	'PROCEDURE'LIST;
	'INTEGER'CHAR,EOF;

'BEGIN'
EOF:=26;
OPEN("   ","@@@");
'IF'PARM(10)#SETUP'THEN'[ERR:=4;'EXIT'];
INITI(3);
CR;
'LOOP'
	'BEGIN'
	CHAR:=CHIN(3);
	CHOUT(0,CHAR);

	'IF'CHAR=EOF'THEN''QUIT';
	'END';
PARM(4):=NOFILE;
PARM(10):=NOFILE;
CR;
'END';\LIST






	'PROCEDURE'SHOW(TXT,FLAG);
	'ADDRESS'TXT;
	'INTEGER'FLAG;

'BEGIN'
STR(TXT);CHOUT(0,9);
'IF'FLAG'THEN'CHOUT(0,^T)'ELSE'CHOUT(0,^F);
'END';






	'PROCEDURE'DEFFILE;
	'INTEGER'K;

'BEGIN'
NAME(RNAM+8);
STR("DEFAULT NAME: ");
'IF'LOCNAM(0)#^ 'THEN'
	'BEGIN'
	'FOR'K:=0,10'DO'RNAM(K):=LOCNAM(K);
	WRTDIR;
	'END';
PRNAM(RNAM);CR;
SHOW("PACK:",FLAGS(0));CR;
SHOW("BACKUP:",FLAGS(1));CR;
SHOW("CHECK:",FLAGS(2));CR;
'END';






	'PROCEDURE'SET;
	'INTEGER'FILE,I,NEWSPEC,CHAR,SPECIAL,FIRBLK;
	'ADDRESS'BLOCK;

'BEGIN'
NAME("SAV");
FILE:=LOOKUP(0);
'IF'FILE=NONE'THEN'[ERR:=4;'EXIT'];
BLOCK:=RESERVE(256);
FREAD(FBLK(FILE)+1,BLOCK,1);

STR("DEFAULT OUTPUT EXTENTION: ");
'FOR'I:=0,2'DO'CHOUT(0,BLOCK(209+I));
INITI(0);STR(" ");CHAR:=CHIN(0);
'IF'CHAR#\CR\13'THEN'
'FOR'I:=0,2'DO'[BLOCK(209+I):=CHAR;CHAR:=CHIN(0)];

STR("DEFAULT INPUT EXTENTION: ");
'FOR'I:=0,2'DO'CHOUT(0,BLOCK(212+I));
INITI(0);STR(" ");CHAR:=CHIN(0);
'IF'CHAR#\CR\13'THEN'
'FOR'I:=0,2'DO'[BLOCK(212+I):=CHAR;CHAR:=CHIN(0)];

SPECIAL:=BLOCK(215);

SHOW("BACKUP:",SPECIAL&1);
INITI(0);CHAR:=CHIN(0);
NEWSPEC:=('IF'CHAR=^F'THEN'0
	'ELSE'('IF'CHAR=^T'THEN'1'ELSE'(SPECIAL&1)));

SHOW("SIZE LIMIT:",SPECIAL&2);
INITI(0);CHAR:=CHIN(0);
NEWSPEC:=NEWSPEC ! 
	('IF'CHAR=^F'THEN'0
	'ELSE'('IF'CHAR=^T'THEN'2'ELSE'(SPECIAL&2)));

SHOW("KEEP DATE:",SPECIAL&4);
INITI(0);CHAR:=CHIN(0);
NEWSPEC:=NEWSPEC ! 
	('IF'CHAR=^F'THEN'0
	'ELSE'('IF'CHAR=^T'THEN'4'ELSE'(SPECIAL&4)));

BLOCK(215):=NEWSPEC;
FWRITE(FBLK(FILE)+1,BLOCK,1);
CR;
'END';






	'PROCEDURE'SETFLAG(FL);
	'INTEGER'FL;
'BEGIN'
NAME("@@@");
HASH:=LOCNAM(0)+SWAP(LOCNAM(1));
      'IF'HASH=^P+SWAP(^A)'THEN'FLAGS(0):=FL
'ELSE''IF'HASH=^B+SWAP(^A)'THEN'FLAGS(1):=FL
'ELSE''IF'HASH=^C+SWAP(^H)'THEN'FLAGS(2):=FL
'ELSE' ERR:=22;
WRTDIR;
'END';









'BEGIN'\MAIN PROC\

MAXBLK:=1000;
SWAPSIZ:=56;
DIRBLK:=0;
DIRSIZ:=5;
SWAPBLK:=13;
USERBLK:=130;
SYSBLK:=SWAPBLK+SWAPSIZ;
BACKBLK:=125;

MAXFL:=47;	\SELECT SO THAT DIRSIZ IS RIGHT

\SETUP ABSOLUTE ADDRES
PARM:=$B000;	\RESIDENT HANDER COMM AREA
COMPAG:=$FFC0;	\SYSTEM COMM AREA
PG0:=$0;
IOPAG:=$F000;	\$FE00

\RESERVE THE ARRAYS
I:=(MAXFL+1)*2;
\BLOCKS 0-2
FNAME:=RESERVE((MAXFL+1)*11);
FSTAT:=RESERVE(MAXFL+1);
FBLK:=RESERVE(I);
LBLK:=RESERVE(I);
\BLOCK 3
FREE1:=RESERVE(181);
RNAM:=RESERVE(11);
TITLE:=RESERVE(60);
VOLUME:=RESERVE(2);
DIRDAT:=RESERVE(2);
\BLOCK 4
FDATE:=RESERVE(I);
FLAGS:=RESERVE(8);
UNUSED:=RESERVE(248-I);


\NON DIR ARRAYS
LOCNAM:=RESERVE(11);
STAB:=RESERVE(48);

CR;STR("FFS-65 V2.0");CR;
RDDIR;ERR:=0;
'IF'PARM(4)=CLOSED'THEN'[UPDATE;PARM(4):=NOFILE];
SWAPFLG:='FALSE';
'IF'PARM(10)=SAVEIN'THEN'
	'BEGIN'
	FIXSAV;
	SWAPFLG:='TRUE';
	PARM(10):=NOFILE;
	'END'
'ELSE''IF'PARM(10)=SWAPIN'THEN'
	'BEGIN'
	SWAPFLG:='TRUE';
	PARM(10):=NOFILE;
	'END';
PARM(4):=NOFILE;PARM(10):=NOFILE;


\COMMAND DECODER
'LOOP'
	'BEGIN'
	SWITCH:=^ ;
	ERR:=0;
	SPECIAL:=0;
	INSIZE:=0;
	INDATE:=SYSDAT;\DEFAULT DATE
	CHOUT(0,^*);
	INITI(0);
	CHAR:=^ ;
	NAME("SAV");
	FILENO:=LOOKUP(0);
	'IF'FILENO#NONE'THEN'RUN(FILENO)
	'ELSE'
	'BEGIN'
	HASH:=LOCNAM(0)+SWAP(LOCNAM(1));
	      'IF'HASH=^Z+SWAP(^E)'THEN'ZERO
	'ELSE''IF'HASH=^M+SWAP(^A)'THEN'MAKE
	'ELSE''IF'HASH=^D+SWAP(^I)'THEN'DIR
	'ELSE''IF'HASH=^D+SWAP(^E)'THEN'DELETE
	'ELSE''IF'HASH=^S+SWAP(^A)'THEN'SAVE
	'ELSE''IF'HASH=^O+SWAP(^P)'THEN'OPEN("@@@","@@@")
	'ELSE''IF'HASH=^I+SWAP(^N)'THEN'INIT
	'ELSE''IF'HASH=^S+SWAP(^T)'THEN'RESTART('TRUE')
	'ELSE''IF'HASH=^S+SWAP(^W)'THEN'RESTART('FALSE')
	'ELSE''IF'HASH=^G+SWAP(^E)'THEN'GET
	'ELSE''IF'HASH=^R+SWAP(^E)'THEN'RENAME
	'ELSE''IF'HASH=^C+SWAP(^L)'THEN'UPDATE
	'ELSE''IF'HASH=^L+SWAP(^I)'THEN'LIST
	'ELSE''IF'HASH=^T+SWAP(^I)'THEN'NEWTITLE
	'ELSE''IF'HASH=^D+SWAP(^F)'THEN'DEFFILE
	'ELSE''IF'HASH=^D+SWAP(^A)'THEN'RDDAT
	'ELSE''IF'HASH=^B+SWAP(^D)'THEN'BACKDIR
	'ELSE''IF'HASH=^S+SWAP(^E)'THEN'SET
	'ELSE''IF'HASH=^D+SWAP(^O)'THEN'SETFLAG('TRUE')
	'ELSE''IF'HASH=^N+SWAP(^O)'THEN'SETFLAG('FALSE')
	'ELSE'[STR("I BEG YOUR PARDON?");CR];
	'END';
	'IF'ERR#0'THEN'
		'BEGIN'
		STR("FFS ERROR # ");
		NUM(ERR);CR;
		'END';
	'END';
'END';\OF ALL
