program bin2bin;

{ Convert ASM65 output to true binary }
{ Written by Willi Kusche }

type str2 = string[2];
     str4 = string[4];

var buff: char;
    b: byte;
    i: integer;
    w: str4;
    ASC: string[16];
    inF: text;
    outF: file of byte;

function toBin(s: str4): integer;
  var temp, power, i: integer;
  begin
    temp := 0;
    power := 1;
    for i := 4 downto 1
      do begin
        temp := temp + ((pos({ch}s[i], ASC) - 1) * power);
        power := power shl 4
      end;
    toBin := temp
  end;

begin
  ASC := '0123456789ABCDEF';
  w := '0000';
  assign(inF, 'p1.bin');
  reset(inF);
  assign(outF, 'p1');
  rewrite(outF);
  repeat
    read(inF, buff);
    if buff = '*'
        then for i := 1 to 4
               do read(inF, buff)
      else begin
        w[3] := buff;
        read(inF, w[4]);
        b := toBin(w) and $00FF;
        write(outf, b)
      end
  until eof(inF);
  close(inF);
  close(outF)
end.
