\WORKING ON AN ASSEMBLER V1.0 - version for mitsubishi

\THE REQUIRED INTRINSICS:
code ABS = 0,
     REM = 2,
     RESERVE = 3,
     SWAP = 4
     CHIN = 7,
     CHOUT = 8,
     CRLF = 9,
     INTIN = 10,
     INTOUT = 11,
     TEXT = 12,
     OPENI = 13,
     OPENO = 14
     CLOSE = 15,
     TRAP = 17,
     GETERR = 22,
     FSET = 24,
     HEXOUT = 27,
     FOPEN = 29,
     FCLOSE = 32,
     GETREG = 35,
     BLIT = 36;

\OPCODES NEEDED BY MACRO GENERATORS
define ADCOP = $656D,
       SBCOP = $E5ED,
       LDAOP = $A5AD,
       STAOP = $858D,
       INCOP = $E6EE,
       DECOP = $C6CE,
       ORAOP = $050D;

integer I,
        PC,            \program counter
        MITS,          \boolean, true if we are in mitsubishi mode
        ERRCNT,        \count of errors found
        ERRTAB,        \array of error messages corresponding to bits in ERRFLG
        IFFLG,         \boolean, conditional assembly flag
        EDX,           \index into OPERAND, our current parsing position
        OPCH,          \current operand character for parsing
        EOFFLG,        \boolean, end of file on input
        HASH,          \symbol hash code
        PASS,          \number of the pass we are on (1 or 2)
        LABNUM,        \symbol table entry number of current label
        ERRFLG;        \bitmap of errors for this line

integer INHAND,
        OUTHAND,
        LINKHAND;            \file handles for dos

integer LDEV,
        BINDEV,
        REMDEV;              \THE DEVICE NUMBERS

integer HEADTYP;             \the type of listing line header we want:
define HNONE, HVALUE, HPC;   \the possible values for HEADTYP

\THE TABLES WE NEED:
integer OPBASIC,
        OPMITS,              \length of opcode table
        OPTABA,
        OPTABC,
        OPTABV,
        OPTABSIZE,           \opcode tables
        POTABA,
        POTABSIZE,           \psuedo op table
        MCTABA,
        MCTABSIZE;           \macro table

\STRINGS WE NEED:
address FILENAME,            \link file name
        IDENT,               \current identifier
        LINEBUF,             \current input line
        LABEL,
        OPCODE,
        OPERAND;             \parsed segments of the input line

def EOF = $1A, TAB = $09, BEL = $07, EOL = $0D, LINEFEED = $0A;

define SIGCHAR = 8,          \NO. OF SIGNIFICANT CHARS IN AN IDENTIFIER
       SYMAX = 1000;         \SIZE OF THE SYMBOL TABLE

integer NOSYM,               \THE NUMBER SO SYMBOLS IN SYMBOL TABLE
        VALUE,               \VALUE OR ADDRESS OF CURRENT SYMBOL OR OPERAND
        IDTYPE,              \TYPE OF IDENTIFIER
        SYMNUM;              \POSITION IN "SYMTBL" OF CURRENT IDENTIFER

define UNDEF, ISLAB, ISCON, MULDEF;        \POSSIBLE IDTYPES

\THE SYMBOL TABLE ARRAYS:
address SYMTAB,              \IDENTIFIER NAME ARRAY (IDENT)
        SYMTYP;              \TYPE DESCRIPTORS ARRAY (IDTYPE)

integer SYMVAL,              \VALUE OR ADDRESS ARRAY (VALUE)
        SYMPNT,              \LIST LINKAGE POINTERS
        BOX;                 \HASH BOXES (SYMBOL LIST HEADERS)

\----------------------------------------------------------

procedure FATAL(STR);
  address STR;
  integer I;
  begin 
    TEXT(0, "FATAL ERROR-");
    TEXT(0, STR);
    CRLF(0);
    CLOSE(3);
    if LINKHAND # 0
        then FCLOSE(LINKHAND);
    FCLOSE(INHAND);
    if OUTHAND # 0
        then FCLOSE(OUTHAND);
    exit;
  end;

procedure SAYERROR;
  integer I, K;
  begin 
    I := 1;
    for K := 0, 15
      do begin 
        if (ERRFLG&I) # 0
            then begin 
              TEXT(LDEV, "*** ERROR -"); 
              TEXT(LDEV, ERRTAB(K));
              CRLF(LDEV);
            end;
        I := I * 2;
      end;
    ERRCNT := ERRCNT + 1;
    if LDEV = 0
        then I := CHIN(1);
  end;


procedure HEXB(DEV, I);
  integer DEV, I;          \OUTPUT HEX BYTE (OPTIMIZED FOR SPEED)
  char HEXDIGIT;           \ARRAY OF HEX DIGITS (0 - F)
  begin
    HEXDIGIT := "0123456789ABCDEF ";
    CHOUT(DEV, HEXDIGIT((I&$FF) / 16));
    CHOUT(DEV, HEXDIGIT(REM(0)));
  end;        \HEXB


\-----------------------------------------------------------

procedure LOOKUP;        \LOOKUP IDENTIFIER IN SYMBOL TABLE
  \INPUTS: IDENT
  \OUTPUTS: IDTYPE, VALUE, SYMNUM.
  integer I, K, PNTR;
  begin
    HASH := 0;
    for I := 0, 7
      do HASH := HASH + IDENT(I);
    HASH := HASH & $FF;
    PNTR := BOX(HASH);
    loop begin
      if PNTR = \EMPTY\-1
          then begin 
            IDTYPE := UNDEF;
            VALUE := $8000;
            quit;
          end;
      I := 0;
      K := PNTR;
      while IDENT(I) = SYMTAB(K) & I<SIGCHAR
        do [I := I + 1; K := K + SYMAX];
      if I = SIGCHAR
          then [IDTYPE := SYMTYP(PNTR);        \FOUND
                VALUE := SYMVAL(PNTR);
                quit];
      PNTR := SYMPNT(PNTR);
    end;
    if PNTR = 0
        then VALUE := PC;
    SYMNUM := PNTR;
  end;        \LOOKUP

procedure INSERT(STYP, SVAL);
  integer STYP, SVAL;
  \INSERT THE CURRENT IDENTIFIER INTO THE SYMBOL TABLE
  \INPUTS:  STYP, SVAL, IDENT, HASH, NOSYM, SYMBOL, & BOX.
  integer I, K;
  begin
    if NOSYM >= SYMAX
        then FATAL("SYMBOL TABLE FULL"); 
    K := NOSYM;
    for I := 0, SIGCHAR-1
      do [SYMTAB(K) := IDENT(I); K := K + SYMAX];
    SYMTYP(NOSYM) := STYP;
    SYMVAL(NOSYM) := SVAL;
    SYMPNT(NOSYM) := BOX(HASH);        \LINK BACK
    BOX(HASH) := NOSYM;
    SYMNUM := NOSYM;
    NOSYM := NOSYM + 1;
  end;        \INSERT

\-------------------------------------------------------------------

procedure EVAL;        
  \EXTRACT ONE VALUE TERM FROM THE OPERAND
  integer EBOL, SAVE, ACT;
  procedure OPNEXT;
    begin 
      OPCH := OPERAND(EDX);
      if OPCH = ^;
          then OPCH := 0;
      if OPCH # 0
          then EDX := EDX + 1;
    end;
  function ATOM;  \EXTRACT ONE ATOM FROM THE OPERAND
    integer ABOL;
    function NUMERIC;
      return ((OPCH >= ^0) & (OPCH <= ^9));
    function DODECCON;
      \EXTRACT A DECIMAL CONSTANT VALUE FROM THE OPERAND
      begin 
        while NUMERIC
          do [CHOUT(8, OPCH); OPNEXT];
        VALUE := INTIN(8);
        return true;
      end;
    function DOOCTCON;
      begin       \EXTRACT AN OCTAL CONSTANT VALUE FROM THE OPERAND
        OPNEXT;
        VALUE := 0;
        while (OPCH >= ^0) & (OPCH <= ^7)
          do begin 
            VALUE := VALUE * 8 + (OPCH - ^0);
            OPNEXT;
          end;
        return true;
      end;
    function DOHEXCON;
      \EXTRACT AN HEX CONSTANT VALUE FROM THE OPERAND
      begin 
        OPNEXT;
        VALUE := 0;
        while ((OPCH >= ^0) & (OPCH <= ^9)) ! ((OPCH >= ^A) & (OPCH <= ^F))
          do begin 
            if OPCH >= ^A
                then OPCH := OPCH - ^A + 10
              else OPCH := OPCH - ^0;
            VALUE := VALUE * 16 + OPCH;
            OPNEXT;
          end;
        return true;
      end;
    function DOALPCON;
      begin 
        OPNEXT;
        VALUE := OPCH;
        if OPCH=0
            then VALUE := $3B;        \FIX OCCURENCE OF ";"
        OPNEXT;
        return true;
      end;
    function DOSYMBOL;
      \EXTRACT A SYMBOL AND LOOK UP ITS VALUE
      integer K;
      function ALPNUM;
        return ((OPCH >= ^0) & (OPCH <= ^9))
               ! ((OPCH >= ^a) & (OPCH <= ^z))
               ! ((OPCH >= ^A) & (OPCH <= ^Z))
               ! (OPCH = ^.) ! (OPCH = ^_);
      begin 
        K := 0;
        while (K <= 7) & (ALPNUM)
          do begin 
            IDENT(K) := OPCH;
            K := K + 1;
            OPNEXT;
          end;
        while ALPNUM
          do OPNEXT;        \EAT EXCESS SYMBOL CHARACTERS
        for K := K, 7
          do IDENT(K) := ^ ;
        LOOKUP;
        if IDTYPE = UNDEF
            then ERRFLG := ERRFLG ! $0800;
        return IDENT(0) # ^ ;
      end;
    begin  \ATOM
      while (OPCH = ^ ) ! (OPCH = $09)
        do OPNEXT;        \SKIP SPACES
      if OPCH = 0
          then [VALUE := 0; return false ];
      if OPCH = ^$ then return DOHEXCON;
      if OPCH = ^% then return DOOCTCON;
      if (OPCH = ^') ! (OPCH = ^")
          then return DOALPCON;
      if NUMERIC
          then return DODECCON;
      if OPCH = ^-
          then begin 
            OPNEXT;
            ABOL := ATOM;
            VALUE := -VALUE;
            return ABOL;
          end;
      if OPCH = ^>
          then begin 
            OPNEXT;
            ABOL := ATOM;
            VALUE := SWAP(VALUE)&$FF;
            return ABOL;
          end;
      if OPCH = ^<
          then begin 
            OPNEXT;
            ABOL := ATOM;
            VALUE := VALUE&$FF;
            return ABOL;
          end;
      return DOSYMBOL;
    end;  \ATOM
  begin        \EVAL 
    OPNEXT;        \INITIALLY, JUST PICK UP FIRST OPCH
    EBOL := ATOM;
    while (OPCH = ^ ) ! (OPCH = $09)
      do OPNEXT;        \SKIP SPACES
    while (EBOL)
          & ((OPCH=^-) ! (OPCH=^+) ! (OPCH=^*) ! (OPCH=^/) ! (OPCH=^&) ! (OPCH=^!))
      do begin 
        ACT := OPCH;
        OPNEXT;
        while (OPCH=^ ) ! (OPCH=$09)
          do OPNEXT;        \SKIP SPACES
        SAVE := VALUE;
        EBOL := ATOM;
        case ACT of 
            ^-: VALUE := SAVE - VALUE;
            ^+: VALUE := SAVE + VALUE;
            ^*: VALUE := SAVE * VALUE;
            ^/: VALUE := SAVE / VALUE;
            ^&: VALUE := SAVE & VALUE
          else;
        while (OPCH=^ ) ! (OPCH=$09) do OPNEXT;        \SKIP SPACES
        end;
    return EBOL;
  end;

\-----------------------------------------------------------

function SEARCH(TABLE, SIZE);
integer TABLE, SIZE;
\LINEAR DUMB SEARCH OF OPCODE, PSUEDO OP OR MACRO TABLE
integer I, K, CHAR, FOUND;
address POINTER;
begin 
K := 0;
loop         begin 
        POINTER := TABLE(K);
        I := 0;FOUND := false;
        loop         begin 
        CHAR := POINTER(I);
        if (OPCODE(I) # CHAR)&((CHAR&$7F) # ^?)  then quit;
        if (CHAR&$80) then [FOUND := true; quit ];
        I := I + 1;
        end;
        if FOUND then quit;
        K := K + 1;
        if K >= SIZE then quit;
        end;
if FOUND then return K else return -1;
end;

\----------------------------------------------------------

procedure PROCLINE;
  integer I, K, CLASS, OPVAL, NUMBL, SAVEPC, CHAR, SEPARATOR, LNX;
  address BYTES;
  procedure NEXT;
    begin 
      CHAR := LINEBUF(LNX);
      if LNX>79 then CHAR := EOL;
      if CHAR # EOL then LNX := LNX + 1;
      SEPARATOR := (CHAR=^:) ! (CHAR=EOL) ! (CHAR=^ ) ! (CHAR=TAB);
    end;
  procedure COMMENT;
    begin 
      repeat
        NEXT
      until CHAR=EOL;
    end;
  procedure SKIPBLANKS;
    begin 
      loop begin 
        if CHAR = EOL
            then quit;
        if not SEPARATOR
            then quit;
        NEXT;
      end;
    end;
  procedure GETLABEL;
    begin 
      if CHAR=EOL then return;
      I := 0;
      loop         begin 
        LABEL(I) := CHAR;
        I := I + 1;
        NEXT;
        if SEPARATOR then quit;
        if I >= 8 then quit;
        end;
      while not SEPARATOR
        do NEXT;
      I := I-1;
      \if LABEL(I)=^: then LABEL(I) := 0;
    end;  \GETLABEL
  procedure GETOPCODE;
    begin 
      if CHAR=EOL then return;
      I := 0;
      loop         begin 
        OPCODE(I) := CHAR;
        I := I + 1;
        NEXT;
        if SEPARATOR then quit;
        if I >= 8 then quit;
      end;
      I := I-1;
      OPCODE(I) := OPCODE(I) ! $80;
      while not SEPARATOR do NEXT;
    end;

procedure GETOPERAND;
begin 
if CHAR=EOL then return;
I := 0;
loop         begin 
        OPERAND(I) := CHAR;
        I := I + 1;
        NEXT;
        if CHAR=EOL then quit;
        if I >= 80 then quit;
        end;
EDX := 0;
end;


\-----------------------------------------------------------

procedure GEN(N);
integer N;
begin 
if NUMBL>79 then ERRFLG := ERRFLG ! $1000;        \TOO MANY BYTES IN LINE
BYTES(NUMBL) := N&$FF;
NUMBL := NUMBL + 1;
PC := PC + 1;
end;


procedure GENBOP(OPC);
\WIERD PROCEDURE: GENERATES AN OPCODE BYTE IN WHICH THE BIT OPERAND
\IS EMBEDDED INTO THE OPCODE BYTE, ALA MITSUBISHI BIT OPS.
integer OPC, DIG;
begin 
DIG := (OPCODE(3)&$7F)-^0;
if (DIG<0) ! (DIG>7) then ERRFLG := ERRFLG ! $0001;        \BAD OPCODE
OPC := OPC + DIG*32;
GEN(OPC);
end;


procedure OUTLINE;
\GENERATE THE RESULTS: THE BYTE STRING AND THE LISTING LINE
begin 
if PASS=1 then return;
if HEADTYP=HNONE then 
        begin 
        TEXT(LDEV, "            ");
        end 
else         begin 
        if HEADTYP=HVALUE then HEXOUT(LDEV, VALUE)
        else HEXOUT(LDEV, SAVEPC);
        CHOUT(LDEV, ^ );
        if NUMBL>0 then HEXB(LDEV, BYTES(0)) else TEXT(LDEV, "  ");
        CHOUT(LDEV, ^ );
        if NUMBL>1 then HEXB(LDEV, BYTES(1)) else TEXT(LDEV, "  ");
        if NUMBL>2 then HEXB(LDEV, BYTES(2)) else TEXT(LDEV, "  ");
        end;
for I := 3, NUMBL-1 do HEXB(LDEV, BYTES(I));
for I := 0, NUMBL-1 do HEXB(BINDEV, BYTES(I));

CHOUT(LDEV, $9);
for I := 0, LNX-1 do CHOUT(LDEV, LINEBUF(I));CRLF(LDEV);
if ERRFLG # 0 then SAYERRORS;
end;        

\-----------------------------------------------------------------
\        opcode classes
\-----------------------------------------------------------------

procedure GENOP(OPVAL, VALUE);
integer OPVAL, VALUE;
\GENERATES AN INSTUCTION OF THE FULL ADDRESS TYPE
integer  OP;
begin 
if (VALUE&$FF00)=0 then  \ZERO PAGE OP
        begin 
        OP := SWAP(OPVAL)&$FF; \GET ZPAGE OPCODE
        if OP # 0 then  \IF THERE IS ONE
        begin 
        GEN(OP);
        GEN(VALUE);
        return 
        end;
        end;
\IF WE GET HERE THEN WE MUST USE ABSOLUTE ADDRESS MODE:
OP := OPVAL&$FF;
if OP=0 then 
if PASS=1 then 
        begin 
        GEN(OP);
        GEN(VALUE);
        return;
        end 
else ERRFLG := ERRFLG ! $0200;        \ADRESSING MODE ERROR - NO ABSOLUTE FORM
GEN(OP);
GEN(VALUE);
GEN(SWAP(VALUE));
end;


procedure CLASS1;
integer  OP;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
GENOP(OPVAL, VALUE);
end;


procedure CLASS2;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;                \NO OPERAND
if (VALUE&$FF00) # $FF00 then ERRFLG := ERRFLG ! $0080;        \NOT FF PAGE
GEN(SWAP(OPVAL));
GEN(VALUE);
end;


procedure CLASS3;
integer  NUMB;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND

NUMB := VALUE-PC-2;
if ((NUMB<-128) ! (NUMB>127))&(PASS=2)
        then ERRFLG := ERRFLG ! $0100;        \BRANCH OUT OF RANGE
GENBOP(SWAP(OPVAL));
GEN(NUMB);
end;


procedure CLASS4;
integer  NUMB;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND

NUMB := VALUE-PC-2;
if ((NUMB<-128) ! (NUMB>127))&(PASS=2)
        then ERRFLG := ERRFLG ! $0100;        \BRANCH OUT OF RANGE
GEN(SWAP(OPVAL));
GEN(NUMB);
end;


procedure CLASS5;
begin 
GEN(SWAP(OPVAL));
end;


procedure CLASS6;
begin 
GENBOP(SWAP(OPVAL));
end;


procedure CLASS7;
integer  NUMB;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
if (VALUE&$FF00) # 0 then ERRFLG := ERRFLG ! $0200;        \MUST BE ZPAGE
GENBOP(SWAP(OPVAL));
GEN(VALUE);
if not EVAL then ERRFLG := ERRFLG ! $0040;        \SECOND OPERAND?
NUMB := VALUE-PC-1;
if ((NUMB<-128) ! (NUMB>127))&(PASS=2)
        then ERRFLG := ERRFLG ! $0100;        \BRANCH OUT OF RANGE
GEN(NUMB);
end;



procedure CLASS8;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND FOUND
GEN(SWAP(OPVAL));
GEN(VALUE);
end;


procedure CLASS9;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
if (VALUE&$FF00) # 0 then ERRFLG := ERRFLG ! $0200;        \MUST BE ZPAGE
GENBOP(SWAP(OPVAL));
GEN(VALUE);
end;

procedure CLASS10;
integer  NUMB;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
GEN(SWAP(OPVAL));
GEN(VALUE);
if not EVAL then ERRFLG := ERRFLG ! $0040;        \SECOND OPERAND?
if (VALUE&$FF00) # 0 then ERRFLG := ERRFLG ! $0200;        \MUST BE ZPAGE
GEN(VALUE);
end;


\---------------------------------------------------------------
\PSUEDO OPS:


procedure DOPAGE;
  begin 
    if PASS=1
        then return;
    CRLF(LDEV);
    CHOUT(LDEV, $C);
  end;

procedure NOLIST;
  begin 
    if LDEV # 7
        then REMDEV := LDEV;
    LDEV := 7;
  end;

procedure DOLIST;
  begin 
    LDEV := REMDEV;
  end;

procedure DOIF;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    if VALUE = 0
        then IFFLG := false;
    HEADTYP := HVALUE;
  end;

procedure ENDIF;
  begin 
    IFFLG := true;
  end;

procedure DOLOC;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    PC := VALUE;
    if PASS = 2
        then begin 
          CHOUT(BINDEV, ^*);
          HEXOUT(BINDEV, PC);
        end;
    HEADTYP := HVALUE;
  end;

procedure DEFINE;
  integer  K, M, THISONE;
  begin  / of DEFINE /
    HEADTYP := HVALUE;
    M := 0;
    loop begin  \SKIPBLANKS
      CHAR := OPERAND(M);
      M := M + 1;
      if (M >= 80) ! (CHAR = EOL) ! (CHAR = ^;)
          then begin 
            ERRFLG := ERRFLG ! $0020;        \SYNTAX?
            return;
          end;
      if (CHAR # ^ ) & (CHAR # TAB)
          then quit;
    end;
    for K := 0, 7
      do IDENT(K) := ^ ;
    K := 0;
    loop begin         \PICK OUT LABEL PART
      if (CHAR=^=) ! (CHAR=EOL) ! (CHAR=^;)
          then quit;        
      IDENT(K) := CHAR;
      K := K + 1;
      if (K >= 8) ! (M >= 80)
          then quit;
      CHAR := OPERAND(M);
      M := M + 1;
    end;
    loop begin  \EAT POSSIBLE EXCESS LABEL LENGTH
        if CHAR=^= then quit;
        if (M >= 80) ! (CHAR=EOL) ! (CHAR=^;) then 
        begin 
        ERRFLG := ERRFLG ! $0020;        \SYNTAX?
        return;
        end;
        CHAR := OPERAND(M);
        M := M + 1;
        end;        
    K := 0;
    repeat
      begin 
        CHAR := OPERAND(M);
        OPERAND(K) := CHAR;
        M := M + 1;
        K := K + 1;
      end 
    until CHAR = 0;
    EDX := 0;
    LOOKUP;
    if PASS=2
        then if IDTYPE=UNDEF
                 then ERRFLG := ERRFLG ! $0004; \PASS?
    case IDTYPE of 
        UNDEF:        INSERT(ISCON, $0000);
        ISLAB:        SYMTYP(SYMNUM) := MULDEF
      else;
    THISONE := SYMNUM;
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    if (THISONE >= 0) & (SYMTYP(THISONE) = ISCON)
        then SYMVAL(THISONE) := VALUE;
  end;  / of DEFINE /

procedure DOBYTE;
  begin 
    while EVAL
      do GEN(VALUE);
  end;

procedure DOHBYTE;
  begin 
    while EVAL
      do GEN(SWAP(VALUE));
  end;

procedure DOWORD;
  begin 
    while EVAL
      do begin 
        GEN(VALUE);
        GEN(SWAP(VALUE));
      end;
  end;

procedure DOASCII;
  integer I, CHAR, TERM;
  begin 
    I := 0;
    TERM := OPERAND(0);
    loop begin 
      if I >= 79
          then quit;
      I := I + 1;
      CHAR := OPERAND(I);
      if CHAR = TERM
          then quit;
      GEN(CHAR);
    end;
  end;

procedure DOTEXT;
  integer I, CHAR, TERM;
  begin 
    I := 0;
    TERM := OPERAND(0);
    loop begin 
      if I >= 79
          then quit;
      I := I + 1;
      CHAR := OPERAND(I);
      if CHAR = TERM
          then quit;
      GEN(CHAR);
    end;
    BYTES(NUMBL-1) := BYTES(NUMBL-1) ! $80;
  end;

procedure DOMODE;
begin 
if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
case VALUE of 
$F0:        begin 
        MITS := true;
        OPTABSIZE := OPMITS;
        OPTABV(0) := $B26C;        \PATCH OPCODE TABLE
        end;
$00:         begin 
        MITS := false;
        OPTABSIZE := OPBASIC;
        OPTABV(0) := $006C;        \PATCH OPCODE TABLE
        end
else  ERRFLG := ERRFLG ! $2000;        \MODE NOT RECOGNIZED
end;

\-----------------------------------------------------------------


procedure NEWFILE; \OPEN A FILE FOR INPUT
  integer I;
  function NEWNAME(DEFEXT);
    char DEFEXT;
    \get a file name from the user
    integer EXTFLG, I, K, ODX, ALPHNUM;
    char CHAR;
    procedure NEXT;
      begin  \ of NEXT
        ALPHNUM := false;
        CHAR := OPERAND(ODX);
        if CHAR = ^;
            then CHAR := 0;
        if CHAR # 0
            then ODX := ODX + 1;
        if ((CHAR >= ^0) & (CHAR <= ^9)) ! ((CHAR >= ^A) & (CHAR <= ^Z))
            then ALPHNUM := true;
      end;  \ of NEXT
    begin  \ of NEWNAME
      ODX := 0;
      EXTFLG := false;
      for I := 0, 79
        do FILENAME(I) := 0;
      NEXT;        \GET STARTING CHAR
      \COPY FILE NAME INTO 'FILENAME'
      K := 0;
      loop begin
        if not ALPHNUM then quit;
        if CHAR=^.
            then EXTFLG := true;
        FILENAME(K) := CHAR;
        K := K + 1;
        if K >= 79
            then return false;
        NEXT;
      end;
      \DEAL WITH EMPTY FILENAME
      if K = 0
          then return false;
      \DEAL WITH DEFAULT EXTENTIONS
      if EXTFLG
          then FILENAME(K - 1) := FILENAME(K - 1) ! $80
        else begin
          if (K + 4) >= 79
              then return false;
          FILENAME(K) := ^.;
          K := K + 1;
          for I := 0, 2
            do FILENAME(K + I) := DEFEXT(I);
        end;
      return true;
    end;  \ of NEWNAME
  begin  \ of NEWFILE
    if LINKHAND # 0
        then FCLOSE(LINKHAND);
    NEWNAME("P65");
    if (PASS = 1) ! (LDEV # 0)
        then begin 
          TEXT(0, "NEW INPUT FILE:  ");
          for I := 0, 79
            do begin 
              CHAR := FILENAME(I)&$7F;
              if CHAR # 0
                  then CHOUT(0, CHAR);
            end;
          CRLF(0);
        end;
    TRAP($FFFB);
    LINKHAND := FOPEN(FILENAME, 0);
    TRAP($FFFF);
    if GETERR = 3
        then [TEXT(0, "FILE NOT FOUND"); exit ];
    FSET(LINKHAND, ^I);
    OPENI(3);
  end;  \ of NEWFILE

\-------------------------------------------------------------
\MACROS:

procedure ADDMAC;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GEN($18);                \GENERATE CLC
    GENOP(ADCOP, VALUE);        \GENERATE THE ADD
  end;

procedure ADDIMAC;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GEN($18);        \GENERATE CLC
    GEN($69);        \GENERATE ADC#
    GEN(VALUE);        \THE OPERAND LOW BYTE
  end;

procedure SUBMAC;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GEN($38);        \GENERATE SEC
    GENOP(SBCOP, VALUE);        \GENERATE THE SUBTRACT
  end;

procedure SUBIMAC;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GEN($38);        \GENERATE SEC
    GEN($E9);        \GENERATE SBC#
    GEN(VALUE);        \THE OPERAND LOW BYTE
  end;

procedure MOVMAC;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GENOP(LDAOP, VALUE);        \GO LDA IT
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \SECOND OPERAND?
    GENOP(STAOP, VALUE);        \STA
  end;

procedure DMOVMAC;
  integer  FIRVAL, SECVAL;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    FIRVAL := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \SECOND OPERAND?
    SECVAL := VALUE;
    GENOP(LDAOP, FIRVAL);
    GENOP(STAOP, SECVAL);
    GENOP(LDAOP, FIRVAL + 1);
    GENOP(STAOP, SECVAL + 1);
  end;

procedure MOVIMAC;
integer  FIRVAL, SECVAL;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    FIRVAL := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \SECOND OPERAND?
    SECVAL := VALUE;
    \THIS CODE SHOULD BE IN - BUT WAS NOT IN APPLE ASM.. SO, FOR NOW...
    \if (SECVAL & $FF00)=0 then\         \CAN DO IT WITH MITSUBISHI OPCODE
    \        begin 
    \        GEN($3C);
    \        GEN(FIRVAL);
    \        GEN(SECVAL);
    \        return         
    \        end;
    GEN($A9);        \LDA#
    GEN(FIRVAL);
    GENOP(STAOP, SECVAL);
  end;

procedure DMOVIMAC;
integer FIRVAL, SECVAL;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    FIRVAL := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \SECOND OPERAND?
    SECVAL := VALUE;
    GEN($A9);        \LDA#
    GEN(FIRVAL);
    GENOP(STAOP, SECVAL);
    GEN($A9);        \LDA#
    GEN(SWAP(FIRVAL));
    GENOP(STAOP, SECVAL + 1);
  end;

procedure DADDMAC;
integer FIRVAL, SECVAL;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    FIRVAL := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \SECOND OPERAND?
    SECVAL := VALUE;
    GEN($18);        \GENERATE CLC
    GENOP(LDAOP, FIRVAL);        \LOAD LOW BYTE OF FIRST OPERAND
    GENOP(ADCOP, SECVAL);        \ADD LOW BYTE OF SECOND OPERAND
    GENOP(STAOP, SECVAL);        \STORE TO LOW BYTE OF SECOND OPERAND
    GENOP(LDAOP, FIRVAL + 1);        \LOAD HIGH BYTE OF FIRST OPERAND
    GENOP(ADCOP, SECVAL + 1);        \ADD HIGH BYTE OF SECOND OPERAND
    GENOP(STAOP, SECVAL + 1);        \STORE TO HIGH BYTE OF SECOND OPERAND
  end;

procedure DADDIMAC;
integer CONSTANT;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    CONSTANT := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \SECOND OPERAND?
    GEN($18);        \GENERATE CLC
    GEN($A9);        \LDA#
    GEN(CONSTANT);        \LOW BYTE OF CONSTANT OPERAND
    GENOP(ADCOP, VALUE);        \ADD LOW BYTE OF SECOND OPERAND
    GENOP(STAOP, VALUE);        \STORE TO LOW BYTE OF SECOND OPERAND
    VALUE := VALUE + 1;        \MOVE TO HIGH BYTES
    if (CONSTANT & $FF00) = 0
        then begin         \SHORT FORM
          GEN($90);        \BCC
          if (VALUE & $FF00) = 0
              then GEN(2) else GEN(3);
          GENOP(INCOP, VALUE);        \INCREMENT HIGH BYTE OF OPERAND
        end 
      else begin         \LONG FORM
        GEN($A9);        \LDA#
        GEN(SWAP(CONSTANT));        \HI BYTE OF CONSTANT OPERAND
        GENOP(ADCOP, VALUE);        \ADD HI BYTE OF SECOND OPERAND
        GENOP(STAOP, VALUE);        \STORE TO HI BYTE OF SECOND OPERAND
      end;
  end;

procedure DSUBMAC;
integer FIRVAL, SECVAL;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    FIRVAL := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \OPERAND?
    SECVAL := VALUE;
    GEN($38);        \GENERATE SEC
    GENOP(LDAOP, FIRVAL);        \LOAD LOW BYTE OF FIRST OPERAND
    GENOP(SBCOP, SECVAL);        \SUB LOW BYTE OF SECOND OPERAND
    GENOP(STAOP, SECVAL);        \STORE TO LOW BYTE OF SECOND OPERAND
    GENOP(LDAOP, FIRVAL + 1);        \LOAD HIGH BYTE OF FIRST OPERAND
    GENOP(SBCOP, SECVAL + 1);        \SUB HIGH BYTE OF SECOND OPERAND
    GENOP(STAOP, SECVAL + 1);        \STORE TO HIGH BYTE OF SECOND OPERAND
  end;

procedure DSUBIMAC;
integer CONSTANT;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    CONSTANT := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \OPERAND?
    GEN($38);        \GENERATE SEC
    GEN($A9);        \LDA#
    GEN(CONSTANT);        \LOW BYTE OF CONSTANT OPERAND
    GENOP(SBCOP, VALUE);        \SUBTRACT LOW BYTE OF SECOND OPERAND
    GENOP(STAOP, VALUE);        \STORE TO LOW BYTE OF SECOND OPERAND
    VALUE := VALUE + 1;        \MOVE TO HIGH BYTES
    if (CONSTANT & $FF00) = 0
        then begin                 \SHORT FORM
          GEN($B0);        \BCS
          if (VALUE & $FF00) = 0
              then GEN(2)
            else GEN(3);
          GENOP(DECOP, VALUE);        \DECREMENT HIGH BYTE OF OPERAND
        end 
      else begin                 \LONG FORM
        GEN($A9);        \LDA#
        GEN(SWAP(CONSTANT));        \HI BYTE OF CONSTANT OPERAND
        GENOP(SBCOP, VALUE);        \SUB HI BYTE OF SECOND OPERAND
        GENOP(STAOP, VALUE);        \STORE TO HI BYTE OF SECOND OPERAND
      end;
  end;

procedure DINCMAC;
  begin 
    if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GENOP(INCOP, VALUE);        \INCREMENT LOW BYTE OF OPERAND
    VALUE := VALUE + 1;
    GEN($D0);        \GENERATE A "BNE"
    if (SWAP(VALUE)&$FF)=0 then GEN(2) else GEN(3);
    GENOP(INCOP, VALUE);        \INCREMENT HIGH BYTE
  end;

procedure DDECMAC;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GENOP(LDAOP, VALUE);        \LOAD LOW BYTE OF OPERAND
    VALUE := VALUE + 1;
    GEN($D0);        \"BNE"
    if (SWAP(VALUE) & $FF) = 0
        then GEN(2)
      else GEN(3);
    GENOP(DECOP, VALUE);        \DECREMENT HIGH BYTE
    GENOP(DECOP, VALUE-1);        \DECREMENT LOW BYTE
  end;

procedure DCMPMAC;
integer  FIRVAL, SECVAL;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    FIRVAL := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \OPERAND?
    SECVAL := VALUE;
    GEN($38);        \SET CARRY
    GENOP(LDAOP, FIRVAL);
    GENOP(SBCOP, SECVAL);
    GENOP(LDAOP, FIRVAL + 1);
    GENOP(SBCOP, SECVAL + 1);
  end;

procedure DCMPIMAC;
  integer  CONSTANT, LOCAT;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    LOCAT := VALUE;
    if not EVAL
        then ERRFLG := ERRFLG ! $0040;        \OPERAND?
    CONSTANT := VALUE;
    GENOP(LDAOP, LOCAT);
    if CONSTANT=0
        then GENOP(ORAOP, LOCAT + 1)
      else begin 
        GEN($38);        \SEC
        GEN($E9);        \SBC#
        GEN(CONSTANT);
        GENOP(LDAOP, LOCAT + 1);
        GEN($E9);        \SBC#
        GEN(SWAP(CONSTANT));
      end;
  end;

procedure DPSHMAC;
  begin 
    if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GENOP(LDAOP, VALUE);
    GEN($48);
    GENOP(LDAOP, VALUE + 1);
    GEN($48);        \PHA
  end;

procedure DPOPMAC;
  begin 
    if not EVAL then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GEN($68);        \PLA
    GENOP(STAOP, VALUE + 1);
    GEN($68);
    GENOP(STAOP, VALUE);
  end;

procedure DADMMAC;
  begin 
    if not EVAL
        then ERRFLG := ERRFLG ! $0400;        \NO OPERAND
    GEN($18);        \CLC
    GENOP(ADCOP, VALUE);
    GENOP(STAOP, VALUE);
    VALUE := VALUE + 1;
    GEN($90);        \BCC
    if (VALUE & $FF00) = 0
        then GEN(2)
      else GEN(3);
    GENOP(INCOP, VALUE);
  end;

procedure INCAMAC;
  begin 
    GEN($18);        \CLC
    GEN($69);        \ADC#
    GEN(1);        \1
  end;

procedure DECAMAC;
  begin 
    GEN($38);        \SEC
    GEN($E9);        \SBC#
    GEN(1);        \1
  end;

\-----------------------------------------------------------------

begin  \ of PROCLINE
  BYTES := RESERVE(80);
  LNX := 0;
  NEXT;
  ERRFLG := 0;
  SAVEPC := PC;
  HEADTYP := HPC;        \ASSUME THIS UNLESS OTHERWISE...
  for I := 0, 7
    do LABEL(I) := 0;
  for I := 0, 7
    do OPCODE(I) := 0;
  for I := 0, 79
    do OPERAND(I) := 0;
  \FIRST WE PARSE THE LINE...
  if CHAR=^; then COMMENT;
  if SEPARATOR then SKIPBLANKS else GETLABEL;
  SKIPBLANKS;
  if CHAR=^; then COMMENT;
  GETOPCODE;
  SKIPBLANKS;
  if CHAR=^; then COMMENT;
  GETOPERAND;
  \PROCESS THE LABEL, IF ANY:
  SYMNUM := -1;        \ASSUME NO LABEL UNTIL PROCESSED
  if (LABEL(0) # 0) & IFFLG
      then begin 
        for I := 0, 7 do 
        begin 
        IDENT(I) := LABEL(I);
        if IDENT(I)=0 then IDENT(I) := ^;
        end;
        LOOKUP;
        if PASS=2 then 
        begin 
        if IDTYPE=UNDEF then ERRFLG := ERRFLG ! $0004; \PASS?
        if IDTYPE=MULDEF then ERRFLG := ERRFLG ! $0008; \MULTIPLY DEF
        if (IDTYPE=ISLAB)&(VALUE # PC) then ERRFLG := ERRFLG ! $0010;\PHASE
        end 
        else         begin  \PASS1
        if IDTYPE=UNDEF then INSERT(ISLAB, PC)
        else         begin 
                IDTYPE := MULDEF;
                SYMTYP(SYMNUM) := MULDEF;
                end;
        end;
        end;
LABNUM := SYMNUM;        \KEEP POINTER TO LABEL ENTRY, IF ANY

\NOW WE PROCESS THE OPCODE ITSELF:
NUMBL := 0;        \NUMBER OF BYTES GENERATED SO FAR ON THIS LINE
if OPCODE(0) # 0 then 
        begin 
        if OPCODE(0)=^. then \PSUEDO OP
        begin 
        K := SEARCH(POTABA, POTABSIZE);
        if K<0 then ERRFLG := ERRFLG ! $0002;        \P OP NOT RECOGNIZED
        if K=10 then ENDIF;
        if IFFLG then 
        case K of 
                0:DOBYTE;        \BYTE
                1:DOWORD;        \WORD
                2:DOPAGE;        \PAGE
                3:DOASCII;        \ASCII
                4:DOTEXT;        \TEXT
                5:DOLOC;        \LOC
                6:DEFINE;        \DEF
                7:DOLIST;        \LIST
                8:NOLIST;        \NOLIST
                9:DOIF;        \IF
                10:ENDIF;        \ENDIF
                11:NEWFILE;        \LINK
                12:[EOFFLG := true ];\END
                13:DOMODE;        \MODE
                14:DOHBYTE        \HBYTE
        else;
        end 
        else         if IFFLG then 
        begin         \NOT A PSUEDO OP
        K := SEARCH(OPTABA, OPTABSIZE);
        if K >= 0 then 
                begin  \NORMAL OPCODE
                CLASS := OPTABC(K);
                OPVAL := OPTABV(K);
                case CLASS of 
                1:CLASS1;
                2:CLASS2;
                3:CLASS3;
                4:CLASS4;
                5:CLASS5;
                6:CLASS6;
                7:CLASS7;
                8:CLASS8;
                9:CLASS9;
                10:CLASS10
                else FATAL("TABLES WRONG");
                end 
        else         begin 
                K := SEARCH(MCTABA, MCTABSIZE);
                if K >= 0 then 
                begin  \ITS A MACRO
                case K of 
                0:ADDMAC;        \ADD
                1:SUBMAC;        \SUB
                2:MOVMAC;        \MOV
                3:MOVIMAC;        \MOV#
                4:DMOVIMAC;        \DMOV#
                5:DMOVMAC;        \DMOV
                6:DADDMAC;        \DADD
                7:DINCMAC;        \DINC
                8:DDECMAC;        \DDEC
                9:DSUBMAC;        \DSUB
                10:ADDIMAC;        \ADD#
                11:SUBIMAC;        \SUB#
                12:DADDIMAC;        \DADD#
                13:DSUBIMAC;        \DSUB#
                14:DCMPMAC;        \DCMP
                15:DCMPIMAC;        \DCMP#
                16:DPSHMAC;        \DPSH
                17:DPOPMAC;        \DPOP
                18:DADMMAC;        \DADM
                19:INCAMAC;        \INCA
                20:DECAMAC        \DECA
                else FATAL("TABLES WRONG");
                end 
                else ERRFLG := ERRFLG ! $0001;        \NOT RECOGNIZED
                end;
        end;
        end 
else HEADTYP := HNONE;        \MUST BE A COMMENT
OUTLINE;
end; \PROCLINE

procedure READLINE;
  integer CHAR, LNX;
  begin 
    LNX := 0;
    loop begin 
      repeat 
        CHAR := CHIN(3)
      until CHAR # LINEFEED;
      LINEBUF(LNX) := CHAR;
      if CHAR = EOF
          then begin 
            LINEBUF(LNX) := EOL;
            EOFFLG := true;
            quit;
          end;
      if CHAR=EOL then quit;
      if LNX<127 then LNX := LNX + 1;
    end;
  end;

\----------------------------------------------------------
\include IBMOPEN.XPL;\

\include DOSYMTAB.XPL;\
procedure DOSYMTAB;
  integer I, L, K, MAX, V;
  define VMAX = 4;
  function EARLIER(I, J);
    integer I, J;
    \RETURN TRUE IF SYMBOL I COMES BEFORE SYMBOL J.
    integer P1, P2, K;
    begin 
      if J < 0
          then return false ;
      P1:=SYMPNT(I);
      P2:=SYMPNT(J);
      for K := 0, SIGCHAR - 1
        do begin 
          if SYMTAB(P1) < SYMTAB(P2)
              then return true;
          if SYMTAB(P1) > SYMTAB(P2)
              then return false;
          P1 := P1 + SYMAX;
          P2 := P2 + SYMAX;
        end;
      return false;
    end;
  procedure SWAP(I, J);
    integer I, J;
    integer T;
    begin 
      T := SYMPNT(I);
      SYMPNT(I) := SYMPNT(J);
      SYMPNT(J):=T;
    end;
  begin 
    if LDEV = 7
        then return;
    CRLF(LDEV);
    CRLF(LDEV);
    CRLF(LDEV);
    \FIRST, FLESH OUT THE "SYMPNT" ARRAY TO MAKE IT A COMPLETE
    \POINTER LIST OF ALL THE SYMBOLS:
    MAX := NOSYM - 2;
    for I := 0, MAX
      do SYMPNT(I) := I + 1;
    for I:=0, MAX - 1
      do begin  \SORT THEM
        K := I;
        while EARLIER(K + 1, K)
          do begin 
            SWAP(K, K + 1);
            K:=K-1;
          end;
      end;
    V := 0;
    for I:=0, MAX
      do begin  \PRINT THEM
        L := SYMPNT(I);
        for K := 0, SIGCHAR - 1
          do begin 
            CHOUT(LDEV, SYMTAB(L));
            L := L + SYMAX;
          end;
        CHOUT(LDEV, ^ );
        L := SYMPNT(I);
        if SYMTYP(L) = MULDEF
            then TEXT(LDEV, "****")
          else HEXOUT(LDEV, SYMVAL(L));
        V := V + 1;
        if V < VMAX
            then TEXT(LDEV, "      ")
          else [CRLF(LDEV); V := 0];
      end ;
  end ;
\----------------------------------------------------------

begin  \ MAIN
  FILENAME := RESERVE(80);
  LINEBUF := RESERVE(128);
  LABEL := RESERVE(8);
  OPCODE := RESERVE(8);
  OPERAND := RESERVE(80);
  IDENT := RESERVE(SIGCHAR);
  SYMTAB := RESERVE(SIGCHAR*SYMAX);        \SYMBOL TABLE
  SYMTYP := RESERVE(SYMAX);
  SYMVAL := RESERVE(SYMAX*2);
  SYMPNT := RESERVE(SYMAX*2);
  BOX := RESERVE(512);        \HASH TABLE
  NOSYM := 0;
  for I := 0, 255
    do BOX(I) := \EMPTY\-1;        \ZERO THE SYMBOL TABLE
  IDENT(0) := ^.;
  for I := 1, 7
    do IDENT(I) := ^ ;
  LOOKUP;
  INSERT(ISCON, 0);        \DUMMY INSERT OF SYMBOL "."
  \ include OPTAB.XPL; \


  TEXT(0, "ASM65 6502 ASSEMBLER V1.1");
  CRLF(0);
  LDEV := 7;
  BINDEV := 3;
  INHAND := 0;
  OUTHAND := 0;
  LINKHAND := 0;
  IBMOPEN;
  OPENI(3);
  OPENO(BINDEV);
  OPENO(LDEV);
  REMDEV := LDEV;        \JUST REMEMBER WHAT OUT LIST DEVICE IS (FOR .LIST)
  \SETUP AND DO PASS 1
  MITS := false;
  OPTABSIZE := OPBASIC;
  OPTABV(0) := $006C;        \PATCH OPCODE TABLE
  ERRCNT := 0;
  EOFFLG := false;
  IFFLG := true;
  PC := 0;
  PASS := 1;
  CRLF(0);
  TEXT(0, "PASS 1");
  CRLF(0);
  loop begin 
    READLINE;
    if EOFFLG
        then quit;
    PROCLINE;
  end;
  \SETUP AND DO PASS 2
  LDEV := REMDEV;
  MITS := false;
  OPTABSIZE := OPBASIC;
  OPTABV(0) := $006C;        \PATCH OPCODE TABLE
  OPENI(3);
  EOFFLG := false;
  IFFLG := true;
  PC := 0;
  PASS := 2;
  CRLF(0);
  TEXT(0, "PASS 2");
  CRLF(0);
  FSET(INHAND, ^I);
  OPENI(3);
  loop begin 
    READLINE;
    if EOFFLG then quit;
    PROCLINE;
  end;
  LDEV := REMDEV;
  DOSYMTAB;
  CRLF(LDEV);
  CLOSE(3);
  if LINKHAND # 0
      then FCLOSE(LINKHAND);
  FCLOSE(INHAND);
  if OUTHAND # 0
      then FCLOSE(OUTHAND);
  CRLF(0);
  TEXT(0, "THE DEED IS DONE, ");
  INTOUT(0, ERRCNT);
  TEXT(0, " ERRORS FOUND, ");
  INTOUT(0, NOSYM-1);
  TEXT(0, " SYMBOLS.");
  CRLF(0);
end;  \ MAIN
