	;; the idea is to make a small binary file :	
	;; the library routines are far from optimal

	.globl	_my_memcpy	

_my_memcpy:	

	push	ix
	ld	ix,#0
	add	ix,sp

	ld	l,4(ix)
	ld	h,5(ix)
	
	ld	e,6(ix)
	ld	d,7(ix)

	ld	c,8(ix)
	ld	b,9(ix)

	ldir			; (DE++) <- (HL++), BC--
	
	pop	ix
	ret
			
	
	;; this is for a simple text mode screen where the attribute
	;; memory is used to store ASCII characters.

	;; clear 64x24 bytes to spaces in case of lenear screen
	;; just 1 K for Apple screen
	.globl _cls
_cls:
	ld	a, #0x20
	ld	b, #0
	ld	c, #4
	ld	hl, #0x4400
l1:	
	ld	(hl),a
	inc	hl
	djnz	l1
	dec	c
	jr	nz, l1
	ret

	.globl _print_hex
	.globl _print_dec
	.globl calc_screen_addr

_print_hex:

	push	ix
	ld	ix,#0
	add	ix,sp
	ld      l,4(ix)
	ld      h,5(ix)
	pop	ix

	push	bc

	push	hl
	call	calc_screen_addr
	ex	de,hl		; DE now points to screen addr
	pop	hl
	call	Num2Hex

	pop	bc
	ret

_print_dec:
	push	ix
	ld	ix,#0
	add	ix,sp
	ld      l,4(ix)
	ld      h,5(ix)
	pop	ix

	push	bc

	push	hl
	call	calc_screen_addr
	ex	de,hl		; DE now points to screen addr
	pop	hl
	call	Num2Dec

	pop	bc
	ret


;;;;; general library routines - very effecient implementations
;; taken from various places, public domain AFAIK

;Input: HL = number to convert, DE = location of ASCII string
;Output: ASCII string at (DE)

Num2Dec:
	ld	bc,#-10000
	call	Num1
	ld	bc,#-1000
	call	Num1
	ld	bc,#-100
	call	Num1
	ld	c,#-10
	call	Num1
	ld	c,#-1

Num1:	ld	a,#0x2f ;('0'-1)
Num2:	inc	a
	add	hl,bc
	jr	c,Num2
	sbc	hl,bc

	ld	(de),a
	inc	de
	ret


;Hexadecimal conversion operates directly on nibbles and takes advantage of nifty DAA trick.

;Input: HL = number to convert, DE = location of ASCII string
;Output: ASCII string at (DE)

Num2Hex:
	ld	a,h
	call	Num11
	ld	a,h
	call	Num22
	ld	a,l
	call	Num11
	ld	a,l
	jr	Num22

Num11:	rra
	rra
	rra
	rra
Num22:	or	#0xF0
	daa
	add	a,#0xA0
	adc	a,#0x40

	ld	(de),a
	inc	de
	ret

