module AppleVideoTiming (clk28, reset_in,vga_HS, vga_VS,BusCycle,CounterX,CounterY, HBL, VBL, flash_count4 );

   input clk28,  reset_in;
   output vga_HS, vga_VS,HBL, VBL;
   output [4:0] BusCycle;
   output     flash_count4 = flash_count[4];
   

   output     reg [6:0] 	 CounterX = 0;
   output     reg [9:0] 	 CounterY = 0;
   reg 	      vga_HS, vga_VS;

   wire       LDPS =  (BusCycle == 3) || (BusCycle == 17); // 
   reg [4:0]  BusCycle = 0;
   reg [4:0]  flash_count;

   always @(posedge clk28) 
     if (BusCycle == 27)
       BusCycle <= 0;
     else
       BusCycle <= BusCycle + 1;

  always @(posedge clk28) begin

	vga_HS <= (CounterX[6:2]==5'b10010); // change this value to move the display horizontally
	vga_VS <= (CounterY==10'b1111000000); // change this value to move the display vertically

	if(LDPS) begin
		if(!CounterX[6]) begin
		   CounterX <= 7'b1000000;
		   if(CounterY == 10'b1111111111) begin
		     	CounterY <= 10'b0111110100;
				flash_count = flash_count +1;
		   end 	else
		     CounterY <= CounterY+1;
		   
		end else
		  CounterX <= CounterX + 1;
	end
  end	

   	wire HBL = ~CounterX[5] & (~CounterX[4] | ~CounterX[3]); // up to 011000
	wire VBL = (CounterY[8] & CounterY[7]); // as in real Apple


endmodule