
/* Copyright (c) 1992 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  osunixt.h - operating system definitions for Unix-like system with
	      termcap/termio capability
Function
  Definitions that vary by operating system
Notes
  None
Modified
Sun Jan 24 13:10:10 EST 1993	Dave Baggett	Created.
Thu Apr 22 01:38:20 EDT 1993	Dave Baggett	Incorporated NeXT, Linux,
						DJGCC_386, etc. changes.
Sat Jan 29 10:49:25 EST 1994	Dave Baggett	Updated for TADS 2.1.2.2
Fri Aug 26 14:47:38 EDT 1994	Dave Baggett	Updated for TADS 2.2.0.0
Sun Sep 25 13:43:28 EDT 1994	Dave Baggett	Updated for TADS 2.2.0.2
Tue Nov 22 15:16:10 EST 1994	Dave Baggett	Updated for TADS 2.2.0.5
*/

#ifndef OSUNIXT_INCLUDED
#define OSUNIXT_INCLUDED


/* maximum width (in characters) of a line of text */
#define OS_MAXWIDTH  255

/*
 * Make default buffer sizes huge.  (Why not?  We have virtual memory.)
 */
#define TCD_SETTINGS_DEFINED
#define TCD_POOLSIZ  (24 * 1024)
#define TCD_LCLSIZ   (16 * 1024)
#define TCD_HEAPSIZ  65535
#define TCD_STKSIZ   512
#define TCD_LABSIZ   8192

#define TRD_SETTINGS_DEFINED
#define TRD_HEAPSIZ  65535
#define TRD_STKSIZ   512
#define TRD_UNDOSIZ  60000		/* WARNING: increasing to 65535 will cause crashes */

#define TDD_SETTINGS_DEFINED
#define TDD_HEAPSIZ  65535
#define TDD_STKSIZ   512
#define TDD_UNDOSIZ  60000		/* WARNING: increasing to 65535 will cause crashes */
#define TDD_POOLSIZ  (24 * 1024)
#define TDD_LCLSIZ   0			/* ? */

/*
 * Get GCC varags defs
 */

#if !defined(IBM_RT)
#define USE_STDARG
#define USE_GCC_STDARG
#endif

#if defined(ULTRIX_MIPS) || defined(SGI_IRIX) || defined(NEXT) || defined(DJGCC_386)
#include <stdarg.h>		/* get native stdargs */
#else
#include "gccstdar.h"		/* get GCC stdargs */
#endif

/*
 * Define the following to use sgtty.h instead of termios or direct
 * ioctl hacking.
 */
#if defined(NEXT) || defined(IBM_RT)
#define USE_IOCTL_INSTEAD_OF_TERMIOS
#define USE_SGTTY
#endif

#if !defined(SUN_SPARC_SUNOS) && !defined(SUN3) && !defined(ULTRIX_MIPS) && !defined(LINUX_386) && !defined(NEXT) && !defined(IBM_RT)
#define HAVE_TPARM	/* define if this system has the tparm routine */
#endif

#if defined(SUN_SPARC_SUNOS) || defined(SUN_SPARC_SOLARIS) || defined(SUN3) || defined(SGI_IRIX) || defined(LINUX_386) || defined(IBM_RT)
#define OS_USHORT_DEFINED
#endif

#if defined(SUN_SPARC_SUNOS) || defined(SUN_SPARC_SOLARIS) || defined(SUN3) || defined(SGI_IRIX) || defined(LINUX_386)
#define OS_UINT_DEFINED
#endif

#if defined(SGI_IRIX) || defined(LINUX_386) || defined(SUN_SPARC_SOLARIS)
#define OS_ULONG_DEFINED
#endif

#if defined(SGI_IRIX) || defined(LINUX_386)
#define TERMIOS_IS_NOT_IN_SYS
#endif

#if defined(IBM_RT)
#define remove unlink
#endif

/*
 * Need to strip off b's from fopen calls.
 */
#if !defined(DJGCC_386)
#define fopen our_fopen
#endif

/*
 * Some systems have stricmp; some have strcasecmp
 */
#ifdef HAVE_STRCASECMP
#define strnicmp strncasecmp
#define stricmp strcasecmp
#endif


/* far pointer type qualifier (null on most platforms) */
#  define osfar_t
#  define far

/* maximum theoretical size of malloc argument */
#  define OSMALMAX ((size_t)0xffffffff)

/* cast an expression to void */
#  define DISCARD (void)

#if !defined(IBM_RT)
#include <stdlib.h>
#endif
#include <stdio.h>
#if !defined(NEXT) && !defined(IBM_RT)
#include <unistd.h>
#endif
#if !defined(IBM_RT)
#include <memory.h>
#endif

#if defined(IBM_RT)
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

/*
 * Some machines are missing memmove, so we use our own memcpy/memmove 
 * routine instead.
 */
void *our_memcpy(void *dst, const void *src, size_t size); 
#define memcpy our_memcpy
#define memmove our_memcpy

/* display lines on which errors occur */
/* #  define OS_ERRLINE 1 */

/*
 *   If long cache-manager macros are NOT allowed, define
 *   OS_MCM_NO_MACRO.  This forces certain cache manager operations to be
 *   functions, which results in substantial memory savings.  
 */
/* #define OS_MCM_NO_MACRO */

/* likewise for the error handling subsystem */
/* #define OS_ERR_NO_MACRO */

/*
 *   If error messages are to be included in the executable, define
 *   OS_ERR_LINK_MESSAGES.  Otherwise, they'll be read from an external
 *   file that is to be opened with oserrop().
 */
#define OS_ERR_LINK_MESSAGES
#define ERR_LINK_MESSAGES

/* round a size to worst-case alignment boundary */
#define osrndsz(s) (((s)+3) & ~3)

/* round a pointer to worst-case alignment boundary */
#define osrndpt(p) ((uchar *)((((ulong)(p)) + 3) & ~3))

/* void pointer type */
typedef void dvoid;

#if	defined(DJGCC_386)

/* read unaligned portable 2-byte value, returning int */
#define osrp2(p) (*(short *)(p))

/* write int to unaligned portable 2-byte value */
#define oswp2(p, i) (*(short *)(p)=(i))

/* read unaligned portable 4-byte value, returning long */
#define osrp4(p) (*(long *)(p))

/* write long to unaligned portable 4-byte value */
#define oswp4(p, l) (*(long *)(p)=(l))

#else	/* defined(DJGCC_386) */

/* service macros for osrp2 etc. */
#define osc2u(p, i) ((uint)(((uchar *)(p))[i]))
#define osc2l(p, i) ((ulong)(((uchar *)(p))[i]))

/* read unaligned portable 2-byte value, returning int */
#define osrp2(p) (osc2u(p, 0) + (osc2u(p, 1) << 8))

/* write int to unaligned portable 2-byte value */
#define oswp2(p, i) ((((uchar *)(p))[1] = (i)>>8), (((uchar *)(p))[0] = (i)&255))

/* read unaligned portable 4-byte value, returning long */
#define osrp4(p) \
 (osc2l(p, 0) + (osc2l(p, 1) << 8) + (osc2l(p, 2) << 16) + (osc2l(p, 3) << 24))

/* write long to unaligned portable 4-byte value */
#define oswp4(p, i) \
 ((((uchar *)(p))[0] = (i)), (((uchar *)(p))[1] = (i)>>8),\
  (((uchar *)(p))[2] = (i)>>16, (((uchar *)(p))[3] = (i)>>24)))

#endif	/* defined(DJGCC_386) */

/* allocate storage - malloc where supported */
/* dvoid *osmalloc(size_t siz); */
#define osmalloc malloc

/* free storage allocated with osmalloc */
/* void osfree(dvoid *block); */
#define osfree free

/* copy a structure - dst and src are structures, not pointers */
#define OSCPYSTRUCT(dst, src) ((dst) = (src))

/* maximum length of a filename */
#define OSFNMAX 1024

/* normal path separator character */
#define OSPATHCHAR '/'

/* alternate path separator characters */
#define OSPATHALT "/"

#define OSPATHSEP ":"

/* os file structure */
typedef FILE osfildef;

/* main program exit codes */
#define OSEXSUCC 0                                 /* successful completion */
#define OSEXFAIL 1                                        /* error occurred */

/* open text file for reading; returns NULL on error */
/* osfildef *osfoprt(char *fname); */
#define osfoprt(fname) fopen(fname, "r")

/* open source file for reading */
/* osfildef *osfoprs(char *fname); */
#define osfoprs(fname) osfoprt(fname)

#if defined(DJGCC_386)

/* open binary file for writing; returns NULL on error */
/* osfildef *osfopwb(char *fname); */
#define osfopwb(fname) fopen(fname, "wb")

/* open binary file for reading; returns NULL on erorr */
/* osfildef *osfoprb(char *fname); */
#define osfoprb(fname) fopen(fname, "rb")

/* open binary file for reading/writing; truncate; returns NULL on error */
/* osfildef *osfoprwb(char *fname); */
#define osfoprwtb(fname) fopen(fname, "w+b")

/* open binary file for reading/writing; don't truncate */
/* osfildef *osfoprwb(char *fname); */
#define osfoprwb(fname) fopen(fname, "r+b")

#else	/* defined(DJGCC_386) */

/* open binary file for writing; returns NULL on error */
/* osfildef *osfopwb(char *fname); */
#define osfopwb(fname) fopen(fname, "w")

/* open binary file for reading; returns NULL on erorr */
/* osfildef *osfoprb(char *fname); */
#define osfoprb(fname) fopen(fname, "r")

/* open binary file for reading/writing; truncate; returns NULL on error */
/* osfildef *osfoprwb(char *fname); */
#define osfoprwtb(fname) fopen(fname, "w+")

/* open binary file for reading/writing; don't truncate */
/* osfildef *osfoprwb(char *fname); */
#define osfoprwb(fname) fopen(fname, "r+")

#endif	/* defined(DJGCC_386) */

/* get a line of text from a text file (fgets semantics) */
/* char *osfgets(char *buf, size_t len, osfildef *fp); */
#define osfgets(buf, len, fp) fgets(buf, len, fp)

/* write bytes to file; TRUE ==> error */
/* int osfwb(osfildef *fp, uchar *buf, int bufl); */
#define osfwb(fp, buf, bufl) (fwrite(buf, bufl, 1, fp) != 1)

/* read bytes from file; TRUE ==> error */
/* int osfrb(osfildef *fp, uchar *buf, int bufl); */
#define osfrb(fp, buf, bufl) (fread(buf, bufl, 1, fp) != 1)

/* get position in file */
/* long osfpos(osfildef *fp); */
#define osfpos(fp) ftell(fp)

/* seek position in file; TRUE ==> error */
/* int osfseek(osfildef *fp, long pos, int mode); */
#define osfseek(fp, pos, mode) fseek(fp, pos, mode)
#define OSFSK_SET  SEEK_SET
#define OSFSK_CUR  SEEK_CUR
#define OSFSK_END  SEEK_END

/* close a file */
/* void osfcls(osfildef *fp); */
#define osfcls(fp) fclose(fp)

/* delete a file - TRUE if error */
/* int osfdel(char *fname); */
#define osfdel(fname) remove(fname)

/* access a file - 0 if file exists */
/* int osfacc(char *fname) */
#define osfacc(fname) access(fname, 0)

/* open error file, returning file handle, or null if not found */
osfildef *oserrop(/*_ void _*/);

#define os_csr_busy(show_as_busy)

/*
 *   os_settype(file, type) sets a file to the given type.  This is
 *   required for certain operating systems which like to classify
 *   their files through these type identifiers.  The OSFTxxx constants
 *   are the abstract types we use; the os_settype implementation must
 *   translate to an appropriate OS type.  (This routine is a no-op on
 *   many systems.)
 */
#define OSFTLOG  0
#define OSFTGAME 1
#define OSFTSAVE 2
#define OSFTSWAP 3

/* ignore OS_LOADDS definitions */
# define OS_LOADDS

/* yield CPU; returns TRUE if user requested interrupt, FALSE to continue */
#define os_yield()  FALSE

/* update progress display with linfdef info, if appropriate */
#define os_progress(linf)

/*
 *   Single/double quote matching macros.  Used to allow systems with
 *   extended character codes with weird quote characters (such as Mac) to
 *   match the weird characters. 
 */
#define os_squote(c) ((c) == '\'')
#define os_dquote(c) ((c) == '"')
#define os_qmatch(a, b) ((a) == (b))

/*
 *   Options for this operating system
 */
# define USE_MORE        /* assume more-mode is desired (undef if not true) */
/* # define USEDOSCOMMON */
/* # define USE_OVWCHK */
/* # define USE_DOSEXT */
# define USE_NULLPAUSE
# define USE_TIMERAND
# define USE_NULLSTYPE
# define USE_PATHSEARCH


/*
 * Turning this off will enable termcap output.
 */
/* #define USE_STDIO */

#define STD_ASKFILE

#ifdef	USE_STDIO
/* #  define USE_NULLINIT */
#  define USE_NULLSTAT
#  define USE_NULLSCORE
#else	/* USE_STDIO */
#  define RUNTIME
#  define USE_STATLINE
#  define USE_HISTORY
#  define USE_SCROLLBACK
#endif

#  ifdef USE_SCROLLBACK
#   define OS_SBSTAT "(Review Mode)  ^P=Up  ^N=Down  <=Page Up  \
>=Page Down  Esc=Exit"
#  endif /* USE_SCROLLBACK */

#  ifdef USE_HISTORY
#   define HISTBUFSIZE 4096
#  endif /* USE_HISTORY */

/*
 *   Constants for os_getc() when returning commands.  When
 *   used for command line editing, special keys (arrows, END, etc.)
 *   should cause os_getc() to return 0, and return the appropriate
 *   CMD_ value on the NEXT call.  Hence, os_getc() must keep
 *   the appropriate information around statically for the next
 *   call when a command key is issued.
 *
 *   Note - this stuff is only needed in the character-mode console
 *   implementation when history is desired.
 */
# define CMD_UP    1        /* up arrow (recall last command) */
# define CMD_DOWN  2        /* down arrow (recall next command) */
# define CMD_RIGHT 3        /* right arrow (move cursor right) */
# define CMD_LEFT  4        /* left arrow (move cursor left) */
# define CMD_END   5        /* END key (move cursor to end of line) */
# define CMD_HOME  6        /* HOME key (move cursor to start of line) */
# define CMD_DEOL  7        /* DEL-EOL key (delete to end of line) */
# define CMD_KILL  8        /* KILL key (delete entire line) */
# define CMD_DEL   9        /* DEL key (delete current character) */
# define CMD_SCR   11       /* toggle scrollback mode */
# define CMD_PGUP  12       /* page up */
# define CMD_PGDN  13       /* page down */
# define CMD_TOP   14       /* control-pgup (top of file) */
# define CMD_BOT   15       /* control-pgdn (bottom of file */
# define CMD_F2    16
# define CMD_F3    17
# define CMD_F4    18
# define CMD_F5    19
# define CMD_F6    20
# define CMD_F7    21
# define CMD_F8    22
# define CMD_F9    23
# define CMD_F10   24
# define CMD_CHOME 25       /* control-home */
# define CMD_TAB   26
# define CMD_SF2   27       /* shift-F2 */
# define CMD_QUEUE 28       /* queued command */
# define CMD_WORD_LEFT  29  /* word left (ctrl-left on dos) */
# define CMD_WORD_RIGHT 30  /* word right (ctrl-right on dos) */
# define CMD_WORDKILL 35    /* erase previous word */

/*
 *   ALT-keys - add alphabetical code to CMD_ALT: ALT-A == CMD_ALT + 0,
 *   ALT-B == CMD_ALT + 1, ALT-C == CMD_ALT + 2, etc 
 */
# define CMD_ALT 128                                   /* start of ALT keys */

/*
 *   Some global variables needed for console implementation
 */
#  ifdef OSGEN_INIT
#   define E
#   define I(a) =(a)
#  else /* OSGEN_INIT */
#   define E extern
#   define I(a)
#  endif /* OSGEN_INIT */

E int status_mode;
E int score_column I(70);
E int sdesc_line I(0), sdesc_column I(0), sdesc_color I(23);
E int ldesc_line I(1), ldesc_column I(0), ldesc_color I(112);
E int debug_color I(0xe);

E int text_column I(0);
E int text_color I(7), text_bold_color I(15), text_normal_color I(7);
E int max_line I(24), max_column I(79);
E int ldesc_curline;
E int text_lastcol;

E int text_line I(1);

#  ifdef USE_GRAPH
void ossdsp();
E void (*os_dspptr)() I(ossdsp);
#   define ossdsp (*os_dspptr)
#  endif /* USE_GRAPH */

#  undef E
#  undef I

#endif /* OSUNIXT_INCLUDED */
