#ifdef RCSID
static char RCSid[] =
"$Header: d:/tads/tads2/RCS/os0.c 1.3 96/10/14 16:11:47 mroberts Exp $";
#endif

/* Copyright (c) 1992 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  os0.c - argument configuration utility
Function
  This module allows a "main" routine to get additional arguments
  from a configuration file.  We look for the given configuration
  file in the current directory, and if not found, in the executable's
  directory.  The arguments it contains are added before the command
  line arguments, except that any argument flags (along with an extra
  argument string, if any) listed in the "before" list are moved to
  the beginning of the argument list.  For example:

     before list = "i"
     config file contains "-m 128000 -1+ -tf- -i /tads/include"
     command line contains "-1- -i ../include -o test.gam test.t"
     translation:  "-i ../include -m 128000 -1+ -f- -i /tads/include
                    -o test.gam test.t"

   This allows arguments to be sorted according to precedence so that
   an argument in the command line overrides an argument in the config
   file.  The "before" list contains options that need to come first
   to override subsequent instances of the same option; other options
   override by coming later in the string.
Notes
  
Modified
  04/24/93 JEras         - use new os_locate() to find config file
  04/22/92 MJRoberts     - creation
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "os.h"

static char *endarg(p, end)
char *p;
char *end;
{
    if (*(p-1) == '"')
        while (p < end && *p != '"' && *p != '\n') ++p;
    else
        while (p < end && !isspace(*p)) ++p;

    return(p);
}

static char *firstarg(p, end)
char *p;
char *end;
{
    while (p < end && isspace(*p)) ++p;
    if (*p == '"' && p < end) ++p;
    return(p);
}

static char *nextarg(p, end)
char *p;
char *end;
{
    p = endarg(p, end);
    if (p < end && *p == '"') ++p;
    return(firstarg(p, end));
}

void os0main(oargc, oargv, mainfn, before, config)
int    oargc;
char  *oargv[];
void (*mainfn)(/*_ int argc, char *argv[] _*/);
char  *before;
char  *config;
{
    int    argc = 0;
    int    fargc = 0;
    char **argv;
    char  *configbuf, *configend;
    char  *p;
    int    i;
    FILE  *fp;
    long   fsiz;
    char   buf[128];
    FILE  *os_exeseek();

    /*
     *   Try for an embedded configuration file.  If we don't find one,
     *   try locating an external configuration file. 
     */
    if (oargv && oargv[0] && (fp = os_exeseek(oargv[0], "RCFG")))
    {
        fread(&fsiz, 1, sizeof(fsiz), fp);
    }
    else if (os_locate(config, (int)strlen(config), oargv[0], buf,
                       (size_t)sizeof(buf))
             && (fp = fopen(buf, "rb")))
    {
        fseek(fp, 0L, SEEK_END);
        fsiz = ftell(fp);
        fseek(fp, 0L, SEEK_SET);
    }
    else
    {
        fsiz = 0;
        fp = 0;
    }

    /* read the file if we found anything */
    if (fsiz)
    {
        configbuf = osmalloc((size_t)(fsiz + 1));
        configend = configbuf + fsiz;
        fread(configbuf, (size_t)fsiz, (size_t)1, fp);

        configbuf = firstarg(configbuf, configend);
        for (p = configbuf ; p < configend ; p = nextarg(p, configend),
             ++fargc);
    }

    /* close the file if we opened one */
    if (fp) fclose(fp);

    /* allocate space for the argument vector */
    argv = (char **)osmalloc((size_t)((oargc + fargc + 1) * sizeof(*argv)));

    /* first argument is always original argv[0] */
    argv[argc++] = oargv[0];

    /* put all user -i flags next */
    for (i = 0 ; i < oargc ; ++i)
    {
        if (oargv[i][0] == '-' && strchr(before, oargv[i][1]))
        {
            argv[argc++] = oargv[i];
            if (oargv[i][2] == '\0' && i+1 < oargc) argv[argc++] = oargv[++i];
        }
    }

    /* put all config file flags next */
    for (p = configbuf, i = 0 ; i < fargc ; ++i)
    {
        char *nxt;

        argv[argc++] = p;
        nxt = nextarg(p, configend);
        *endarg(p, configend) = '\0';
        p = nxt;
    }

    /* put all user parameters other than -i flags last */
    for (i = 1 ; i < oargc ; ++i)
    {
        if (oargv[i][0] == '-' && strchr(before, oargv[i][1]))
        {
            if (oargv[i][2] == '\0' && i+1 < oargc) ++i;
        }
        else
        {
            argv[argc++] = oargv[i];
        }
    }

    /* call real main with the modified argument list */
    (*mainfn)(argc, argv);
}
