/*
$Header: d:/tads/tads2/RCS/os.h 1.9 96/10/14 16:10:38 mroberts Exp $
*/

/* Copyright (c) 1991 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  os.h - operating system definitions
Function
  Definitions that vary by operating system
Notes
  None
Modified
  08/13/91 MJRoberts     - creation
*/

#ifndef OS_INCLUDED
#define OS_INCLUDED

#if defined(THINK_C) || defined(UNIX) || defined(ATARI)

/*
 * Some ports use their own include files
 */
#if defined(THINK_C)
#include "osmac.h"
#elif defined(UNIX)
#include "osunixt.h"
#elif defined(ATARI)
#include "osatari.h"
#endif

#else /* defined(THINK_C) ... */

#ifndef LOS_INCLUDED
# include "los.h"
#endif

/*
 *   System name 
 */
#define OS_SYSTEM_NAME  "MSDOS"

/* maximum width (in characters) of a line of text */
#define OS_MAXWIDTH  135


#  ifdef USE_GRAPH
/* establish some other options for TADS/Graphic */
#   define RUNTIME
#   define USE_LDESC
#   define USE_FSDBUG
#  endif /* USE_GRAPH */

/*
 *   Set "busy" cursor on/off.  For systems with a mouse cursor, set the
 *   cursor to an appropriate shape to notify the user that the system is
 *   busy.  Does nothing on DOS.
 */
/* void os_csr_busy(int show_as_busy); */
#define os_csr_busy(show_as_busy)


/*
 *   If long cache-manager macros are NOT allowed, define
 *   OS_MCM_NO_MACRO.  This forces certain cache manager operations to be
 *   functions, which results in substantial memory savings.  
 */
#define OS_MCM_NO_MACRO

/* likewise for the error handling subsystem */
#define ERR_NO_MACRO


/*
 *   If error messages are to be included in the executable, define
 *   ERR_LINK_MESSAGES.  Otherwise, they'll be read from an external
 *   file that is to be opened with oserrop().
 */
/* #define ERR_LINK_MESSAGES */

/* file types - not used by DOS */
#define OSFTLOG  0
#define OSFTGAME 1
#define OSFTSAVE 2
#define OSFTSWAP 3

/*
 *   Yield CPU; returns TRUE if user requested interrupt, FALSE to
 *   continue.  Normally, this doesn't do anything; under a 16-bit DPMI
 *   system, we need to check manually for ^C (see os0tc.c). 
 */
#ifndef __DPMI16__
# define os_yield()  FALSE
#endif

/* update progress display with linfdef info, if appropriate */
#define os_progress(linf)

/*
 *   Single/double quote matching macros.  Used to allow systems with
 *   extended character codes with weird quote characters (such as Mac) to
 *   match the weird characters. 
 */
#define os_squote(c) ((c) == '\'')
#define os_dquote(c) ((c) == '"')
#define os_qmatch(a, b) ((a) == (b))

/*
 *   Options for this operating system
 */
# define USE_MORE        /* assume more-mode is desired (undef if not true) */
# define USEDOSCOMMON
# define USE_OVWCHK
# define USE_DOSEXT
# define USE_NULLPAUSE
# define USE_TIMERAND
# define USE_NULLSTYPE
# define USE_PATHSEARCH                  /* use search paths for tads files */
# ifdef RUNTIME
#  define USE_FSDBUG                              /* full-screen debug mode */
#  define USE_STATLINE
#  define USE_HISTORY
#  define USE_SCROLLBACK

#  ifdef USE_SCROLLBACK
#   define OS_SBSTAT "(Review Mode)  \030=Up  \031=Down  PgUp=Page Up  \
PgDn=Page Down  F1=Exit"
#  endif /* USE_SCROLLBACK */

#  ifdef USE_HISTORY
#   define HISTBUFSIZE 4096
#  endif /* USE_HISTORY */

/*
 *   Constants for os_getc() when returning commands.  When
 *   used for command line editing, special keys (arrows, END, etc.)
 *   should cause os_getc() to return 0, and return the appropriate
 *   CMD_ value on the NEXT call.  Hence, os_getc() must keep
 *   the appropriate information around statically for the next
 *   call when a command key is issued.
 *
 *   Note - this stuff is only needed in the character-mode console
 *   implementation when history is desired.
 */
# define CMD_UP    1        /* up arrow (recall last command) */
# define CMD_DOWN  2        /* down arrow (recall next command) */
# define CMD_RIGHT 3        /* right arrow (move cursor right) */
# define CMD_LEFT  4        /* left arrow (move cursor left) */
# define CMD_END   5        /* END key (move cursor to end of line) */
# define CMD_HOME  6        /* HOME key (move cursor to start of line) */
# define CMD_DEOL  7        /* DEL-EOL key (delete to end of line) */
# define CMD_KILL  8        /* KILL key (delete entire line) */
# define CMD_DEL   9        /* DEL key (delete current character) */
# define CMD_SCR   11       /* toggle scrollback mode */
# define CMD_PGUP  12       /* page up */
# define CMD_PGDN  13       /* page down */
# define CMD_TOP   14       /* control-pgup (top of file) */
# define CMD_BOT   15       /* control-pgdn (bottom of file */
# define CMD_F2    16
# define CMD_F3    17
# define CMD_F4    18
# define CMD_F5    19
# define CMD_F6    20
# define CMD_F7    21
# define CMD_F8    22
# define CMD_F9    23
# define CMD_F10   24
# define CMD_CHOME 25       /* control-home */
# define CMD_TAB   26
# define CMD_SF2   27       /* shift-F2 */
# define CMD_QUEUE 28       /* queued command */
# define CMD_WORD_LEFT  29  /* word left (ctrl-left on dos) */
# define CMD_WORD_RIGHT 30  /* word right (ctrl-right on dos) */
       
/*
 *   ALT-keys - add alphabetical code to CMD_ALT: ALT-A == CMD_ALT + 0,
 *   ALT-B == CMD_ALT + 1, ALT-C == CMD_ALT + 2, etc 
 */
# define CMD_ALT 128                                   /* start of ALT keys */

/*
 *   Some global variables needed for console implementation
 */
#  ifdef OSGEN_INIT
#   define E
#   define I(a) =(a)
#  else /* OSGEN_INIT */
#   define E extern
#   define I(a)
#  endif /* OSGEN_INIT */

E int status_mode;
E int score_column I(70);
E int sdesc_line I(0), sdesc_column I(0), sdesc_color I(23);
E int ldesc_line I(1), ldesc_column I(0), ldesc_color I(112);
E int debug_color I(0xe);

#  ifdef USE_LDESC
E int text_line I(12);
#  else /* USE_LDESC */
E int text_line I(1);
# endif /* USE_LDESC */

E int text_column I(0);
E int text_color I(7), text_bold_color I(15), text_normal_color I(7);
E int max_line I(24), max_column I(79);
E int ldesc_curline;
E int text_lastcol;
       
#  ifdef USE_GRAPH
void ossdsp();
E void (*os_dspptr)() I(ossdsp);
#   define ossdsp (*os_dspptr)
#  endif /* USE_GRAPH */

#  undef E
#  undef I

# else /* RUNTIME */
#  ifndef USE_DOOR
#   define USE_STDIO
#   define STD_ASKFILE
#  else /* USE_DOOR */
/* #   define USE_STDARG */
#  endif /* USE_DOOR */
#  define USE_NULLINIT
#  define USE_NULLSTAT
#  define USE_NULLSCORE
# endif /* RUNTIME */

# define USE_STDARG

#endif /* THINK_C */

/*
 *   Create and open a temporary file.  Creates and opens a temporary
 *   file.  If 'swapname' is null, this routine must choose a file name
 *   and fill in 'buf' with the chosen name; if possible, the file should
 *   be in the conventional location for temporary files on this system,
 *   and should be unique (i.e., it shouldn't be the same as any existing
 *   file).  
 */
osfildef *os_create_tempfile(/*_ char *swapname, char *buf _*/);

/*
 *   Get the temporary file path.  This should fill in the buffer with a
 *   path prefix (suitable for strcat'ing a filename onto) for a good
 *   directory for a temporary file, such as the swap file.  
 */
void os_get_tmp_path(/*_ char *buf _*/);



#endif /* OS_INCLUDED */

