/*
$Header: d:/tads/lib/RCS/los.h 1.2 96/10/14 15:54:43 mroberts Exp Locker: mroberts $
*/

/* Copyright (c) 1991 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  los.h - library operating system definitions
Function
  Definitions that vary by operating system
Notes
  None
Modified
  01/08/93 SMcAdams  - add OSMAXINT, OSMAXUINT for DOS
  12/30/92 MJRoberts - created from TADS os.h
  08/13/91 MJRoberts - creation
*/

#ifdef UNIX
#include "os.h"
#endif

#ifndef LOS_INCLUDED
#define LOS_INCLUDED

#ifdef THINK_C
#include "os.h"
#else /* THINK_C */

#define ERR_NO_MACRO

#ifdef MSDOS

#ifdef __DPMI32__
#define __32BIT__
#define far
#endif


/* define OS_LOADDS appropriately for the Microsoft compiler */
# ifdef MICROSOFT
#  define OS_LOADDS _loadds
# endif /* MICROSOFT */

# ifdef MSOS2

/*----------------------------- OS/2 definitions ---------------------------*/

/* OS/2 2.0 is 32-bit - no need for FAR pointers at all */
#  ifdef __32BIT__
#   define far
#  endif /* __32BIT__ */

#  define MAXPATH 255

/* theoretical maximum osmalloc size is all of memory */
#  ifdef __32BIT__
#   define OSMALMAX 0xffffffffL
#  else /* !__32BIT__ */
#   define OSMALMAX 0xffffL
#  endif /* __32BIT__ */

# else /* MSOS2 */

/*----------------------------- DOS definitions ----------------------------*/
#  include <dos.h>
#  include <direct.h>

/* theoretical maximum malloc size is somewhat less than 64k */
#  define OSMALMAX 0xff00L

/* maximum 16-bit integer values */
#  define OSMAXINT   0x7fff
#  define OSMAXUINT  0xffff

# endif /* MSOS2 */

/*------------ the rest of this file is common to DOS and OS/2 -----------*/

#  include <stdlib.h>
#  include <stdio.h>
#  include <stddef.h>

/* far pointer type qualifier (null on most platforms) */
#  define osfar_t   far

/* void a return value */
#define DISCARD (void)

/* round a size to worst-case alignment boundary */
#define osrndsz(s) (((s)+3) & ~3)

/* round a pointer to worst-case alignment boundary */
#define osrndpt(p) ((uchar *)((((ulong)(p)) + 3) & ~3))

/* void pointer type */
typedef void dvoid;

/* read unaligned portable 2-byte value, returning int */
#define osrp2(p) (*(short *)(p))

/* write int to unaligned portable 2-byte value */
#define oswp2(p, i) (*(short *)(p)=(i))

/* read unaligned portable 4-byte value, returning long */
#define osrp4(p) (*(long *)(p))

/* write long to unaligned portable 4-byte value */
#define oswp4(p, l) (*(long *)(p)=(l))

/* allocate/release storage - malloc/free where supported */
/* dvoid *osmalloc(size_t siz); */
/* void osfree(dvoid *block); */

#if defined(_Windows) && !defined(__DPMI32__)

dvoid *ltk_alloc(size_t siz);
void   ltk_free(void *blk);
# define osmalloc(siz) ltk_alloc(siz)
# define osfree(block) ltk_free(block)

#else /* _Windows */

# define osmalloc(siz) malloc(siz)
# define osfree(block) free(block)

#endif /* _Windows */

/* copy a structure - dst and src are structures, not pointers */
#define OSCPYSTRUCT(dst, src) ((dst) = (src))

/* ANSI compiler */
#define OSANSI

/* maximum length of a filename */
#ifdef _MAX_PATH
/* this is the Microsoft macro for the maximum length of a file path */
# define OSFNMAX  _MAX_PATH
#else
/* this is the Borland macro for the maximum length of a file path */
# define OSFNMAX  MAXPATH
#endif

/* normal path separator character */
#define OSPATHCHAR '\\'

/* alternate path separator characters */
#define OSPATHALT "/:"

/* directory separator character for PATH-style environment variables */
#define OSPATHSEP ';'                                        /* ':' on UNIX */

/* os file structure */
typedef FILE osfildef;

/* main program exit codes */
#define OSEXSUCC 0                                 /* successful completion */
#define OSEXFAIL 1                                        /* error occurred */

/* open text file for reading; returns NULL on error */
/* osfildef *osfoprt(char *fname); */
#define osfoprt(fname) fopen(fname, "r")

/* open text file for writing; returns NULL on error */
/* osfildef *osfopwt(char *fname); */
#define osfopwt(fname) fopen(fname, "w")

/* open binary file for writing; returns NULL on error */
/* osfildef *osfopwb(char *fname); */
#define osfopwb(fname) fopen(fname, "wb")

/* open SOURCE file for reading - use appropriate text/binary mode */
#define osfoprs(fname) fopen(fname, "rb")

/* open binary file for reading; returns NULL on erorr */
/* osfildef *osfoprb(char *fname); */
#define osfoprb(fname) fopen(fname, "rb")

/* get a line of text from a text file (fgets semantics) */
/* char *osfgets(char *buf, size_t len, osfildef *fp); */
#define osfgets(buf, len, fp) fgets(buf, len, fp)

/* open binary file for reading/writing; don't truncate */
/* osfildef *osfoprwb(char *fname); */
#define osfoprwb(fname) fopen(fname, "r+b")

/* open binary file for reading/writing; truncate; returns NULL on error */
/* osfildef *osfoprwtb(char *fname); */
#define osfoprwtb(fname) fopen(fname, "w+b")

/* write bytes to file; TRUE ==> error */
/* int osfwb(osfildef *fp, uchar *buf, int bufl); */
#define osfwb(fp, buf, bufl) (fwrite(buf, bufl, 1, fp) != 1)

/* read bytes from file; TRUE ==> error */
/* int osfrb(osfildef *fp, uchar *buf, int bufl); */
#define osfrb(fp, buf, bufl) (fread(buf, bufl, 1, fp) != 1)

/* read bytes from file and return count; returns # bytes read, 0=error */
/* size_t osfrbc(osfildef *fp, uchar *buf, size_t bufl); */
#define osfrbc(fp, buf, bufl) (fread(buf, 1, bufl, fp))

/* get position in file */
/* long osfpos(osfildef *fp); */
#define osfpos(fp) ftell(fp)

/* seek position in file; TRUE ==> error */
/* int osfseek(osfildef *fp, long pos, int mode); */
#define osfseek(fp, pos, mode) fseek(fp, pos, mode)
#define OSFSK_SET  SEEK_SET
#define OSFSK_CUR  SEEK_CUR
#define OSFSK_END  SEEK_END

/* close a file */
/* void osfcls(osfildef *fp); */
#define osfcls(fp) fclose(fp)

/* delete a file - TRUE if error */
/* int osfdel(char *fname); */
#define osfdel(fname) remove(fname)

/* access a file - 0 if file exists */
/* int osfacc(char *fname) */
#define osfacc(fname) access(fname, 0)


/* open error file, returning file handle, or null if not found */
osfildef *oserrop(/*_ void _*/);

# endif /* MSDOS */

/*
 *   If we haven't defined OS_LOADDS, define it to nothing.  This should
 *   translate to _loadds when building DLL's with Microsoft compilers.  
 */
# ifndef OS_LOADDS
#  define OS_LOADDS
# endif


#endif /* THINK_C */
#endif /* LOS_INCLUDED */
