/* convert Veneskey format SCOTT ADAMS adventures to TRS-80 format */
/*  [slight changes applied:   9/26/94   PDD]  */

/* released into the public domain */

#include <stdio.h>
#include <string.h>

FILE  *temp1, *temp2;

char instr [1000];  /* make it big */
char outstr[1000];  /* ditto */
int count=1000, j, k;
int header[12];
int verbno, condition;
char tempstr[30];
int action[4];
char tchar;
char *cleanquote();

char comment[350][25];

void main  (void)
{
/* Convert Veneskey ASCII format to TRS-80 ASCII format. */

/* Header.  The V. file does not have the 0th or 13th entry, which we
   will set to zero.  The intermediate entries are 3 bytes each.

	instr  = "";
   	outstr = "";  /* clear */
	printf(" 0 \n");   /* initial zero */
	gets(instr);
	for (j=0; j<11; j++)
	{
		strncpy(outstr, instr + 3*j, 3);
		outstr[3] = '\0';
		header[j+1] = atoi(outstr);
		printf(" %d \n", atoi(outstr));
	}

/* Now there is some out of order stuff! */
/* Save off the wordlist to temp1. */

	temp1 = fopen("wordlist", "w");
	for (j=1; j<=2*(header[3]+1); j++)
	{
		gets(instr);
		fprintf(temp1, "%s\n", instr);
	}
	fclose(temp1);

/* Game actions, can be output after cracking them. */

	for (j=1; j<=header[2]+1; j++)
	{
		gets(instr);

		for (k=0;k<=21;k++) comment[j][k]=instr[k+42];
		comment[j][22]=0;
		for (k=21;k>=0;k--) 
		{
			if (comment[j][k]==' ') comment[j][k]=0;
			else break;
		}

		/* six bytes for 150*verb + noun */
		strncpy(outstr, instr, 3);
		outstr[3] = '\0';
		verbno = atoi(outstr);
		strncpy(outstr, instr + 3, 3);
		verbno = 150*verbno + atoi(outstr);
		printf(" %d \n", verbno);
		/* now the five condition+20*value, 4 bytes */
		for (k=0; k<5; k++)
		{
		  tchar = instr[6+k*4];
		  if(tchar == 'Z')
		    { printf(" 0 \n"); }
		  else
		    {

/* ok, so this is lousy code, it should have been done with a simple
   index into an array.  I hereby state that the following is a little
   easier to maintain, that the program will not be run very often, and
   that the speed/efficiency of the code is immaterial.  If the code
   offends your sensibilities, change it. My only regret is not having
   the opportunity to use a 'goto' statement. */

		        condition = -1;
			if(tchar == 'P') condition = 0;
			if(tchar == 'G') condition = 1;
			if(tchar == 'A') condition = 2;
			if(tchar == 'C') condition = 3;
			if(tchar == 'K') condition = 4;
			if(tchar == 'B') condition = 5;
 			if(tchar == 'H') condition = 6;
			if(tchar == 'L') condition = 7;
			if(tchar == 'E') condition = 8;
			if(tchar == 'F') condition = 9;
			if(tchar == 'Q') condition = 10;
			if(tchar == 'R') condition = 11;
			if(tchar == 'D') condition = 12;
			if(tchar == 'J') condition = 13;
			if(tchar == 'I') condition = 14;
			if(tchar == 'M') condition = 15;
			if(tchar == 'N') condition = 16;
			if(tchar == 'S') condition = 17;
			if(tchar == 'T') condition = 18;
			if(tchar == 'O') condition = 19;
			if(condition == -1) 
			  {
			    printf("found unknown condition in line\n%s\n", instr);
                            condition = 0;
			  }
			strncpy(tempstr, instr + 7 + k*4, 3);
			tempstr[3] = '\0';
			condition = condition + 20*atoi(tempstr);
			printf(" %d \n", condition);
		      }
		}
		/* and then actions 1-4, 4 bytes each ???? */
		for (k=0; k<4; k++)
		  {
		    strncpy(tempstr, instr + 26 + k*4, 4);  
		    tempstr[4] = '\0';
		    action[k] = -1;
		    if(tempstr[0]=='z' )action[k]=0;
		    if(tempstr[0]=='A')
		      { 
		        action[k]=atoi(&tempstr[1]);
			if(action[k]>51)action[k] += 50;
		      }
		    if(tempstr[0]=='E')action[k]=52;
		    if(tempstr[0]=='D')action[k]=53;
		    if(tempstr[0]=='S')action[k]=54;
		    if(tempstr[0]=='B')action[k]=55;
		    if(tempstr[0]=='I')action[k]=56;
		    if(tempstr[0]=='H')action[k]=57;
		    if(tempstr[0]=='F')action[k]=58;
		    if(tempstr[0]=='B')action[k]=59;
		    if(tempstr[0]=='G')action[k]=60;
		    if(tempstr[0]=='Q')action[k]=61;
		    if(tempstr[0]=='R')action[k]=62;
		    if(tempstr[0]=='O')action[k]=63;
		    if(tempstr[0]=='J')action[k]=64;
		    if(tempstr[0]=='N')action[k]=65;
		    if(tempstr[0]=='U')action[k]=66;
		    if(tempstr[0]=='M')action[k]=67;
		    if(tempstr[0]=='L')action[k]=68;
		    if(tempstr[0]=='i')action[k]=69;
		    if(tempstr[0]=='T')action[k]=70;
		    if(tempstr[0]=='V')action[k]=71;
		    if(tempstr[0]=='K')action[k]=72;
		    if(tempstr[0]=='b')action[k]=73;
		    if(tempstr[0]=='Z')action[k]=74;
		    if(tempstr[0]=='h')action[k]=75;
		    if(tempstr[0]=='J')action[k]=76;
		    if(tempstr[0]=='X')action[k]=77;
		    if(tempstr[0]=='a')action[k]=78;
		    if(tempstr[0]=='Y')action[k]=79;
		    if(tempstr[0]=='j')action[k]=80;
		    if(tempstr[0]=='e')action[k]=81;
		    if(tempstr[0]=='f')action[k]=82;
		    if(tempstr[0]=='c')action[k]=83;
		    if(tempstr[0]=='l')action[k]=84;
		    if(tempstr[0]=='W')action[k]=85;
		    if(tempstr[0]=='m')action[k]=86;
		    if(tempstr[0]=='g'||tempstr[0]=='k')action[k]=87;
		    if(tempstr[0]=='d')action[k]=88;
/* code unknown */  if(tempstr[0]==' ')action[k]=89;
		    if(action[k]==-1)
			  {
			    printf("found a new action in line\n%s\n", instr);
                            action[k] = 0;
			  }
		  }
		action[1] = 150*action[0]+action[1];
		action[2] = 150*action[2]+action[3];
		printf(" %d \n", action[1]);
		printf(" %d \n", action[2]);
	}

/* now it's time to doublequote and write back the word file */

	temp1 = fopen("wordlist", "r");
	while (fgets(instr, count, temp1) != NULL)
	{  
	  instr[strlen(instr)-1] = '\0';
	  printf("\"%s\"\n", instr);
	}   

/* now deal with the rooms and directions */
/* we will have to deal with the use of double quotes which must be 
   changed to single backquotes, and the ~ line break character.
   Fun it's not! */

	for (j=0;j<=header[4];j++)
	  {
	    gets(instr);
	    strcpy(instr, cleanquote(&instr));
	    for (k=0; k<6; k++)
	      {
		strncpy(outstr, instr + 3*k, 3);
		outstr[3] = '\0';
		printf(" %d \n", atoi(outstr));
	      }
	    if (instr[18] == '\0')
	      { printf("\"\"\n");}
	    else
	      {
		strncpy(outstr, instr + 18, strlen(instr)-18);
		outstr[strlen(instr)-18] = '\0';
		printf("\"");
		for(k=0;k<strlen(outstr);k++)
 			if(!((outstr[k]==' ')&&(outstr[k+1]=='\n')))
				printf("%c",outstr[k]);
		printf("\"\n");
	      }
	   } 

/* messages next */

           for (j=0;j<=header[10];j++)
           {
	     gets(instr);
	     strcpy(instr, cleanquote(&instr));
	     if (strlen(instr) == 0) printf("\"\"\n");
	     else
	       {
		 strncpy(outstr, instr, strlen(instr));
		 outstr[strlen(instr)] = '\0';
		 printf("\"");
		 for(k=0;k<strlen(outstr);k++)
			 if(!((outstr[k]==' ')&&(outstr[k+1]=='\n')))
				 printf("%c",outstr[k]);
		 printf("\"\n");
	       }
	   }
 
/* items */
	for (j=0; j<=header[1]; j++)
	  {
	    gets(instr);
            strcpy(instr, cleanquote(&instr));
	    strncpy(outstr, instr + 3, strlen(instr)-3);
	    outstr[strlen(instr)-3] = '\0';
	    strncpy(tempstr, instr, 3);
	    tempstr[3] = '\0';
	    printf("\"");
	    for(k=0;k<strlen(outstr);k++)
		if(!((outstr[k]==' ')&&(outstr[k+1]=='\n')))
			 printf("%c",outstr[k]);
	    printf("\" %d \n", (atoi(tempstr)==999)?255:atoi(tempstr));
	  }

/* comments */
	for (j=1; j<=header[2]+1; j++)
             printf("\"%s\"\n",comment[j]);

/* trailing junk */
	printf(" 0 \n 0 \n 0 \n");
}

char *cleanquote(char *instr)
{
  char temp[1000];
  int j;

  strcpy(temp, instr);
  for (j=0; j<strlen(temp); j++)
    {
      if (temp[j] == '"') temp[j] = '`';
      if (temp[j] == '~') temp[j] = '\n';
    }

  return(temp);
}
