/***************************************************************************

Another ScottFree Driver, revision 1.2 beta.
Derived from Alan Cox's "ScottFree" revision 1.14,
that work (C) 1993, 1994, 1995 Swansea University Computer Society.
This driver (C) 1998 Robert Schneck.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program (see the file 'license.txt'); if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Statement: Everything in this program has been deduced or obtained
solely from published material.  No game interpreter code has been
disassembled.

***************************************************************************/

/* Driver Messages.  Change these for second person or other styles */

/* Look */
#define DM_TOO_DARK_TO_SEE "TOO DARK TO SEE!\n"
#define DM_ROOM_PREFIX "I'm in a "
/* Parsing command */
#define DM_WHAT_NOW "What shall I do now?\n"
#define DM_TOO_MANY_WORDS "Use 1 or 2 words only!\n"
#define DM_NO_VERB "Don't know how to \"%s\" something.\n"
#define DM_NO_NOUN "Don't know what \"%s\" is.\n"
#define DM_DONT_UNDERSTAND "I don't understand you.\n"
#define DM_NOT_YET "Can't do that... YET!\n"
/* Light */
#define DM_LIGHT_OUT "\nLIGHT RAN OUT!\n"
#define DM_LIGHT_COUNTDOWN "\nLight runs out in %d turns.\n"
/* Probably should change that to something without %d if you use the
   -d option */
/* Score */
#define DM_STORED_TREASURES "Stored %d treasures. "
#define DM_SCORE_SCALE "Scale 0-100 thats %d.\n"
/* Endings */
#define DM_YOU_WON "YOU WON!\n"
#define DM_ADVENTURE_OVER "ADVENTURE over.\n"
#define DM_DEAD "I'm DEAD!\n"
/* Inventory */
#define DM_CARRYING "CARRYING: "
#define DM_NOTHING "Nothing!\n"
/* Movement */
#define DM_NO_DIRECTION "I also need a direction.\n"
#define DM_DANGEROUS_DARK "Dangerous to move in the dark!\n"
#define DM_BROKE_NECK "Fell & broke my neck!\n"
#define DM_NO_WAY "Can't go that way.\n"
/* Get and Drop */
#define DM_NO_ITEM "Huh?\n"
#define DM_GET_ALL_DARK "TOO DARK TO SEE!\n"
#define DM_NO_GET_ALL "Don't see it here!\n"
#define DM_NO_DROP_ALL "Not carrying it!\n"
#define DM_BEYOND_POWER "Beyond my power to do that.\n"
#define DM_NOT_CARRIED "Not carrying it!\n"
#define DM_ITEM_NOT_HERE "Don't see it here!\n"
#define DM_GOT_TOO_MUCH "Got too much. TAKE INVENTORY.\n"
#define DM_ALREADY_HAVE "Already have it.\n"
#define DM_OKAY "OK\n"
/* GET/DROP can give away whether an item is special if the 
   driver's okay is different from the game's okay! */


/* Option bits */

#define ALL_OPTION 1
#define LOOK_OPTION 2
#define DIM_OPTION 4
#define SPACE_OPTION 8
#define PREHISTORIC_LAMP_OPTION 16
#define TRACE_OPTION 32


/* Driver values */

#define MAX_BITFLAG 31
/* MAX_COUNTER also used for savedRoom */
#define MAX_COUNTER 15

#if !defined(TRUE) || (TRUE != 1)
#define TRUE 1
#endif
#if !defined(FALSE) || (FALSE != 0)
#define FALSE 0
#endif


/* Hard-wired game values */

#define LIGHT_SOURCE 9
#define GO_VERB 1
#define GET_VERB 10
#define DROP_VERB 18

#define CARRIED 255
#define DESTROYED 0

#define DARKBIT 15
#define LIGHTOUTBIT 16


typedef char boolean; /* oops no boolean in C! */


typedef struct {
  char *text;
  short initialLoc;
  char *autoGet;
} Item;

typedef struct {
  short verb;
  short noun;
  short condition[5];
  short value[5];
  short action[4];
  char* comment;
} Action;

typedef struct {
  char *text;
  short exit[6];
} Room;


char* ReadString(FILE* f);
void LoadDatabase(char *filename);
boolean RestoreGame(char *filename);
void SaveGame(void);

void ParseArguments(int *argc,char **argv[]);

void TitleScreen(void);

void Fatal(char *message);
void *MemAlloc(int size);

boolean GetBit(short bit);
void SetBit(short bit);
void ClearBit(short bit);
boolean GetOption(int option);
void SetOption(int option);
void ClearOption(int option);
void ToggleOption(int option);

boolean Dark(void);
boolean RandomPercent(short n);
short CountCarried(void);
boolean CondInRoom(short val);
boolean CondHere(short val);
boolean CondCarried(short val);
boolean CondDestroyed(short val);
boolean CondAvailable(short val);
boolean CondOriginalRoom(short val);

void Quit(void);
void KillPlayer(void);
void Score(void);
void Inventory(void);
void FillLamp(void);

void InitGame(void);

boolean Redraw(void);
void Look(void);

void GetInput(void);
short WhichWord(char* word,char **list);
boolean NounIsAutoget(void);

void OutReset(void);

boolean PerformActionLine(short act);

void AutoActions (void);

short WhichItem(short nounNum,short loc);
boolean Get(short item);
boolean GetCommand(boolean notYet);
void Drop(short item);
boolean DropCommand(boolean notYet);
boolean MoveCommand(void);
void PerformCommand (void);

void WorkLight(void);

void MainLoop (void);
