#include <tads.h>

/*
 * An XTads test game.
 * Focus is on resizing of horiz. grid banner to contents.
 */
main(args)
{
	local b0 = nil;

    "A banner test game for XTads.\b\b";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignTop,
                       0, BannerSizeAbsolute,
                       0);
    bannerSetTextColor(b1, ColorYellow, ColorBlack);
    "b1 (child of b0) is a horizontal grid banner above b0. Initial size is abs 0, so should not be visible. ";
    "\bPress a key to continue...\n";
    inputKey();
    
    //---

    bannerSizeToContents(b1);
    "\bb1 has now been sized to contents (0 lines) so should still be invisible";
    "\bPress a key to continue...\n";
    inputKey();

    //---
    
    bannerSay(b1, 'lije 1');
    "\bb1 now contains 1 line but has size 0, so should still be invisible. ";
    inputKey();

    bannerSizeToContents(b1);
    "\bb1 has now been sized to contents (1 lines) so should be visible";
    inputKey();

    //---
    
    bannerSay(b1, '\nlije 2');
    "\bb1 now contains 2 lines but has size 1 ";
    inputKey();

    bannerSizeToContents(b1);
    "\bb1 has now been sized to contents (2 lines)";
    inputKey();

    //---
    
    bannerSay(b1, '\nlije 3\n');
    "\bb1 now contains 3 lines but has size 2 ";
    inputKey();

    bannerSizeToContents(b1);
    "\bb1 has now been sized to contents (3 lines)";
    inputKey();

    //---
    
    bannerSay(b1, '\nlije 4\nlije 5\nlije 6');
    "\bb1 now contains 6 lines but has size 3";
    inputKey();

    bannerSizeToContents(b1);
    "\bb1 has now been sized to contents (6 lines)";
    inputKey();

    //---
    
    bannerClear(b1);
    "\bb1 now contains 0 lines but has size 6";
    inputKey();

    bannerSizeToContents(b1);
    "\bb1 has now been sized to contents (0 lines) so should be invisible";
    inputKey();

    //---

    bannerSay(b1, '\nlije 1\nlije 2\n\nlije 3');
    "\bb1 now contains 3 lines but has size 0";
    inputKey();

    bannerSizeToContents(b1);
    "\bb1 has now been sized to contents (3 lines)";
    inputKey();
    
    //---

    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(win)
{
    local info = bannerGetInfo(win);

    "align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>";
}
