#include <tads.h>

/*
 * An XTads test game.
 * Focus is on abs. resizing of horiz. text banner.
 */
main(args)
{
	local b0 = nil;

    "A banner test game for XTads.\b\b";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeText, BannerAlignTop,
                       0, BannerSizeAbsolute,
                       0);
    "b1 (child of b0) is a horizontal text banner above b0. Initial size is abs 0. ";
    "\bPress a key to continue...\n";
    inputKey();
    
    //---
    
    bannerSay(b1, 'line 1');
    "\bb1 now contains 1 line but has size 0, so should be invisible. ";
    inputKey();
    
    bannerSetSize(b1, 1, BannerSizeAbsolute, nil);
    "\bb1 should be resized to show 1 line. ";
    inputKey();
    
    //---
    
    bannerSay(b1, '\nline 2');
    "\bb1 now contains 2 lines but has size 1, so should just 1 line should be (fully) invisible. ";
    inputKey();
    
    bannerSetSize(b1, 2, BannerSizeAbsolute, nil);
    "\bb1 should be resized to show 2 lines. ";
    inputKey();
    
    //---
    
    bannerSay(b1, '\nline 3');
    "\bb1 now contains 3 lines but has size 2, so should just 2 lines should be (fully) invisible. ";
    inputKey();
    
    bannerSetSize(b1, 3, BannerSizeAbsolute, nil);
    "\bb1 should be resized to show 3 lines. ";
    inputKey();
    
    //---
    
    bannerSay(b1, '\nline 4\nline 5\nline 6');
    "\bb1 now contains 6 lines but has size 3, so should just 3 lines should be (fully) invisible. ";
    inputKey();
        
    bannerSetSize(b1, 4, BannerSizeAbsolute, nil);
    "\bb1 should be resized to show 4 lines. ";
    inputKey();
        
    bannerSetSize(b1, 5, BannerSizeAbsolute, nil);
    "\bb1 should be resized to show 5 lines. ";
    inputKey();
        
    bannerSetSize(b1, 6, BannerSizeAbsolute, nil);
    "\bb1 should be resized to show 6 lines. ";
    inputKey();

    //---

    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(win)
{
    local info = bannerGetInfo(win);

    "align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>";
}
