#ifndef NAKEDBARRIER_T
#define NAKEDBARRIER_T
  //
  // NakedBarrier.t, a list of travel barriers for the xactor library.
  //
  // version dated March 23, 2003.
  //
  // This code copyrighted (C) 2003 by Choices, and contributors.
  // This code is licensed under the IF Library License.
  //
  // Permission is hereby granted to use, copy, modify and/or 
  // distribute this package, provided that: 
  // * copyright terms are retained unchanged, whether the package 
  //   is modified or not.
  // * any distribution of this package, whether modified or not, 
  //   includes this notice.
  // * Aggregation of a binary version of this package with a 
  //   binary distribution is always permitted provided that 
  //   the use of this package is embedded; that is, when no 
  //   overt attempt is made to make this package's code 
  //   interfaces visible to the end user of the binary 
  //   distribution. Such use shall not be construed as a 
  //   distribution of this package.
  //
#include <adv3.h>
#include <en_us.h>
  //
nakedBarrier : TravelBarrier
{
   canTravelerPass(traveler)
   {
       if ( ! traveler.ofKind(Xactor) )
         return true;
       else {
         if ( ! traveler.clothed() )
           if ( traveler.clothesAreHere() )
             traveler.dressAndRun();
         if ( traveler.clothed() )
           return true; 
         else return nil;
       }
   }

   explainTravelBarrier(traveler) 
   {
     "{You/he} should get dressed before heading on. ";
   }

}


class ClothesBarrier : TravelBarrier
{
  blockFor = nil
  canTravelerPass(traveler)
  {
    if ( traveler != blockFor)  {
      local l = blockFor.defaultClothingList.length();
      if ( l < 1 )
         return true;
      foreach(local cur in blockFor.defaultClothingList) {
        if ( cur.uberLoc == traveler )
          return nil;
      }
      return true;
    }
    else return true;
  }
explainTravelBarrier(traveler) 
  {
    "\^<<blockFor.name>> wouldn\'t like it if <<traveler.itNom>> took 
     <<blockFor.itPossAdj>> clothes. ";
  }
}

foodBarrier : TravelBarrier
{
   canTravelerPass(traveler)
   {
       if ( traveler != food )
         return true;
       else return nil;
   }

   explainTravelBarrier(traveler) 
   {
     "\^<<food.name>> seems content to stay here. ";
   }
}

foodclothesBarrier : ClothesBarrier
  blockFor = food
;

#endif

