#charset "us-ascii"
/* 
 *  Copyright (c) 2005 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Services Pack
 *
 *  tsp_rextok.h
 *
 *  TSP Rextok Header File.
 */
#pragma once

#include "tads.h"
#include "t3.h"
#include "tok.h"
#include "vector.h"

/*
 *  The match was made at the start of the token value boundary
 *  of the first token element, and at the end of the token
 *  value boundary of the last token element in the match.
 */
enum TokenBoundaryMatch;

/*
 *  The match was NOT made at the start of the token value boundary
 *  of the first token element, but was made at the end of the token 
 *  value boundary of the last token element in the match.
 */
enum TokenBoundaryErrorStart;

/*
 *  The match was made at the start of the token value boundary
 *  of the first token element, but was NOT made at the end of 
 *  the token value boundary of the last token element in the match.
 */
enum TokenBoundaryErrorEnd;

/*
 *  The match was NOT made at the start of the token value boundary
 *  of the first token element, and was NOT made at the end of 
 *  the token value boundary of the last token element in the match.
 */
enum TokenBoundaryErrorBoth;