#charset "us-ascii"
/* 
 *  Copyright (c) 2005 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Services Pack
 *
 *  tsp_inheritance_order.h
 *
 *  TSP Inheritance Order Header File
 */
#pragma once
 
/* include the TADS and T3 system headers */
#include "tads.h"
#include "t3.h"

/*
 *  Returns the next object in the inheritance order for the
 *  object in which this statement has been defined. If there
 *  if no next object object then a runtime error is thrown.
 *
 *  Unlike the TADS 3 inherited or delegated keywork, calling 
 *  a method on inheritedObj does not bind to "self". 
 */
#define inheritedobj \
    getNextInherOrder(definingobj, true)
