#charset "us-ascii"

/* 
 *  Copyright (c) 2008 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Rulebooks library extension
 *
 *  rule.t
 */

#include "rulebooks.h"

/*--------------------------------------------------------------------
 *
 *  A Rule is an Association for which ALL associations
 *  must evaluate TRUE (or NIL depending on subclass) for 
 *  its exec() method to be invoked.
 *
 *  By default this class returns its exec() return VALUE.
 */
class Rule: Association
{
    evalCtl     = EvalCtlAllTrue
    execCtl     = ExecCtlRetVal 
}

/*--------------------------------------------------------------------
 *
 *  A RuleAllTrueRetVal is a Rule for which ALL 
 *  associations must evaluate TRUE for its exec() method 
 *  to be invoked.
 *
 *  By default this class returns its exec() return VALUE.
 */
class RuleAllTrueRetVal: Rule
;

/*--------------------------------------------------------------------
 *
 *  A RuleAllTrueRetNil is a Rule for which ALL 
 *  associations must evaluate TRUE for its exec() method 
 *  to be invoked.
 *
 *  By default this class returns NIL.
 */
class RuleAllTrueRetNil: Rule
{
    execCtl     = ExecCtlRetNil 
}

/*--------------------------------------------------------------------
 *
 *  A RuleAllTrueRetTrue is a Rule for which ALL 
 *  associations must evaluate TRUE for its exec() method 
 *  to be invoked.
 *
 *  By default this class returns true.
 */
class RuleAllTrueRetTrue: Rule
{
    execCtl     = ExecCtlRetTrue 
}

/*--------------------------------------------------------------------
 *
 *  A RuleAllNilRetVal is a Rule for which ALL 
 *  associations must evaluate NIL for its exec() method 
 *  to be invoked.
 *
 *  By default this class returns its exec() return VALUE.
 */
class RuleAllNilRetVal: Rule
{
    evalCtl     = EvalCtlAllNil
    execCtl     = ExecCtlRetVal 
}

/*--------------------------------------------------------------------
 *
 *  A RuleAllNilRetNil is a Rule for which ALL 
 *  associations must evaluate NIL for its exec() method 
 *  to be invoked.
 *
 *  By default this class returns NIL.
 */
class RuleAllNilRetNil: Rule
{
    evalCtl     = EvalCtlAllNil
    execCtl     = ExecCtlRetNil 
}

/*--------------------------------------------------------------------
 *
 *  A RuleAllNilRetTrue is a Rule for which ALL 
 *  associations must evaluate NIL for its exec() method 
 *  to be invoked.
 *
 *  By default this class returns TRUE.
 */
class RuleAllNilRetTrue: Rule
{
    evalCtl     = EvalCtlAllNil
    execCtl     = ExecCtlRetTrue 
}