#charset "us-ascii"
/* 
 *  Copyright (c) 2006 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Relation Library Extension
 *
 *  relation.t
 *
 *--------------------------------------------------------------------
 *  THE TADS 3 RELATION PREINITIALIZATION
 *--------------------------------------------------------------------
 */

#include "relation.h"

RelationPreinit: PreinitObject
{
    symTab  = nil
    strTab  = nil

    execute()
    {
        /*
         *  Create a symbols table
         */
        symTab  = t3GetGlobalSymbols();
        strTab  = new LookupTable();
        symTab.forEachAssoc(new function(k, v)
        {
            strTab[v] = k;
        });

        /*
         *  Initialize each SetObject class
         */
        for (local o = firstObj(SetObject, ObjInstances); o != nil; 
            o = nextObj(o, SetObject, ObjInstances))
            o.initInstance(strTab[o]);
        
        /*
         *  Initialize each RelationObject instance
         */
        for (local o = firstObj(RelationObject, ObjInstances); o != nil; 
            o = nextObj(o, RelationObject, ObjInstances))
            o.initInstance();
    }
}