#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlTableHeader.t
 */

#include "html.h"

/*--------------------------------------------------------------------*/
/*
 *  A base class for HTML Table Header Data
 */
class HtmlTableHeader: HtmlTableData
{
    tagRoot     = '<th'
    beginTag    = ''
    endTag      = '</th>'

    generate()
    {
        beginTag = generateTag();

        say(beginTag);

        for (local i = 1; i <= fontList.length(); ++i)
        {
            fontList[i].generate();

            if (i < fontList.length())
                "<br>";
        }

        say(endTag);
    }

    generateTag()
    {
        local str = '';

        str += tagRoot;
        str += getAlign();
        str += '>';

        return str;
    }
}