#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlAttr.t
 */

#include "html.h"

/*--------------------------------------------------------------------*/
/*
 *  A base class for HTML Attributes
 */
class HtmlAttributes: object
{
    align       = nil
    bgColor     = nil
    border      = nil
    cellPadding = nil
    cellSpacing = nil
    color       = 'black'
    colSpan     = nil
    face        = '\"Courier New,Courier New\"'
    height      = nil
    rowSpan     = nil
    size        = '\"+1\"'
    vAlign      = nil
    width       = nil

    getAlign()
    {
        local str = '';

        if (align == nil)
            return str;

        str += ' align=';

        switch(align)
        {
            case left:
                str += 'left';
                break;

            case center:
                str += 'center';
                break;

            case right:
                str += 'right';
                break;
        }
        return str;
    }

    setAlign(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                align = nil;
                break;

            case TypeEnum:
                if (val is in (left, right, center))
                    align = val;
                break;

            default:
                "Invalid value for align. ";
        }
    }

    getBgColor()
    {
        local str = '';

        if (bgColor == nil)
            return str;

        str += ' bgcolor=';
        str += bgColor;

        return str;
    }

    setBgColor(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                bgColor = nil;
                break;

            case TypeSString:
                bgColor = val;
                break;

            default:
                "Invalid value for bgcolor. ";
        }
    }

    getBorder()
    {
        local str = '';

        if (border == nil)
            return str;

        str = ' border';

        switch(dataType(border))
        {
            case TypeTrue:
                return str;

            case TypeInt:
                str += '=';
                str += toString(border);
                break;

            case TypeSString:
                str += '=';
                str += border;
                break;
        }
        return str;
    }

    setBorder(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                border = nil;
                break;

            case TypeTrue:
                border = true;
                break;

            case TypeInt:
                if (val >= 0)
                    border = val;
                break;

            case TypeSString:
                border = val;
                break;

            default:
                "Invalid value for border attribute.";
        }
    }

    getCellPadding()
    {
        local str = '';

        if (cellPadding == nil)
            return str;

        str += ' cellpadding=';
        str += toString(cellPadding);

        return str;
    }

    setCellPadding(val)
    {
        switch (dataType(val))
        {
            case TypeNil:
                cellPadding = nil;
                break;

            case TypeInt:
                if (val >= 0)
                    cellPadding = val;
                break;

            default:
                "Invalid value for cellpadding. ";
        }
    }

    getCellSpacing()
    {
        local str = '';

        if (cellSpacing == nil)
            return str;

        str += ' cellspacing=';
        str += toString(cellSpacing);

        return str;
    }

    setCellSpacing(val)
    {
        switch (dataType(val))
        {
            case TypeNil:
                cellSpacing = nil;
                break;

            case TypeInt:
                if (val >= 0)
                    cellSpacing = val;
                break;

            default:
                "Invalid value for cellspacing. ";
        }
    }

    getColor()
    {
        local str = '';

        if (color == nil)
            return str;

        str += ' color=';
        str += color;

        return str;
    }

    setColor(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                color = nil;
                break;

            case TypeSString: 
                color = val;
                break;

            default:
                "Invalid value for color. ";
        }
    }

    getColSpan()
    {
        local str = '';

        if (colSpan == nil)
            return str;

        str += ' colspan=';
        str += toString(colSpan);

        return str;
    }

    setColSpan(val)
    {
        switch(dataType(val))
        {
            case TypeNil: 
                colSpan = nil;
                break;

            case TypeInt:
                if (val >= 0)
                    colSpan = val;
                break;

            default:
                "Invalid value for colspan. ";
        }
    }

    getFace()
    {
        local str = '';

        if (face == nil)
            return str;

        str += ' face=';
        str += face;

        return str;
    }

    setFace(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                face = nil;
                break;

            case TypeSString: 
                face = val;
                break;

            default:
                "Invalid value for face. ";
        }
    }

    getHeight()
    {
        local str = '';

        if (height == nil)
            return str;

        str += ' height=';

        switch(dataType(height))
        {
            case TypeInt:
                str += toString(height);
                break;

            case TypeSString:
                str += height;
                break;
        }
        return str;
    }

    setHeight(val)
    {
        switch (dataType(val))
        {
            case TypeNil:
                height = nil;
                break;

            case TypeInt:
                if (val >= 0)
                    height = val;
                break;

            case TypeSString:
                height = val;
                break;

            default:
                "Invalid value for height. ";
        }
    }

    getRowSpan()
    {
        local str = '';

        if (rowSpan == nil)
            return str;

        str += ' rowspan=';
        str += toString(rowSpan);

        return str;
    }

    setRowSpan(val)
    {
        switch(dataType(val))
        {
            case TypeNil: 
                rowSpan = nil;
                break;

            case TypeInt:
                if (val >= 0)
                    rowSpan = val;
                break;

            default:
                "Invalid value for rowspan. ";
        }
    }

    getSize()
    {
        local str = '';

        if (size == nil)
            return str;

        str += ' size=';
        str += size;

        return str;
    }

    setSize(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                size = nil;
                break;

            case TypeSString: 
                size = val;
                break;

            default:
                "Invalid value for size. ";
        }
    }

    getVAlign()
    {
        local str = '';

        if (vAlign == nil)
            return str;

        str += ' valign=';

        switch(vAlign)
        {
            case top:
                str += 'top';
                break;

            case center:
                str += 'center';
                break;

            case middle:
                str += 'middle';
                break;

            case bottom:
                str += 'bottom';
                break;
        }
        return str;
    }

    setVAlign(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                vAlign = nil;
                break;

            case TypeEnum:
                if (val is in (top, center, middle, bottom))
                    vAlign = val;
                break;
        }
    }

    getWidth()
    {
        local str = '';

        if (width == nil)
            return str;

        str += ' width=';

        switch(dataType(width))
        {
            case TypeInt:
                str += toString(width);
                break;

            case TypeSString:
                str += width;
                break;
        }
        return str;
    }
  
    setWidth(val)
    {
        switch (dataType(val))
        {
            case TypeNil:
                width = nil;
                break;

            case TypeInt:
                if (val >= 0)
                    width = val;
                break;

            case TypeSString:
                width = val;
                break;

            default:
                "Invalid value for width. ";
        }
    }
}