#charset "us-ascii"

/*
 *   MegaTADS. Additions and modifications to the action.t file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#include <adv3.h>

#include "mega.h"

/* ---------------------------------------------------------------------- */
/*
 *   Modify the TIAction class so that, when one of the noun slots is empty
 *   but not the other, we resolve the non-empty noun phrase first. This
 *   corrects a minor problem whereby if you type E.G. PUT RED BALL when the
 *   red ball isn't present, the parser will first ask where to put the red
 *   ball and then say that you can't see any red ball.
 */

#ifdef MEGA_TIACTION_ON

modify TIAction
    /* resolve our noun phrases to objects (comments snipped for brevity) */
    replace resolveNouns(issuingActor, targetActor, results)
    {
        local first;
        local objMatch1, objMatch2;
        local objList1, objList2;
        local getResolver1, getResolver2;
        local objCur1;
        local remapProp;
        local reResolveFirst;

        results.noteNounSlots(2);

        dobjCur_ = nil;
        iobjCur_ = nil;

        reResolveFirst = nil;
        needAnaphoricBinding_ = nil;
        lastObjList_ = nil;

        /*
         *   Determine which object we want to resolve first.  If both
         *   phrases are empty, use the special all-empty ordering; if only
         *   one is empty, resolve the non-empty one; otherwise, use the
         *   standard ordering for this verb.
         */
        if (dobjMatch.isEmptyPhrase)
        {
            if (iobjMatch.isEmptyPhrase)
            {
                /* both phrases are empty - use the all-empty ordering */
                first = resolveFirstEmpty;
            }
            else
            {
                /* direct object is empty, resolve indirect first */
                first = IndirectObject;
            }
        }
        else
        {
            if (iobjMatch.isEmptyPhrase)
            {
                /* indirect object is empty, resolve direct first */
                first = DirectObject;
            }
            else
            {
                /*
                 *   we have two non-empty phrases, so use our standard
                 *   ordering
                 */
                first = resolveFirst;
            }
        }

        if (first == DirectObject)
        {
            objMatch1 = dobjMatch;
            objMatch2 = iobjMatch;
            objList1 = &dobjList_;
            objList2 = &iobjList_;
            getResolver1 = &getDobjResolver;
            getResolver2 = &getIobjResolver;
            objCur1 = &dobjCur_;
            remapProp = remapDobjProp;
        }
        else
        {
            objMatch1 = iobjMatch;
            objMatch2 = dobjMatch;
            objList1 = &iobjList_;
            objList2 = &dobjList_;
            getResolver1 = &getIobjResolver;
            getResolver2 = &getDobjResolver;
            objCur1 = &iobjCur_;
            remapProp = remapIobjProp;
        }

        initTentative(issuingActor, targetActor, first);

        self.(objList1) = objMatch1.resolveNouns(
            self.(getResolver1)(issuingActor, targetActor, true), results);

        reResolveFirst = needAnaphoricBinding_;

        lastObjList_ = self.(objList1);

        if (self.(objList1).length() == 1)
        {
            self.(objCur1) = self.(objList1)[1].obj_;

            if (results.allowActionRemapping)
            {
                withParserGlobals(issuingActor, targetActor, self,
                                  new function()
                {
                    local remapInfo;

                    if ((remapInfo = self.(objCur1).(remapProp)) != nil)
                    {
                        remapAction(true, first, remapInfo);
                    }
                });
            }
        }

        self.(objList2) = objMatch2.resolveNouns(
            self.(getResolver2)(issuingActor, targetActor, true), results);

        if (reResolveFirst)
        {
            lastObjList_ = self.(objList2);

            self.(objList1) = objMatch1.resolveNouns(
                self.(getResolver1)(issuingActor, targetActor, true),
                results);
        }
    }
;

#endif

