#charset "us-ascii"

/*
 *   TADS 3 Object Matching. Optional header file containing a couple of
 *   useful macros.
 *
 *   Copyright 2006, Krister Fundin (fundin@yahoo.com)
 */

#pragma once

/* ---------------------------------------------------------------------- */
/*
 *   A macro that sets up a loop through a list of objects returned by
 *   all().
 */
#define forall(var, args...) foreach (local var in all(args))

/* ---------------------------------------------------------------------- */
/*
 *   A macro that sets up a "definition", I.E. a custom Criterion sub-class
 *   that can be reused in several searches.
 */
#define definition(name, args...) \
    class name: NestedCriterion \
        args_ = [args]

