#charset "us-ascii"

/*
 *   Window Sample Game.
 *
 *   This is a simple sample game for the CSC extension.  It's not much to
 *   play, having no goal or story whatsoever, but it demonstrates the most
 *   common uses of the extension.  As it is intended merely as a 
 *   demonstration of the CSC extension, it is grossly underimplemented.
 */

/* Include library header files. */
#include <adv3.h>
#include <en_us.h>

/* Include csc class template */
#include <csc.h>

/*
 *   Locations. The test case is simply two rooms which the PC can travel
 *   between, joined by a window. Several objects are placed in the rooms
 *   to test description generation.
 */
startRoom: OutdoorRoom 'Outside Cottage' 'outside the cottage'
    "You are standing outside to the south of a small white cottage.  
    There is a small window beside the cottage door. "
    north = northRoom
    roomRemoteDesc(actor)
    {
        if(getPOV() == webcam)
            "On the PDA screen, you see the lawn outside the cottage. ";
        else
            "Through the window you see the south lawn. ";
    }
    inRoomName(pov) { if(pov == southWindowSide) return 'through the window';
        else return 'on the lawn outside'; }
;
+ southWindowSide: OpenableWindow, OneWayDistanceConnector, Fixture
    'window' 'window'
    "It's a plain white-trimmed window beside the cottage door. "
;
+ Fixture 'big rock' 'big rock'
    "It's a big rock. "
    specialDesc = "There is a big rock here. "
    remoteSpecialDesc(pov)
    {
        "There is a big rock in the middle of the lawn. ";
    }
;
+ Fixture 'post' 'post'
    "A wooden post is stuck in the ground. "
    specialDesc = "There is a post stuck in the ground. "
    distantSpecialDesc = "There is a post stuck in the south lawn. "
;

/*
 *   Inside the cottage is dark, to demonstrate that the window transmits 
 *   light, but the PDA doesn't, because of the "shineThru" flag.
 */
northRoom: DarkRoom 'Inside Cottage' 'in the cottage'
    "You are inside the cottage. There is a window looking out onto the lawn,
    beside it is an open doorway leading south. "
    south = startRoom
    roomRemoteDesc(actor)
    {
        if(getPOV() == webcam)
            "On the PDA screen, you see the inside of the cottage. ";
        else
            "Through the window you see inside the cottage. ";
    }
    inRoomName(pov) { if(pov == northWindowSide) return 'through the window';
        else return 'in the cottage'; }
;
+ northWindowSide: OpenableWindow, OneWayDistanceConnector, Fixture
    ->southWindowSide 'window' 'window'
    "It's a plain white-trimmed window in the south wall. "
;
+ webcam: Thing 'webcam/cam' 'webcam'
    "It's a battery-powered wireless webcam. "
;
+ pda: Obstructor, OneWaySenseConnector, Thing 'pda' 'PDA'
    "It displays the feed from the webcam. "
    examineStatus()
    {
        inherited;
        webcam.lookAround(gActor, LookRoomDesc|LookListSpecials|LookListPortables);
    }

    /* Since we'll be obstructing the cam, link to it's location */
    connectionList { return [webcam.location]; }
    
    /*
     *   Attenuate sense transmission to avoid loops when interacting with
     *   other sense connectors.  This is one of several ways to solve the
     *   loop problem, it may not work in every situation.
     *
     *   Another possibility is to check canDetailsBeSensed and return
     *   opaque if that method returns false. There's no one-size-fits-all
     *   solution to CSC interaction glitches, you just have to analyze
     *   what's going wrong and figure out how to best compensate for the
     *   particular situations that arise.
     */
    transSensingThru(sense) { return transparencyAdd(attenuated, inherited(sense)); }
    connectorMaterial = glass
    
    /* We don't transmit light */
    shineThru = nil
    
    obstructObj(obj, sense)
    {
        /* We can't ever see the webcam on the PDA screen */
        return obj == webcam;
    }
;
+ Thing 'ball' 'ball'
;

/*
 *   Define the player character.  The name of this object is not
 *   important, but note that it has to match up with the name we use in
 *   the main() routine to initialize the game, below.
 *   
 *   Note that we aren't required to define any vocabulary or description
 *   for this object, because the class Actor, defined in the library,
 *   automatically provides the appropriate definitions for an Actor when
 *   the Actor is serving as the player character.  Note also that we
 *   don't have to do anything special in this object definition to make
 *   the Actor the player character; any Actor can serve as the player
 *   character, and we'll establish this one as the PC in main(), below.  
 */
me: Actor
    /* the initial location */
    location = startRoom
;


/*
 *   Our game credits and version information.  This object isn't required
 *   by the system, but our GameInfo initialization above needs this for
 *   some of its information.
 */
versionInfo: GameID
    name = 'CSC Sample'
    byline = 'by Michael Damian Dollahite'
    htmlByline = 'by <a href="mailto:ryukage@aol.com">
                  M.D.\ Dollahite</a>'
    version = '1.0'
    authorEmail = 'M.D.\ Dollahite <ryukage@aol.com>'
    desc = 'Sample game for CSC extension.'
    htmlDesc = 'Sample game for <i>CSC</i> extension.'

    showCredit()
    {
        /* show our credits */
        "Put credits for the game here. ";

        /* 
         *   The game credits are displayed first, but the library will
         *   display additional credits for library modules.  It's a good
         *   idea to show a blank line after the game credits to separate
         *   them visually from the (usually one-liner) library credits
         *   that follow.  
         */
        "\b";
    }
    showAbout()
    {
        "Put information for players here.  Many authors like to mention
        any unusual commands here, along with background information on
        the game (for example, the author might mention that the game
        was created as an entry for a particular competition). ";
    }
;

/*
 *   The "gameMain" object lets us set the initial player character and
 *   control the game's startup procedure.  Every game must define this
 *   object.  For convenience, we inherit from the library's GameMainDef
 *   class, which defines suitable defaults for most of this object's
 *   required methods and properties.  
 */
gameMain: GameMainDef
    /* the initial player character is 'me' */
    initialPlayerChar = me

    /* 
     *   Show our introductory message.  This is displayed just before the
     *   game starts.  Most games will want to show a prologue here,
     *   setting up the situation for the player, and show the title of the
     *   game.  
     */
    showIntro()
    {
        "Welcome to TADS 3!\b";
    }

    /* 
     *   Show the "goodbye" message.  This is displayed on our way out,
     *   after the user quits the game.  You don't have to display anything
     *   here, but many games display something here to acknowledge that
     *   the player is ending the session.  
     */
    showGoodbye()
    {
        "<.p>Thanks for playing!\b";
    }
;
