#charset "us-ascii"

/*
 *   Copyright (c) 1999, 2002 by Michael J. Roberts.  Permission is
 *   granted to anyone to copy and use this file for any purpose.  
 *   
 *   This is a starter TADS 3 source file.  This is a complete TADS game
 *   that you can compile and run.
 *   
 *   To compile this game in TADS Workbench, open the "Build" menu and
 *   select "Compile for Debugging."  To run the game, after compiling it,
 *   open the "Debug" menu and select "Go."
 *   
 *   This is the "advanced" starter game - it has only the minimum set of
 *   definitions needed for a working game.  If you would like some more
 *   examples, create a new game, and choose the "introductory" version
 *   when asked for the type of starter game to create.  
 */

/* 
 *   Include the main header for the standard TADS 3 adventure library.
 *   Note that this does NOT include the entire source code for the
 *   library; this merely includes some definitions for our use here.  The
 *   main library must be "linked" into the finished program by including
 *   the file "adv3.tl" in the list of modules specified when compiling.
 *   In TADS Workbench, simply include adv3.tl in the "Source Files"
 *   section of the project.
 *   
 *   Also include the US English definitions, since this game is written
 *   in English.  
 */
#include <adv3.h>
#include <en_us.h>
#include <SayQuery.h>

/*
 *   Our game credits and version information.  This object isn't required
 *   by the system, but our GameInfo initialization above needs this for
 *   some of its information.
 *   
 *   You'll have to customize some of the text below, as marked: the name
 *   of your game, your byline, and so on.  
 */
versionInfo: GameID
    name = 'SayTopic/QueryTopic Test Game'
    byline = 'by Eric Eve'
    htmlByline = 'by <a href="mailto:eric.eve@ukf.net">
                  ERIC EVE</a>'
    version = '1.1'
    authorEmail = 'ERIC EVE <eric.eve@ukf.net>'
    desc = 'A game to test the SayTopic extension.'
    htmlDesc = 'A game to test the SayTopic extension.'
    showingAbout = nil
    showAbout()
    {
       "This is a test game to try out the SayTopic extension.\b";
       showingAbout = true;
       gameMain.showIntro();
       showingAbout = nil;
       "This is partly an experiment to find out how usable this
        kind of interface is. One problem may be that players will
        become confused between SayTopic/QueryTopic syntax and 
        SpecialTopic syntax (in any case players can hardly be expected
        to know what class of TopicEntry they're dealing with). For some
        reason players often seem reluctant to use the form of wording
        provided by the topic inventory, leading to frustration with the
        interface: that could be a problem here.\b
        Some limited flexibility is allowed with player conversational
        input in this game; e.g. words like <q>the</q> can be ommitted,
        and SAY commands can use direct or indirect speech (e.g. SAY THAT YOU
        SAW FRED = SAY I SAW FRED or SAY <q>I SAW FRED</q>). To avoid
        frustration, though, you will need to stick reasonably close to
        the wording of the suggested topic, in particular typing enough
        to be sure that your query or statement is uniquely identifiable.\b
        Finally, note that some QueryTopics and SayTopics are also matchable
        as AskTopics and TellTopics (e.g. TELL BOB ABOUT LIGHTHOUSE is
        equivalent to TELL BOB THAT YOU WENT INTO THE LIGHTHOUSE or
        S YOU WENT IN LIGHTHOUSE).\b
        As an experiment, you can omit the ASK or A in questions starting
        with WHO, WHAT, WHY, WHEN, HOW etc. If you're feeling even bolder you
        can omit the SAY or S at the beginning of SAY commands, and this should
        work provide say mode is not set to strict. You can experiment with
        changing the say mode use the SAY MODE &lt;mode> command, where &lt;mode>
        can be STRICT, NORMAL or LAX; the default (which probably gives the
        best results) is NORMAL.";
    }
;

/*
 *   The "gameMain" object lets us set the initial player character and
 *   control the game's startup procedure.  Every game must define this
 *   object.  For convenience, we inherit from the library's GameMainDef
 *   class, which defines suitable defaults for most of this object's
 *   required methods and properties.  
 */
gameMain: GameMainDef
    /* the initial player character is 'me' */
    initialPlayerChar = me
    showIntro()
    {        
        "You're here to talk with Bob. The game ends when you leave 
         the store.\b
         You'll need to make frequent use of the TOPICS command, and keep
         fairly close to the wording of the topics suggested: in particular
         note that conversational commands should start with ASK, TELL or SAY;
         there are few SpecialTopics used here. ASK, TELL and SAY can be 
         abbreviated to A, T and S.\b
         Use HYPER ON|OFF and ENUM ON|OFF to experiment with hyperlinked and
         enumerated suggested topics.\b<<versionInfo.showingAbout ? '' :
         'Type <a href=\'ABOUT\'>ABOUT</a> for more information. '>>\b" ;
    }
    hyperlinkOrEnumerateConvNodes = true
;

/* 
 *   Starting location - we'll use this as the player character's initial
 *   location.  The name of the starting location isn't important to the
 *   library, but note that it has to match up with the initial location
 *   for the player character, defined in the "me" object below.
 *   
 *   Our definition defines two strings.  The first string, which must be
 *   in single quotes, is the "name" of the room; the name is displayed on
 *   the status line and each time the player enters the room.  The second
 *   string, which must be in double quotes, is the "description" of the
 *   room, which is a full description of the room.  This is displayed when
 *   the player types "look around," when the player first enters the room,
 *   and any time the player enters the room when playing in VERBOSE mode.
 *   
 *   The name "startRoom" isn't special - you can change this any other
 *   name you'd prefer.  The player character's starting location is simply
 *   the location where the "me" actor is initially located.  
 */
 
backroom: Room 'Back Room' 
  "The only thing of interest in this boring back room is the way into 
    the store back to the west. "
  west = startRoom 
;
 
startRoom: Room 'Bob\'s Grocery Store'
    "The store is full of goodies neatly stacked in shelves. The way
     out is to the south, and there's a boring back room to the east. "
     out asExit(south)
     south: FakeConnector {
        actionDobjTravelVia
        {
            "You leave the shop, turn right, and walk on down the street.
            Maybe you'll come back and talk with Bob again some other
            time. ";
            finishGameMsg(ftGameOver, [finishOptionUndo]);
        }
     }
     east = backroom
;

+ Decoration 'shelves/shelf' 'shelves'
  "They're full of goodies. "
  isPlural = true
;

+ Decoration 'neatly stacked goods/goodies/stock/cans/tins/tin/can' 'goodies'
  "All sorts of things you'd like to buy if you were here to shop. "
  notImportantMsg = 'You\'re here to talk with Bob, not mess around with
   his stock. '
  isPlural = true
;

+ Decoration 'counter' 'counter'
;

+ me: Actor
;


bob: Person 'old bob/man/fellow' 'Bob' @startRoom
  "He's a pleasant-enough looking old fellow. "
  isHim = true
  isProperName = true
;

+ bobTalking: InConversationState
  specialDesc = "Bob is standing by the counter. "
;

++ bobStanding: ConversationReadyState
  specialDesc = "Bob is busily stacking cans. "
  isInitState = true
;

+++ HelloTopic
  "<q>Hello, Bob,</q> you greet him.\b
   <q>Hi there!</q> he replies. "
;

+++ ByeTopic
  "<q>Cheerio,</q> you say.\b
   <q>Go carefully, now,</q> he replies."
;

+ QueryTopic, SuggestedQueryTopic 'how' 'he is$|are you$'
  "<q>How are you, Bob?</q> you ask.\b
   <q>Fine, just fine,</q> he assures you. "  
  name = 'how he is'
;

+ QueryTopic, SuggestedQueryTopic ['if', 'whether', 'do']
  '(you|he) (like|likes) working here$'
  "<q>Do you like working here?</q> you wonder.\b
   <q>Sure,</q> he nods, <q>I've been doing it long enough!</q>"
   name = 'if he likes working here'
;


+ SayTopic, SuggestedSayTopic 
 '(you\'ve|you have|i\'ve|i have) (been|visited) (to ){0,1}(the ){0,1}beach$'
  "<q>I've just been to the beach.</q> you say.\b
   <q>Then you'll have seen the lighthouse,</q> he sighs, <q>I hope you
   didn't go in!</q><.reveal lighthouse>"
  name = 'you\'ve been to the beach'    
;


 /*  We can use a keyword list instead of a regular expression
  *  to match a QueryTopic or AskTopic. Items in parentheses
  *  ['(this)', '(is)' etc.] may be included in the player input
  *  but will not match the Topic by themselves. The property keywordsReqd
  *  contains the number of non-weak keywords that must be present
  *  in the player's input for the topic to match. Unlike a SpecialTopic,
  *  by default these non-weak keywords must appear in the same order that
  *  they are listed here and may not be duplicated, though these
  *  restrictions can be relaxed. The weak keywords can always be repeated
  *  and can appear anywhere in the sequence.
  */
  
+ SayTopic, SuggestedSayTopic
  ['(this)', '(is)', '(your)', '(my)', 'first', 'visit', '(here)']
  "<q>This is my first visit here,</q> you tell him.\b
   <q>I can see you're a stranger,</q> he replies. "
  name = 'this is your first visit here'
;

+ QueryTopic, SuggestedQueryTopic 'how'
  ['long', '(has)', '(have)', '(you)', '(he)', '(he\'s)', '(been)',   
   'worked|working', '(here)']
  "<q>How long have you worked here?</q> you wonder.\b
   <q>Must be getting on for forty years,</q> he tells you. "
  name = 'how long he\'s worked here'
  keywordsReqd = 2
;

+ SayTellTopic, SuggestedSayTopic, StopEventList @tLighthouse
  '(i|you) (did go|went|enter) (into |in ){0,1}(the ){0,1}lighthouse$'
  [
   '<q>As a matter of fact, I did go in the lighthouse,</q> you admit.\b
    <q>You shouldn\'t have done that,</q> he shakes his head, <q>Not after
     the troubles!</q><.reveal troubles>',
     
   'You\'ve already told him that. '
  ]  
  name = 'you did go into the lighthouse'
  
  isConversational = (curScriptState == 1)
  isActive = gRevealed('lighthouse')
;

+ AskTopic, SuggestedAskTopic @tLighthouse
  "<q>What's so terrible about the lighthouse?</q> you wonder.\b
   <q>It was the troubles,</q> he replies darkly.<.reveal troubles>"
  name = 'the lighthouse'
  isActive = gRevealed('lighthouse')
;

+ AskTopic, SuggestedAskTopic @tAntenna
  "<q>What can you tell me about the antenna?</q> you ask.\b
   <q>What do you know about it?</q> he asks suspiciously.<.convnode antenna>"
  name = 'the antenna'
;

+ QueryTopic, SuggestedQueryTopic 'when'
  '(was ){0,1}(the ){0,1}lighthouse (was ){0,1}abandoned$'
  "<q>When was the lighthouse abandoned?</q> you enquire.\b
   <q>When the troubles came,</q> he shudders.<.reveal troubles>"  
  name = 'when the lighthouse was abandoned'
  isActive = gRevealed('lighthouse')
;

+ QueryTopic, SuggestedQueryTopic 'when' 
  '(did ){0,1}(these |the ){0,1}troubles (were|happened|started|came|start|come)$'
  "<q>When were these troubles?</q> you ask.\b
   <q>Oh, about seven years ago,</q> he replies. "
  
  name = 'when these troubles started'
  isActive = gRevealed('troubles')
;

  /*
   *  We can combine an AskTopic and a QueryTopic into an
   *  AskQueryTopic that should match either A TROUBLES
   *  or ASK HOW THE TROUBLES STARTED. As a side effect,
   *  it will probably also match ASK HOW TROUBLES
   */

+ AskQueryTopic, SuggestedQueryTopic, StopEventList 
  @tTroubles 'how'
  '(did ){0,1}(these |the ){0,1}troubles (happened|started|start)$'
  [
   '<q>How did the troubles start?</q> you ask.\b
    <q>That\'s a long story,</q> he warns you. ',
    
   '<q>I want to know how the troubles started, please tell
    me,</q> you insist.\b   
    <q>Well, they say it was the Tads Three that started
    them,</q> he says. <.reveal tads-3>'     
  ]
  name = 'how the troubles started'
  timesToSuggest = 2
  isActive = gRevealed('troubles')
;



+ QueryTopic, SuggestedQueryTopic 'how'
  ['long', '(did)', '(the)', 'troubles', 'last|lasted']
  "<q>How long did the troubles last?</q> you want to know.\b
   <q>About six months,</q> he tells you. "
  isActive = gRevealed('troubles')
  keywordsReqd = 3
  name = 'how long the troubles lasted'
;

+ SayTopic, SuggestedSayTopic
  '(i have|you have|i\'ve|you\'ve) never heard (about |of ){0,1}(any ){0,1}troubles'
  "<q>I haven't heard anything about any troubles,</q> you say.\b
   <q>No; folks round here don't like to talk about them,</q> he replies. "
  
  name = 'you\'ve never heard about any troubles'
  isActive = gRevealed('troubles')
;

 /*
  *  A QueryTopic can answer more than one type of question. The
  *  following answers both WHO WERE THE TADS 3 and WHAT WERE THE TADS THREE
  */
  
+ AskQueryTopic, SuggestedQueryTopic @tTads3 ['who', 'what']
  ['(are)', '(were)', '(the)', 'tads', '3', 'three']
  "<q>Who were the Tads Three?</q> you want to know.\b
   <q>Well, let me see, there was Alan, and Hugo, and -- I
    don't remember being informed of the name of the third,
    but we were all adrift in those days, so I may have
    just forgotten.</q> he tells you. <q>Or perhaps it was
    so long ago that they were only the Tads Two back then.</q>"
  
  keywordsReqd = 2
  name = 'who were the Tads Three'
  isActive = gRevealed('tads-3')
;

+ QueryTopic, SuggestedQueryTopic 'what'
  '(the ){0,1}tads (three|3) did$|did (the ){0,1}tads (three|3) do$'
  "<q>So what did the Tads Three do?</q> you want to know.\b
   <q>They took over the lighthouse, that's what,</q> he tells you.
   <.reveal tads-lighthouse>"
  
  name ='what the Tads Three did'
  isActive = gRevealed('tads-3')
;

+ QueryTopic, SuggestedQueryTopic 'what'
  ['happened', '(at)', '(the)', 'lighthouse']
  "<q>So what happened at the lighthouse?</q> you want to know.\b
   Bob looks round furtively, as if afraid he might be overheard,
   then shudders, <q>You're asking way too many questions for a 
   stranger,</q> he opines, <q>and there are some things best
   forgotten.</q>"
   
  name = 'what happened at the lighthouse'
  isActive = gRevealed('tads-lighthouse')
;




+ DefaultQueryTopic
  "You ask Bob <<gAction.qType>> <<gTopicText>>, but he simply
    scratches his head. "
;

+ DefaultSayTopic
  "You say <q><<gTopicText>>,</q> but Bob merely shakes his head. "
;

+ DefaultAnyTopic, ShuffledEventList
 [
   'Bob merely grunts and fiddles with a can. ',
   'Bob shakes his head and looks away. ',
   'Bob sighs and mutters something incomprehensible. ',
   'Bob pretends not to hear you. '
 ]
;

+ ConvNode 'antenna'
  limitSuggestions = true
;

++ SpecialTopic 'answer vaguely' ['answer', 'vaguely']
 "<q>Oh, just the odd remark I heard in town,</q> you reply vaguely.\b
  <q>I see,</q> Bob frowns, <q>well, you don't want to believe
   everything you hear.</q>"
;

++ SayTopic, SuggestedSayTopic ['(i)', '(you)', 'went', '(to)', 'see', '(it)']
  "<q>I went to see it,</q> you tell him.\b
   <q>Did you now?</q> he exclaims, <q>Well, you'll have seen what it's like
    then.</q> "
  name = 'you went to see it'
;



tLighthouse: Topic 'lighthouse';
tTroubles: Topic 'troubles';
tTads3: Topic '3 three tads';
tAntenna: Topic 'antenna';

DefineSystemAction(ToggleStyle)
  execSystemAction()
  {
     suggestionSayGroup.tellStyle = !suggestionSayGroup.tellStyle;
     "SuggestedSayTopics now shown in <<suggestionSayGroup.tellStyle ?
      'tell' : 'say'>> style. ";
  }
;

VerbRule(ToggleStyle)
  'toggle' 'style'
  : ToggleStyleAction
  verbPhrase = 'toggle/toggling style'
;

