/*
 * Decompiled with CFR 0.152.
 */
package maze;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import maze.mazeGenerator;
import maze.mazeTextFrame;

public class Maze
extends JFrame {
    private Toolkit toolkit;
    private JPanel panel;
    private mazeGenerator aMaze;
    private boolean mazeHasBeenGenerated = false;

    public Maze() {
        this.setSize(332, 155);
        this.setTitle("Maze Generator for TADS 3");
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.toolkit = this.getToolkit();
        Dimension size = this.toolkit.getScreenSize();
        this.setLocation(size.width / 2 - this.getWidth() / 2, size.height / 2 - this.getHeight() / 2);
        JMenuBar mazeMenuBar = new JMenuBar();
        JMenu mazeSave = new JMenu("Save");
        mazeSave.setMnemonic(65);
        mazeMenuBar.add(mazeSave);
        JMenuItem mazeSaveMaze = new JMenuItem("Save Maze");
        mazeSaveMaze.setMnemonic(83);
        mazeSaveMaze.setToolTipText("Save the generated maze to a file");
        mazeSaveMaze.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (Maze.this.mazeHasBeenGenerated) {
                    boolean mazeOutputFlag;
                    JFileChooser mazeFileChooser = new JFileChooser();
                    mazeFileChooser.setDialogTitle("Specify output file for generated maze");
                    do {
                        int response;
                        mazeOutputFlag = true;
                        int ret = mazeFileChooser.showSaveDialog(Maze.this.panel);
                        if (ret != 0) continue;
                        File mazeFile = mazeFileChooser.getSelectedFile();
                        if (mazeFile.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                            mazeOutputFlag = false;
                        }
                        if (!mazeOutputFlag) continue;
                        Maze.this.aMaze.outputMaze(mazeFile.getAbsolutePath());
                    } while (!mazeOutputFlag);
                } else {
                    Maze.this.notGeneratedError();
                }
            }
        });
        mazeSave.add(mazeSaveMaze);
        JMenu mazeDisplay = new JMenu("Display");
        mazeDisplay.setMnemonic(73);
        mazeMenuBar.add(mazeDisplay);
        JMenuItem mazeDisplayMaze = new JMenuItem("Display Maze");
        mazeDisplayMaze.setMnemonic(68);
        mazeDisplayMaze.setToolTipText("Show an image of the generated maze");
        mazeDisplayMaze.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (Maze.this.mazeHasBeenGenerated) {
                    mazeTextFrame mazeTF = new mazeTextFrame();
                    mazeTF.setVisible(true);
                    Maze.this.aMaze.displayMaze(mazeTF);
                } else {
                    Maze.this.notGeneratedError();
                }
            }
        });
        mazeDisplay.add(mazeDisplayMaze);
        this.setJMenuBar(mazeMenuBar);
        this.panel = new JPanel();
        this.getContentPane().add(this.panel);
        this.panel.setLayout(null);
        size = this.getSize();
        JLabel mazeHeightLabel = new JLabel("Maze Height (in cells)");
        mazeHeightLabel.setBounds(5, 10, 153, 14);
        this.panel.add(mazeHeightLabel);
        JLabel mazeWidthLabel = new JLabel("Maze Width (in cells)");
        mazeWidthLabel.setBounds(size.width / 2, 10, 153, 14);
        this.panel.add(mazeWidthLabel);
        final SpinnerNumberModel mazeHeightSpinnerModel = new SpinnerNumberModel(2, 2, 25, 1);
        JSpinner mazeHeightSpinner = new JSpinner(mazeHeightSpinnerModel);
        mazeHeightSpinner.setBounds(5, 30, 153, 25);
        mazeHeightSpinner.setToolTipText("Specify the vertical size of the maze to generate");
        this.panel.add(mazeHeightSpinner);
        final SpinnerNumberModel mazeWidthSpinnerModel = new SpinnerNumberModel(2, 2, 25, 1);
        JSpinner mazeWidthSpinner = new JSpinner(mazeWidthSpinnerModel);
        mazeWidthSpinner.setBounds(size.width / 2, 30, 153, 25);
        mazeWidthSpinner.setToolTipText("Specify the horizontal size of the maze to generate");
        this.panel.add(mazeWidthSpinner);
        JButton generateMazeButton = new JButton("Generate Maze");
        generateMazeButton.setMnemonic(71);
        generateMazeButton.setBounds(size.width / 2 - 75, 65, 150, 23);
        generateMazeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Integer temph = (Integer)mazeHeightSpinnerModel.getValue();
                Integer tempw = (Integer)mazeWidthSpinnerModel.getValue();
                Maze.this.aMaze = new mazeGenerator(temph, tempw);
                Maze.this.aMaze.buildMaze();
                Maze.this.mazeHasBeenGenerated = true;
            }
        });
        generateMazeButton.setToolTipText("Click button to create the maze");
        this.panel.add(generateMazeButton);
    }

    private void notGeneratedError() {
        JOptionPane.showMessageDialog(this.panel, "You must first generate a maze", "Warning", 2);
    }

    public static void main(String[] args) {
        Maze mazeDB = new Maze();
        mazeDB.setVisible(true);
    }
}

