/*  Copyright (C) 1987, 1988 by Michael J. Roberts.  All Rights Reserved. */

/*
 * OS dependent module for EPOC by Simon Quinn, 19/12/00
 * based on Unix module
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>

#include "os.h"
#include "voc.h"



#include <e32base.h>

#include <eikcfdlg.h>
#include <eikon.rsg>
#include <eikfutil.h>

#include "epoc_console.h"


CAdvConsoleClient *iConsole;	//EIK Console to interact with



/*
 * ^C pressed?
 */
static int  break_set = 0;

/*
 * Run-time voc context for save-on-punt
 */
extern voccxdef *main_voc_ctx;

//voccxdef   *saved_context;

/*
 * Running as compiler?  If so, we shouldn't do any term handling.
 */
int unix_tc = 0;

/*
 *   Stuff for the timing functions. Added by SRG 
 */
static long timeZero = 0;

#define INIT 0
#define RESTORE 1

static int  COLS, LINES;

/*
 * "Colors"
 * Note that cNORMAL *must* be zero for other parts of TADS to work.
 */
#define cNORMAL     (1 << 0)
#define cSTANDOUT   (1 << 1)
#define cREVERSE    (1 << 2)
#define cBOLD       (1 << 3)
#define cBLINK      (1 << 4)
#define cUNDERSCORE (1 << 5)

static void set_win_size(void);
static void t_outs(char *s);
static void t_loc(int y, int x, int force);
static void t_color(char c);

//extern "C" void os0main(int oargc, char *oargv[], void (*mainfn), char *before, char *config);
extern "C" void os_score( int cur, int turncount );


void ossclr(int top, int left, int bottom, int right, int blank_color);

void os_waitc(void);


/*
 * When window size changes, we have to notify the rest of the system
 * so text will be formatted properly.
 */
static void
set_win_size(void)
{
	/*
	 * Ensure output formatter happiness.
	 */
	if (LINES < 5)
	    LINES = 5;
	if (COLS < 20)
	    COLS = 20;

	/*
	 * Init screen size globals used by the system.
	 * We always use one less than the full width and height to avoid
	 * nasty auto-scrolling problems.  DO NOT CHANGE THIS.  It may
	 * work on *your* terminal but not on some of the others.
	 * Better safe than sorry.
	 */
	max_line = LINES - 2;
	max_column = COLS - 2;

	G_os_pagelength = max_line - text_line - 1;
	G_os_linewidth = max_column + 1;

	score_column = max_column - 10;
}


/*
 * Write a string to the screen (without padding)
 */
static void
t_outs(char *s)
{
	TBuf<256> tempstr;
	TPtrC8 thePtr((TUint8*)(s),strlen(s));

	tempstr.Copy(thePtr);
	iConsole->Write(tempstr);
/*
	const TChar KSeparator = ' ';
	const TInt	len = 62;
	TBuf<len+2>	tmp;
	TLex16		lex(tempstr);
				
	lex.Mark();
	while (lex.Peek())
	{
		if (lex.Get() == KSeparator)
		{
			TPtrC16	ptr(lex.MarkedToken());
			if (tmp.Length() + ptr.Length() >= len)
			{
				tmp.Append(_L("\r\n"));
				iConsole->Write(tmp);
				tmp.Zero();							
			}
			
			tmp.Append(ptr);
			lex.Mark();
		}
	}

	TBool	moreLines = EFalse;
	TPtrC16	ptr(lex.MarkedToken());
	if (ptr.Length())
	{
		if (tmp.Length() + ptr.Length() < len)
		{
			tmp.Append(ptr);
		}
		else
		{
			moreLines = ETrue;
		}
	}

	iConsole->Write(tmp);
	if (moreLines)
	{
		iConsole->Write(ptr);
	}
	*/
}


int
//os_init( int *argc, char *argv[], const char *prompt, char *buf, int bufsiz )
os_init()
{
	
	COLS = 64; //iConsole->ScreenSize().iWidth;
	LINES = iConsole->ScreenSize().iHeight;

	LINES++; 
	COLS++; 
	set_win_size(); 
	LINES--; 
	COLS--;

	//Set up character printing attributes we'll use
	sdesc_color = cREVERSE;
	ldesc_color = cREVERSE;
	text_color  = cNORMAL;
	text_bold_color = cBOLD;
	text_normal_color = cNORMAL;

//	ossclr(0, 0, LINES - 1, COLS - 1, cNORMAL);

	status_mode = 0;

	os_score(0, 0);

	return 0;
}

void
os_term(int rc)
{
	iConsole->Write(_L("[strike a key to exit]"));
	os_waitc();

	exit(0); /* always return zero since mainline doesn't set it right */
}

void os_uninit()
{
}

/*
 *   Check for control-break.  Returns status of break flag, and clears
 *   the flag. 
 */
int
os_break(void)
{
	int ret;
	
	ret = break_set;
	break_set = 0;
	return ret;
}

int
os_getc(void)
{
	int        c;
	static char cbuf;
	static int  buffered = 0;

	/*
	 * If we've got a special key pending, return its code.
	 */
	if (buffered) {
	    buffered = 0;
	    return cbuf;
	}

	/*
	 * Get the next character from standard input.
	 * (Non-blocking)
	 */
	c = iConsole->Getch();
#ifdef _DO_DEBUG_
	iConsole->Log(_L8("os_getc called\r\n"));
	TBuf8<128> buf;
	buf.Format(_L8("Code = %d\r\n"),c);
	iConsole->Log(buf);
#endif
	/*
	 * Map NL to CR.
	 */
	if (c == 10)
	    c = 13;

#define ctrl(c) (c - 'A' + 1)
	/*
	 * Handle special keys.
	 * os_gets expects certain keys to be certain codes.
	 */
	if (c == EKeyBackspace) /* erase key or DEL -> backspace */
	    c = ctrl('H');

	/*
	 * Key equivalences for special keys.
	 * Some terminals can send function keys, etc. but we
	 * don't support that right now.
	 */
	switch (c) {
	    case 0:
	        c = 1;
	        break;

	    case 10:
	        c = 13;
	        break;
	        
		case EKeyUpArrow:
	        c = 0;
	        cbuf = CMD_UP;
	        break;

	    case EKeyDownArrow:
	        c = 0;
	        cbuf = CMD_DOWN;
	        break;

	    case EKeyRightArrow:
	        c = 0;
	        cbuf = CMD_RIGHT;
	        break;

	    case EKeyLeftArrow:
	        c = 0;
	        cbuf = CMD_LEFT;
	        break;

	    case EKeyEnd:
	        c = 0;
	        cbuf = CMD_END;
	        break;

	    case EKeyHome:
	        c = 0;
	        cbuf = CMD_HOME;
	        break;

	    case EKeyPageUp:
	        c = 0;
	        cbuf = CMD_PGUP;
	        break;
	        
	    case EKeyPageDown:
	        c = 0;
	        cbuf = CMD_PGDN;
	        break;

//		case EKeySliderDown:		//Zoom Out
//		case EKeySliderUp:		//Zoom In
//		{
//			c=1;
//			ossclr(0, 0, LINES - 1, COLS - 1, cNORMAL);
//			iConsole->SetPos(0, 1);
//			iConsole->ScreenZoom();
//			os_init();
//			ossclr(0, 0, LINES - 1, COLS - 1, cNORMAL);
//			iConsole->SetPos(0, 1);
//			break;
//		}



		/*case EKeyMenu:
			c = 0;
			cbuf = CMD_SCR;
			break;	         */
	}

	/*
	 * Special key?  Then note that we should return it on next call.
	 */
	if (c == 0)
	    buffered = 1;
	else
	{
    	TBuf8<32>	out;
	    TBuf16<32>	in;
	
		in.Format(_L16("%c"),c);

		iConsole->ConvertFrom1251(in, out);
		c = out[0];
	}

	return c;

}

int
os_getc_raw(void)
{
#ifdef _DO_DEBUG_
   	iConsole->Log(_L8("os_getc_raw called\r\n"));
#endif

	int c;

	/*
	 *   Get the next character from standard input.  (Non-blocking) 
	 */
	c = iConsole->Getch();

	/*
	 *   Handle special keys.  os_gets expects certain keys to be certain
	 *   codes.  
	 */
	if (c == 0x7F)         /* erase key or DEL -> backspace */
	    c = ctrl('H');

	/* handle some more special key translations */
	switch (c) {
	case 0:
	    c = 1;
	    break;

	case 10:
	    /* map newline to return */
	    c = 13;
	    break;
	}

	/* return the key */
	return c;
#undef ctrl
}

void
os_waitc(void)
{
	int    c;
 	c = iConsole->Getch();
}

/*
 * Move the cursor.  Note that this has nothing to do with the virtual cursor
 * that TADS tells us to move around -- that's updated by ossloc.
 *
 * The force parameter tells us to not use the current value of cursorX
 * and cursorY and to reposition the cursor absolutely.
 *
 */
void
t_loc(int y, int x, int force)
{
	iConsole->SetPos(x,y);
}

/*
 * Change subsequent text to new color. Well EPOC Attribute SQ
 */
static void
t_color(char c)
{
	int attr=0;

	if (c & cSTANDOUT)
		attr |= ATT_BOLD;
	if (c & cREVERSE)
		attr |= ATT_INVERSE;
	if (c & cBOLD)
		attr |= ATT_BOLD;
	if (c & cUNDERSCORE)
		attr |= ATT_UNDERLINE;

	iConsole->SetAttr(attr);
}

/*
 * Scroll region down a line.
 * This is equivalent to inserting a line at the top of the region.
 */
void
ossscu(int top, int left, int bottom, int right, int blank_color)
{
//sqdebug not currently working due to no direction passed in EPOC wrapper

	/* with scrolling commands, do so; otherwise, refresh by redrawing
	 * every affected line.
	 */
	if (left == 0 && right >= max_column) {
		iConsole->ScrollChars(TRect(left, top, right, bottom + 1), TPoint(0,1));
	}
}

/*
 * Scroll region up a line
 * This is equivalent to deleting a line at the top of the region and pulling
 * everything below it up.
 */
void
ossscr(int top, int left, int bottom, int right, int blank_color)
{
	/*
	 * If we can duplicate the effect of this scroll on the screen
	 * with a scrolling command, do so; otherwise, refresh by redrawing
	 * every affected line.
	 */
	if (left == 0 && right >= max_column) {
		iConsole->ScrollChars(TRect(left, top, right, bottom + 1), TPoint(0,-1));
	}
}

/*
 * Clear region (fill with spaces)
 */
void
ossclr(int top, int left, int bottom, int right, int blank_color)
{
	iConsole->ClearChars(TRect(left, top, right, bottom), 0);
}

/*
 * Locate (input) cursor at given row and column.
 * Nore that this is never used to determine where things are drawn.
 * It's only used for aesthetics; i.e., showing the user where input
 * will be taken from next.
 */ 
void
ossloc(int row, int col)
{
	t_loc(row, col, 0);
}

/*
 * Display msg with color at coordinates (y, x).
 * The color must be in the range 0 <= color <= 16, and specifies both
 * foreground and background colors.
 */
void
ossdsp(int y, int x, int color, char *msg)
{

	if (y >= LINES || x >= COLS)
	    return;

	/*
	 * Update the screen
	 */
	t_loc(y, x, 0);

	t_color(color);
	t_outs(msg);
}


int
os_paramfile(char *buf)
{
	return 0;
}

/*
 *   os_exeseek  - opens the given .EXE file and seeks to the end of the
 *   executable part of it, on the presumption that a datafile is to be
 *   found there.
 */
osfildef *os_exeseek(const char *exefile, const char *typ )
{
	return((osfildef *)0);
}

/*
 *   os_exfld  - load in an external function from an open file, given
 *   the size of the function (in bytes).  Returns a pointer to the newly
 *   allocated memory block containing the function in memory.
 */
int (*os_exfld( osfildef *fp, unsigned len ))(void *)
{
	return  (int (*)(void *)) 0;
}

/*
 *   Load an external function from a file.  This routine assumes that
 *   the file has the same name as the resource.  
 */
int (*os_exfil(const char *name ))(void *)
{
	return (int (*)(void *)) 0;
}

/*
 *   call an external function, passing it an argument (a string pointer),
 *   and passing back the string pointer returned by the external function
 */
int os_excall(int (*extfn)(void *), void *arg)
{
	return 0;
}

/*
 *   Get the temporary file path.  This should fill in the buffer with a
 *   path prefix (suitable for strcat'ing a filename onto) for a good
 *   directory for a temporary file, such as the swap file.  
 */
void
os_get_tmp_path(char *s)
{
  int i;

  strcpy(s, tmpnam(NULL));
  for (i = strlen(s) - 1; i >= 0; i--)
	if (s[i] == '/')
	  break;

  s[i + 1] = 0;
}

/* os_defext(fn, ext) should append the default extension ext to the filename
 *  in fn.  It is assumed that the buffer at fn is big enough to hold the added
 *  characters in the extension.  The result should be null-terminated.  When
 *  an extension is already present in the filename at fn, no action should be
 *  taken.  On systems without an analogue of extensions, this routine should
 *  do nothing.
 *
 * For Unix, we extend this to also prepend the default saved game or game
 * file path name.
 * 
 *    - The TADSSAVE environment variable holds the name of the save file
 *  directory
 *    - The TADSGAME envirnoment variable holds the name of the game file
 *  directory
 *
 * We only prepend  if there are no slashes in the filename already.
 * We don't prepand paths when running as the compiler, because we don't want
 * the output files to go in weird places.
 */
void os_defext( char *fn, const char *ext )
{
	char *p, *n, tmp[1024];
	char *defpath;

	/*
	 * Prepend default path
	 */
//   if (!memicmp(ext, "sav", strlen(ext)))
//	defpath = getenv("TADSSAVE");
//   else if (!memicmp(ext, "gam", strlen(ext)))
//	defpath = getenv("TADSGAME");
//   else
	defpath = NULL;

   if (!unix_tc && defpath) {
	/*
	 * Look for slashes.  If there are any, don't mess with name.
	 */
	n = fn;
	while (*n) {
	    if (*n == '/')
	        break;
	    n++;
	}
	if (!*n) {
	    strcpy(tmp, defpath);
	    if (defpath[strlen(defpath)] != '/')
	        strcat(tmp, "/");
	    strcat(tmp, fn);
	    strcpy(fn, tmp);
	}  
   }

	p = fn+strlen(fn);
	while ( p>fn )
	  {
	p--;
	if ( *p=='.' ) return;      /* already has an extension */
	if ( *p=='/' || *p=='\\' || *p==':'
	   ) break;    /* found a path */
	  }
	strcat( fn, "." );          /* add a dot */
	strcat( fn, ext );          /* add the extension */
  }

/* os_remext(fn) removes the extension from fn, if present.  The buffer at
 *  fn should be modified in place.  If no extension is present, no action
 *  should be taken.  For systems without an analogue of extensions, this
 *  routine should do nothing.
 */
void os_remext( char *fn )
{
	char *p = fn+strlen(fn);
	while ( p>fn )
	  {
	p--;
	if ( *p=='.' )
	  {
	    *p = '\0';
	    return;
	  }
	if ( *p=='/' || *p=='\\' || *p==':'
	    ) return;
	  }
}

/*
 * Add an extension, even if the filename currently has one 
 */
void os_addext(char *fn, const char *ext)
{
	strcat(fn, ".");
	strcat(fn, ext);
}

/*
 * Returns a pointer to the root portion of the filename. Added by SRG.
 */
char *os_get_root_name(char *buf)
{
	char *p = buf;

	p += strlen(buf) - 1;
	while (*p != '/' && p > buf)
	p--;
	if (p != buf) p++;

	return p;
}
/*
 * This is an extremely unsophisticated version of os_xlat_html4, which translates
 * everything it can into its near-ASCII equivalent. Added by SRG, after code from
 * OSDOS.C.
 */
void os_xlat_html4(unsigned int html4_char, char *result, size_t result_len)
{
    /* default character to use for unknown charaters */
#define INV_CHAR " "
	
    /* 
	*   Translation table - provides mappings for characters the ISO
	*   Latin-1 subset of the HTML 4 character map (values 128-255).
	*   
	*   Characters marked "(approx)" are approximations where the actual
	*   desired character is not available, but a reasonable approximation
	*   is used.  Characters marked "(approx unaccented)" are accented
	*   characters that are not available; these use the unaccented equivalent
	*   as an approximation, since this will presumably convey more meaning
	*   than a blank.
	*   
	*   Characters marked "(n/a)" have no equivalent (even approximating),
	*   and are mapped to spaces.
	*   
	*   Characters marked "(not used)" are not used by HTML '&' markups.  
	*/
    static const char *xlat_tbl[] =
    {
    INV_CHAR,                     /* 128 (not used) */
    INV_CHAR,                     /* 129 (not used) */
    "'",                        /* 130 - sbquo (approx) */
    INV_CHAR,                     /* 131 (not used) */
    "\"",                       /* 132 - bdquo (approx) */
    INV_CHAR,                     /* 133 (not used) */
    INV_CHAR,                     /* 134 - dagger (n/a) */
    INV_CHAR,                     /* 135 - Dagger (n/a) */
    INV_CHAR,                     /* 136 (not used) */
    INV_CHAR,                     /* 137 - permil (n/a) */
    INV_CHAR,                     /* 138 (not used) */
    "<",                       /* 139 - lsaquo (approx) */
    INV_CHAR,                      /* 140 - OElig (n/a) */
    INV_CHAR,                     /* 141 (not used) */
    INV_CHAR,                     /* 142 (not used) */
    INV_CHAR,                     /* 143 (not used) */
    INV_CHAR,                     /* 144 (not used) */
    "'",                        /* 145 - lsquo (approx) */
    "'",                        /* 146 - rsquo (approx) */
    "\"",                       /* 147 - ldquo (approx) */
    "\"",                       /* 148 - rdquo (approx) */
    INV_CHAR,                     /* 149 (not used) */
    "-",                            /* 150 - endash */
    "--",                           /* 151 - emdash */
    INV_CHAR,                     /* 152 (not used) */
    "(tm)",                     /* 153 - trade (approx) */
    INV_CHAR,                     /* 154 (not used) */
    ">",                       /* 155 - rsaquo (approx) */
    INV_CHAR,                      /* 156 - oelig (n/a) */
    INV_CHAR,                     /* 157 (not used) */
    INV_CHAR,                     /* 158 (not used) */
    "Y",                  /* 159 - Yuml (approx unaccented) */
    INV_CHAR,                     /* 160 (not used) */
    "!",                             /* 161 - iexcl */
    INV_CHAR,                   /* 162 - cent (n/a) */
    INV_CHAR,                      /* 163 - pound (n/a) */
    INV_CHAR,                     /* 164 - curren (n/a) */
    INV_CHAR,                    /* 165 - yen (n/a) */
    "|",                          /* 166 - brvbar (n/a) */
    INV_CHAR,                   /* 167 - sect (n/a) */
    INV_CHAR,                    /* 168 - uml (n/a) */
    "(c)",                       /* 169 - copy (approx) */
    INV_CHAR,                   /* 170 - ordf (n/a) */
    INV_CHAR,                      /* 171 - laquo (n/a) */
    INV_CHAR,                    /* 172 - not (n/a) */
    " ",                         /* 173 - shy (n/a) */
    "(R)",                        /* 174 - reg (approx) */
    INV_CHAR,                   /* 175 - macr (n/a) */
    INV_CHAR,                    /* 176 - deg (n/a) */
    INV_CHAR,                     /* 177 - plusmn (n/a) */
    INV_CHAR,                   /* 178 - sup2 (n/a) */
    INV_CHAR,                   /* 179 - sup3 (n/a) */
    "'",                        /* 180 - acute (approx) */
    INV_CHAR,                      /* 181 - micro (n/a) */
    INV_CHAR,                   /* 182 - para (n/a) */
    INV_CHAR,                     /* 183 - middot (n/a) */
    ",",                        /* 184 - cedil (approx) */
    INV_CHAR,                   /* 185 - sup1 (n/a) */
    INV_CHAR,                   /* 186 - ordm (n/a) */
    INV_CHAR,                      /* 187 - raquo (n/a) */
    "1/4",                     /* 188 - frac14 (approx) */
    "1/2",                     /* 189 - frac12 (approx) */
    "3/4",                     /* 190 - frac34 (approx) */
    "?",                       /* 191 - iquest (approx) */
    "A",                /* 192 - Agrave (approx unaccented) */
    "A",                /* 193 - Aacute (approx unaccented) */
    "A",                 /* 194 - Acirc (approx unaccented) */
    "A",                /* 195 - Atilde (approx unaccented) */
    "A",                  /* 196 - Auml (approx unaccented) */
    "A",                 /* 197 - Aring (approx unaccented) */
    "AE",                /* 198 - AElig (approx unaccented) */
    "C",                /* 199 - Ccedil (approx unaccented) */
    "E",                /* 200 - Egrave (approx unaccented) */
    "E",                /* 201 - Eacute (approx unaccented) */
    "E",                 /* 202 - Ecirc (approx unaccented) */
    "E",                  /* 203 - Euml (approx unaccented) */
    "I",                /* 204 - Igrave (approx unaccented) */
    "I",                /* 205 - Iacute (approx unaccented) */
    "I",                 /* 206 - Icirc (approx unaccented) */
    "I",                  /* 207 - Iuml (approx unaccented) */
    INV_CHAR,                    /* 208 - ETH (n/a) */
    "N",                /* 209 - Ntilde (approx unaccented) */
    "O",                /* 210 - Ograve (approx unaccented) */
    "O",                /* 211 - Oacute (approx unaccented) */
    "O",                 /* 212 - Ocirc (approx unaccented) */
    "O",                /* 213 - Otilde (approx unaccented) */
    "O",                  /* 214 - Ouml (approx unaccented) */
    "x",                        /* 215 - times (approx) */
    "O",                /* 216 - Oslash (approx unaccented) */
    "U",                /* 217 - Ugrave (approx unaccented) */
    "U",                /* 218 - Uacute (approx unaccented) */
    "U",                 /* 219 - Ucirc (approx unaccented) */
    "U",                  /* 220 - Uuml (approx unaccented) */
    "Y",                /* 221 - Yacute (approx unaccented) */
    INV_CHAR,                      /* 222 - THORN (n/a) */
    INV_CHAR,                      /* 223 - szlig (n/a) */
    "a",                /* 224 - agrave (approx unaccented) */
    "a",                /* 225 - aacute (approx unaccented) */
    "a",                 /* 226 - acirc (approx unaccented) */
    "a",                /* 227 - atilde (approx unaccented) */
    "a",                  /* 228 - auml (approx unaccented) */
    "a",                 /* 229 - aring (approx unaccented) */
    "ae",                       /* 230 - aelig (approx) */
    "c",                       /* 231 - ccedil (approx) */
    "e",                /* 232 - egrave (approx unaccented) */
    "e",                /* 233 - eacute (approx unaccented) */
    "e",                 /* 234 - ecirc (approx unaccented) */
    "e",                  /* 235 - euml (approx unaccented) */
    "i",                /* 236 - igrave (approx unaccented) */
    "i",                /* 237 - iacute (approx unaccented) */
    "i",                 /* 238 - icirc (approx unaccented) */
    "i",                  /* 239 - iuml (approx unaccented) */
    INV_CHAR,                    /* 240 - eth (n/a) */
    "n",                /* 241 - ntilde (approx unaccented) */
    "o",                /* 242 - ograve (approx unaccented) */
    "o",                /* 243 - oacute (approx unaccented) */
    "o",                 /* 244 - ocirc (approx unaccented) */
    "o",                /* 245 - otilde (approx unaccented) */
    "o",                  /* 246 - ouml (approx unaccented) */
    "/"                    /* 247 - divide (approx) */
    "o",                /* 248 - oslash (approx unaccented) */
    "u",                /* 249 - ugrave (approx unaccented) */
    "u",                /* 250 - uacute (approx unaccented) */
    "u",                 /* 251 - ucirc (approx unaccented) */
    "u",                  /* 252 - uuml (approx unaccented) */
    "y",                /* 253 - yacute (approx unaccented) */
    INV_CHAR,                      /* 254 - thorn (n/a) */
    "y"               /* 255 - yuml (approx unaccented) */
    };

    /*
     *   Map certain extended characters into our 128-255 range.  If we
     *   don't recognize the character, return the default invalid
     *   charater value.  
     */
    if (html4_char > 255)
    {
    switch(html4_char)
    {
    case 338: html4_char = 140; break;
    case 339: html4_char = 156; break;
    case 376: html4_char = 159; break;
    case 352: html4_char = 154; break;
    case 353: html4_char = 138; break;
    case 8211: html4_char = 150; break;
    case 8212: html4_char = 151; break;
    case 8216: html4_char = 145; break;
    case 8217: html4_char = 146; break;
    case 8218: html4_char = 130; break;
    case 8220: html4_char = 147; break;
    case 8221: html4_char = 148; break;
    case 8222: html4_char = 132; break;
    case 8224: html4_char = 134; break;
    case 8225: html4_char = 135; break;
    case 8240: html4_char = 137; break;
    case 8249: html4_char = 139; break;
    case 8250: html4_char = 155; break;
    case 8482: html4_char = 153; break;

    default:
        /* unmappable character - return space */
        result[0] = (unsigned char)' ';
        result[1] = 0;
        return;
    }
    }
    
    /* 
     *   if the character is in the regular ASCII zone, return it
     *   untranslated 
     */
    if (html4_char < 128)
    {
    result[0] = (unsigned char)html4_char;
    result[1] = '\0';
    return;
    }

    /* look up the character in our table and return the translation */
    strcpy(result, xlat_tbl[html4_char - 128]);
}

/*
 * Simple versions of os_advise_load_charmap and os_gen_charmap_filename. At
 * some point I'll get around to making these do something real. Added by SRG.
 */
void os_advise_load_charmap(char *id, char *ldesc, char *sysinfo)
{
}

void os_gen_charmap_filename(char *filename, char *internal_id, char *argv0)
{
	filename[0] = '\0';
}

/* 
 *   A very simple "millisecond timer." Because of the relatively-low
 *   precision of a long and because we really are only precise to a
 *   second, we store a zero-offset to begin with. Added by SRG.  
 */
long os_get_sys_clock_ms(void)
{
	if (timeZero == 0)
	timeZero = time(0);
	return ((time(0) - timeZero) * 1000);
}

/*
 *   Sleep for a given # of ms. Added by SRG.  
 */
void os_sleep_ms(long delay_in_milliseconds)
{
	User::After(delay_in_milliseconds * 1000);
}

/*
 * An empty implementation of os_set_title. Added by SRG.
 */
void os_set_title(const char *title)
{
}

/*
 *   Get an input event.  The event types are shown above.  If use_timeout
 *   is false, this routine should simply wait until one of the events it
 *   recognizes occurs, then return the appropriate information on the
 *   event.  If use_timeout is true, this routine should return
 *   OS_EVT_TIMEOUT after the given number of milliseconds elapses if no
 *   event occurs first.
 *   
 *   This function is not obligated to obey the timeout.  If a timeout is
 *   specified and it is not possible to obey the timeout, the function
 *   should simply return OS_EVT_NOTIMEOUT.  The trivial implementation
 *   thus checks for a timeout, returns an error if specified, and
 *   otherwise simply waits for the user to press a key.  
 */
int os_get_event(unsigned long /*timeout_in_milliseconds*/, int use_timeout, os_event_info_t *info)
{
#ifdef _DO_DEBUG_
   	iConsole->Log(_L8("os_get_event called\r\n"));
#endif

    /* if there's a timeout, return an error indicating we don't allow it */
    if (use_timeout)
        return OS_EVT_NOTIMEOUT;

    /* get a key the normal way */
    info->key[0] = os_getc();

    /* if it's an extended key, get the other key */
    if (info->key[0] == 0)
        info->key[1] = os_getc();

    /* return the keyboard event */
    return OS_EVT_KEY;
}


/*
 * Provide memicmp since it's not a standard libc routine.
 */
memicmp(char *s1, char *s2, int len)
{
	char    *x1, *x2;   
	int result;
	int i;

	x1 = (char *)malloc(len);
	x2 = (char *)malloc(len);

	if (!x1 || !x2) {
	    iConsole->Write(_L("Out of memory!\n"));
	    exit(-1);
	}

	for (i = 0; i < len; i++) {
	    if (isupper(s1[i]))
	        x1[i] = tolower(s1[i]);
	    else
	        x1[i] = s1[i];

	    if (isupper(s2[i]))
	        x2[i] = tolower(s2[i]);
	    else
	        x2[i] = s2[i];
	}

	result = memcmp(x1, x2, len);
	free(x1);
	free(x2);
	return result;
}

/*
 * dbgu.c requires strlwr
 */
char *
strlwr(char *s)
{
    char *start;
    start = s;
    while (*s) {
        if (isupper(*s))
            *s = tolower(*s);

        s++;
    }
    return start;
}


/* ------------------------------------------------------------------------ */
/*
 *   Get file times 
 */

/*
 *   get file creation time 
 */
//int os_get_file_cre_time(os_file_time_t *t, const char *fname)
//{
//	struct stat info;

//	/* get the file information */
//	if (stat(fname, &info))
//	    return 1;

//	/* set the creation time in the return structure */
//	t->t = info.st_ctime;
//	return 0;
//}

/*
 *   get file modification time 
 */
//int os_get_file_mod_time(os_file_time_t *t, const char *fname)
//{
//	struct stat info;

//	/* get the file information */
//	if (stat(fname, &info))
//	    return 1;

//	/* set the modification time in the return structure */
//	t->t = info.st_mtime;
//	return 0;
//}

/* 
 *   get file last access time 
 */
//int os_get_file_acc_time(os_file_time_t *t, const char *fname)
//{
//	struct stat info;

//	/* get the file information */
//	if (stat(fname, &info))
//	    return 1;

//	/* set the access time in the return structure */
//	t->t = info.st_atime;
//	return 0;
//}

/*
 *   compare two file time structures 
 */
//int os_cmp_file_times(const os_file_time_t *a, const os_file_time_t *b)
//{
//	if (a->t < b->t)
//	    return -1;
//	else if (a->t == b->t)
//	    return 0;
//	else
//	    return 1;
//}

osfildef *osfoprwb(const char *fname, os_filetype_t typ)
{
	osfildef *fp;

	/* try opening an existing file in read/write mode */
	fp = fopen(fname, "r+b");

	/* if that failed, create a new file in read/write mode */
	if (fp == 0)
	    fp = fopen(fname, "w+b");

	/* return the file */
	return fp;
}

/*
 *   Check for a special filename 
 */
//enum os_specfile_t os_is_special_file(const char *fname)
//{
//	/* check for '.' */
//	if (strcmp(fname, ".") == 0)
//	    return OS_SPECFILE_SELF;

//	/* check for '..' */
//	if (strcmp(fname, "..") == 0)
//	    return OS_SPECFILE_PARENT;

//	/* not a special file */
//	return OS_SPECFILE_NONE;
//}

/*
 *   Build a full path name given a path and a filename
 *   
 *   Copied over from osnoui.c by Suzanne Britton (tril@igs.net), 2000/Aug/18 
 */
//void os_build_full_path(char *fullpathbuf, size_t fullpathbuflen,
//	                    const char *path, const char *filename)
//{
//	size_t plen, flen;
//	int add_sep;
//
//	/*
//	 *   Note whether we need to add a separator.  If the path prefix ends
//	 *   in a separator, don't add another; otherwise, add the standard
//	 *   system separator character.
//	 *   
//	 *   Do not add a separator if the path is completely empty, since this
//	 *   simply means that we want to use the current directory.  
//	 */
//	plen = strlen(path);
//	add_sep = (plen != 0
//	           && path[plen-1] != OSPATHCHAR
//	           && strchr(OSPATHALT, path[plen-1]) == 0);
//
//	/* copy the path to the full path buffer, limiting to the buffer length */
//	if (plen > fullpathbuflen - 1)
//	    plen = fullpathbuflen - 1;
//	memcpy(fullpathbuf, path, plen);
//
//	/* add the path separator if necessary (and if there's room) */
//	if (add_sep && plen + 2 < fullpathbuflen)
//	    fullpathbuf[plen++] = OSPATHCHAR;
//
//	/* add the filename after the path, if there's room */
//	flen = strlen(filename);
//	if (flen > fullpathbuflen - plen - 1)
//	    flen = fullpathbuflen - plen - 1;
//	memcpy(fullpathbuf + plen, filename, flen);
//
//	/* add a null terminator */
//	fullpathbuf[plen + flen] = '\0';
//}

/*
 *   Determine if a path is absolute or relative.  If the path starts with a
 *   path separator character, we consider it absolute, otherwise we
 *   consider it relative.
 *   
 *   Note that, on DOS, an absolute path can also follow a drive letter.
 *   So, if the path contains a letter followed by a colon, we'll consider
 *   the path to be absolute.
 *   
 *   Copied over from osnoui.c by Suzanne Britton (tril@igs.net),
 *   2000/Aug/18 
 */
int os_is_file_absolute(const char *fname)
{
	/* if the name starts with a path separator, it's absolute */
	if (fname[0] == OSPATHCHAR || strchr(OSPATHALT, fname[0])  != 0)
	    return TRUE;

	/* the path is relative */
	return FALSE;
}

/*
 *   Extract the path from a filename
 *   
 *   Copied over from osnoui.c by tril@igs.net, 2000/Aug/18 
 */
void os_get_path_name(char *pathbuf, size_t pathbuflen, const char *fname)
{
	const char *lastsep;
	const char *p;
	size_t len;

	/* find the last separator in the filename */
	for (p = fname, lastsep = fname ; *p != '\0' ; ++p)
	{
	    /*
	     *   if it's a path separator character, remember it as the last one
	     *   we've found so far 
	     */
	    if (*p == OSPATHCHAR || strchr(OSPATHALT, *p)  != 0)
	        lastsep = p;
	}

	/* get the length of the prefix, not including the separator */
	len = lastsep - fname;

	/* make sure it fits in our buffer (with a null terminator) */
	if (len > pathbuflen - 1)
	    len = pathbuflen - 1;

	/* copy it and null-terminate it */
	memcpy(pathbuf, fname, len);
	pathbuf[len] = '\0';
}

/*
 *   Get the name of the character mapping file.
 *   
 *   NOTE - we should use some means to find the actual character set that
 *   the user's terminal is using and return that; maybe some environment
 *   variable or some curses call will tell us what we need to know.  For
 *   now, we'll just return "asc7dflt", which is the 7-bit ASCII character
 *   mapping; this should be safe for any ASCII terminal, although it won't
 *   allow us to display accented characters that the user's terminal might
 *   actually be capable of displaying if we just knew the actual character
 *   set it was using.  
 */
void os_get_charmap(char *mapname, int charmap_id)
{
	strcpy(mapname, "asc7dflt");
}

/*
 *   Reallocate storage at a different size
 */
void *osrealloc(void *buf, size_t len)
{
	return realloc(buf, len);
}


// The controlling function for the whole program, works similar to
// C main().
// Creates the console and starts the main program
void ConsoleMainL()
{
//    int trdmain(/*_ int argc, char *argv[] _*/);
	int err=0;
	char *argv[2] = {"","                                                                                 "};
	TInt numargs=2;
	RProcess me;

    TBuf<128> args;
	me.CommandLine(args);
	if(args.Length() == 0)
		numargs=1;
	
	
	TBuf8<258> args8;
	args8.Copy(args);

	args8.ZeroTerminate();

	argv[1] = (char *) args8.Ptr();

//	iConsole = NewAdvConsole();
	iConsole = new CAdvConsoleClient;

	//Create the title with the opened file
	TBuf<128> tempname=_L("TADSR ");
	tempname.Append(args);

	((CConsoleBase *)iConsole)->Create(tempname, TSize(80, 25));

	TInt argc=2;
//    os_init(&argc, argv, (char *)0, (char *)0, 0);
    os_init();
	trdmain(numargs, argv, NULL, NULL);
//    os0main(argc, argv, trdmain, "", "config.tr");
    os_term(err);

	delete iConsole;

	CloseSTDLIB();

}

GLDEF_C TInt E32Main()
{
	__UHEAP_MARK;
	CTrapCleanup* cleanupStack = CTrapCleanup::New();
	TRAPD(error, ConsoleMainL());
	__ASSERT_ALWAYS(!error, User::Panic(_L("PEP"),error));
	delete cleanupStack;
	__UHEAP_MARKEND;
	return 0;
}


/* These functions are needed only when program is a DLL, which it is
 * under WINS.
 */
#if defined(__WINS__)
EXPORT_C TInt WinsMain(TAny *p)
{
//    RealCommandLine.Set(*(TDesC *) p);
    //process.CommandLine() = _L("-U Reebo");     // This doesn't work because CommandLine returns a copy.
    return E32Main();
}

GLDEF_C TInt E32Dll(TDllReason)
{
    return(KErrNone);
}
#endif
