//
//  XTLogConfig.m
//  TadsTerp
//
//  Created by Rune Berg on 16/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTLogConfig.h"
#import "XTLogger.h"
#import "XTLogAppenderNSLog.h"
//TODO get rid of these:
#import "XTOutputTextParserHtml.h"
#import "XTOutputTextParserPlain.h"
#import "XTMainTextHandler.h"
#import "XTOutputFormatter.h"
#import "XTTabStopModel.h"
#import "XTGameWindowController.h"
#import "XTPrefsWindowController.h"
#import "XTFontManager.h"
#import "XTEventLoopBridge.h"
#import "XTAppDelegate.h"
#import "XTUIUtils.h"
#import "XTDirectoryHelper.h"
#import "XTFileUtils.h"
#import "XTPrefs.h"
#import "XTMainTextView.h"
#import "XTTads2AppCtx.h"
#import "XTResourceFinder.h"
#import "XTBannerTextHandler.h"
#import "XTFontUtils.h"


#define XT_LOG_SET_LEVEL_FOR_NAME(level,name) \
	name : [NSNumber numberWithInteger:level],

#define XT_LOG_SET_LEVEL_FOR_CLASS(level,clazz) \
	NSStringFromClass([clazz class]) : [NSNumber numberWithInteger:level],

#define XT_LOG_SET_APPENDERS_FOR_CLASS(appenders,clazz) \
	NSStringFromClass([clazz class]) : appenders

@implementation XTLogConfig

static XTLoggerLevel defaultLevel;
static NSDictionary *levelByName; // "logger name" -> NSNumber(XTLoggerLevel)

static XTLogAppenderNSLog *appenderNSLog = nil;
	//TODO more appenders? log window, file, ...
static NSArray *defaultAppenders;
static NSMutableDictionary *appendersByName; // "logger name" -> [appender]


+ (void)initialize
{
	if (appenderNSLog != nil) {
		// we can be called more than once :-(
		return;
	}
	
	defaultLevel = XT_LEVEL_WARN;
	
	// exceptions to defaultLevel:
	levelByName = @{
	    //XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTAppDelegate)
	    //XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTEventLoopBridge)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTStatusLineHandler)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTOutputTextParserHtml)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTOutputTextParserPlain)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTMainTextHandler)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTMainTextView)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTOutputFormatter)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTGameWindowController)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTFontManager)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTDirectoryHelper)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTFileUtils)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTUIUtils)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTPrefs)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTPrefsWindowController)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTTads2AppCtx)
		//XT_LOG_SET_LEVEL_FOR_NAME(XT_LEVEL_TRACE, @"XTAppResourceLoader")
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTResourceFileFinder)
		//XT_LOG_SET_LEVEL_FOR_NAME(XT_LEVEL_TRACE, @"osxtads")
		//XT_LOG_SET_LEVEL_FOR_NAME(XT_LEVEL_TRACE, @"XTVmHostIfc")
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTBannerHandler)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTFontUtils)
		//XT_LOG_SET_LEVEL_FOR_CLASS(XT_LEVEL_TRACE, XTTabStopModel)
	};

	appenderNSLog = [XTLogAppenderNSLog new];
	
	defaultAppenders = [NSArray arrayWithObject:appenderNSLog];
	
	appendersByName = [NSMutableDictionary dictionary];
}

+ (void)setAppenders:(NSArray *)appenders forClass:(Class)class
{
	NSString *className = NSStringFromClass(class);
	appendersByName[className] = appenders;
}

+ (XTLoggerLevel)levelForName:(NSString *)name
{
	[self initialize]; // because we might get called too early
	
	XTLoggerLevel res;
	NSNumber *level = levelByName[name];
	if (level == nil) {
		res = defaultLevel;
	} else {
		res = level.integerValue;
	}
	return res;
}

+ (NSArray *)appendersForName:(NSString *)name
{
	[self initialize]; // because we might get called too early
	
	NSArray *res = appendersByName[name];
	if (res == nil) {
		res = defaultAppenders;
	}
	return res;
}


@end
