//
//  XTDirectoryHelper.m
//  TadsTerp
//
//  Created by Rune Berg on 31/10/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTDirectoryHelper.h"
#import "XTFileUtils.h"
#import "XTPrefs.h"


@interface XTDirectoryHelper ()

@property XTPrefs *prefs;
@property NSURL *lastUsedGameDirectoryRegardless;

@end


@implementation XTDirectoryHelper

static XTDirectoryHelper *singletonInstance;

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTDirectoryHelper class]];
	singletonInstance = [XTDirectoryHelper new];
	singletonInstance.prefs = [XTPrefs prefs];
}

+ (id)helper
{
	return singletonInstance;
}

- (NSURL *)findDefaultGamesDirectory
{
	XT_DEF_SELNAME;
	
	NSURL *res = nil;
	
	switch (self.prefs.gamesDirectoryMode) {
		case XTPREFS_DIR_MODE_SPECIFIC:
			res = self.prefs.gamesDirectoryWhenSpecific;
			break;
		case XTPREFS_DIR_MODE_NONE:
			res = nil;
			break;
		case XTPREFS_DIR_MODE_LAST_SELECTED:
			res = self.prefs.gamesDirectoryLastUsed;
			break;
		default:
			XT_WARN_1(@"unexpected dir mode %lu", self.prefs.gamesDirectoryMode);
			break;
	}
	
	XT_TRACE_1(@"-> \"%@\"", res);
	
	return res;
}

- (void)noteUsedGamesDirectory:(NSURL *)gameFileUrl
{
	XT_DEF_SELNAME;
	XT_TRACE_1(@"%@", gameFileUrl);
	
	self.lastUsedGameDirectoryRegardless = [XTFileUtils existingDirectoryUrlFor:gameFileUrl];
	self.prefs.gamesDirectoryLastUsed = self.lastUsedGameDirectoryRegardless;
}

- (NSURL *)findDefaultSavesDirectory
{
	XT_DEF_SELNAME;
	
	NSURL *res = nil;
	
	switch (self.prefs.savesDirectoryMode) {
		case XTPREFS_DIR_MODE_SPECIFIC:
			res = self.prefs.savesDirectoryWhenSpecific;
			break;
		case XTPREFS_DIR_MODE_NONE:
			res = nil;
			break;
		case XTPREFS_DIR_MODE_LAST_SELECTED:
			res = self.prefs.savesDirectoryLastUsed;
			break;
		case XTPREFS_DIR_MODE_CURRENT_GAMEFILE:
			res = self.lastUsedGameDirectoryRegardless;
			break;
		default:
			XT_WARN_1(@"unexpected dir mode %lu", self.prefs.savesDirectoryMode);
			break;
	}
	
	XT_TRACE_1(@"-> \"%@\"", res);
	
	return res;
}

- (void)noteUsedSavesDirectory:(NSURL *)saveFileUrl
{
	self.prefs.savesDirectoryLastUsed = [XTFileUtils existingDirectoryUrlFor:saveFileUrl];
}

- (NSURL *)findDefaultTranscriptsDirectory
{
	XT_DEF_SELNAME;
	
	NSURL *res = nil;
	
	switch (self.prefs.transcriptsDirectoryMode) {
		case XTPREFS_DIR_MODE_SPECIFIC:
			res = self.prefs.transcriptsDirectoryWhenSpecific;
			break;
		case XTPREFS_DIR_MODE_NONE:
			res = nil;
			break;
		case XTPREFS_DIR_MODE_LAST_SELECTED:
			res = self.prefs.transcriptsDirectoryLastUsed;
			break;
		case XTPREFS_DIR_MODE_CURRENT_GAMEFILE:
			res = self.lastUsedGameDirectoryRegardless;
			break;
		default:
			XT_WARN_1(@"unexpected dir mode %lu", self.prefs.transcriptsDirectoryMode);
			break;
	}

	XT_TRACE_1(@"-> \"%@\"", res);
	
	return res;
}

- (void)noteUsedTranscriptsDirectory:(NSURL *)transcriptFileUrl
{
	self.prefs.transcriptsDirectoryLastUsed = [XTFileUtils existingDirectoryUrlFor:transcriptFileUrl];
}

- (NSURL *)findDefaultCommandScriptsDirectory
{
	XT_DEF_SELNAME;
	
	NSURL *res = nil;
	
	switch (self.prefs.commandScriptsDirectoryMode) {
		case XTPREFS_DIR_MODE_SPECIFIC:
			res = self.prefs.commandScriptsDirectoryWhenSpecific;
			break;
		case XTPREFS_DIR_MODE_NONE:
			res = nil;
			break;
		case XTPREFS_DIR_MODE_LAST_SELECTED:
			res = self.prefs.commandScriptsDirectoryLastUsed;
			break;
		case XTPREFS_DIR_MODE_CURRENT_GAMEFILE:
			res = self.lastUsedGameDirectoryRegardless;
			break;
		default:
			XT_WARN_1(@"unexpected dir mode %lu", self.prefs.commandScriptsDirectoryMode);
			break;
	}
	
	XT_TRACE_1(@"-> \"%@\"", res);
	
	return res;
}

- (void)noteUsedCommandScriptsDirectory:(NSURL *)commandScriptFileUrl
{
	self.prefs.commandScriptsDirectoryLastUsed = [XTFileUtils existingDirectoryUrlFor:commandScriptFileUrl];
}

@end
