//
//  XTFormattedOutputElement.h
//  TadsTerp
//
//  Created by Rune Berg on 10/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTHtmlTag.h"
#import "XTSpecialAction.h"


@interface XTFormattedOutputElement : NSObject

typedef NS_ENUM(NSInteger, XTFormattedOutputElementType) {
    XTFormattedOutputElementRegularOutput,
	XTFormattedOutputElementTab,
    XTFormattedOutputElementGameTitle,
	XTFormattedOutputElementBannerStart,
	XTFormattedOutputElementBannerEnd,
	XTFormattedOutputElementSpecialAction
};

@property XTFormattedOutputElementType elementType;
@property NSMutableAttributedString *attributedString;
@property XTHtmlTag *htmlTag;
@property XTSpecialAction *specialAction;

+ (instancetype)regularOutputElement:(NSMutableAttributedString *)attributedString;

+ (instancetype)tabElement:(XTHtmlTag *)htmlTag;

+ (instancetype)gameTitleElement:(NSMutableAttributedString *)attributedString;

+ (instancetype)bannerStartElement:(XTHtmlTag *)htmlTag;

+ (instancetype)bannerEndElement;

+ (instancetype)specialActionElement:(XTSpecialAction *)specialAction;

- (BOOL)isRegularOutputElement;

- (BOOL)isTabElement;

- (BOOL)isRegularOutputElementWithString:(NSString *)str;

- (BOOL)isGameTitleElement;

- (BOOL)isBannerStartElement;

- (BOOL)isBannerEndElement;

- (BOOL)isSpecialActionElement;

@end
