//
//  TAXTScoreStringTransformerTests.m
//  TadsTerp
//
//  Created by Rune Berg on 20/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <XCTest/XCTest.h>
#import "XTScoreStringTransformer.h"


@interface XTScoreStringTransformerTests : XCTestCase

@property XTScoreStringTransformer *transformer;

@end


@implementation XTScoreStringTransformerTests

- (void)setUp
{
    [super setUp];
	_transformer = [XTScoreStringTransformer new];
}

- (void)tearDown
{
    [super tearDown];
}

- (void)testReformat
{
	XCTAssertNil([XTScoreStringTransformer reformat:nil]);
	XCTAssertEqualObjects(@"", [XTScoreStringTransformer reformat:@""]);

	XCTAssertEqualObjects(@"a", [XTScoreStringTransformer reformat:@"a"]);
	XCTAssertEqualObjects(@"ab", [XTScoreStringTransformer reformat:@"ab"]);
	XCTAssertEqualObjects(@"abc", [XTScoreStringTransformer reformat:@"abc"]);

	XCTAssertEqualObjects(@"2 / 7", [XTScoreStringTransformer reformat:@"2/7"]);
	XCTAssertEqualObjects(@"12 / 700", [XTScoreStringTransformer reformat:@"12/700"]);
	XCTAssertEqualObjects(@"-2 / -7", [XTScoreStringTransformer reformat:@"-2/-7"]);

	XCTAssertEqualObjects(@"/", [XTScoreStringTransformer reformat:@"/"]);
	XCTAssertEqualObjects(@"1/", [XTScoreStringTransformer reformat:@"1/"]);
	XCTAssertEqualObjects(@"/1", [XTScoreStringTransformer reformat:@"/1"]);
	XCTAssertEqualObjects(@"2/7a", [XTScoreStringTransformer reformat:@"2/7a"]);
	XCTAssertEqualObjects(@"2/a", [XTScoreStringTransformer reformat:@"2/a"]);
}

- (void)testFormatScore
{
	XCTAssertEqualObjects(@"2 / 31", [XTScoreStringTransformer formatScore:2 inTurns:31]);
}


@end
