//
//  XTOutputTextHandler.h
//  TadsTerp
//
//  Created by Rune Berg on 28/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
//#import "XTGameWindowController.h"
#import "XTOutputTextView.h"
#import "XTGameWindowController.h"


@interface XTOutputTextHandler : NSObject

@property (weak) XTGameWindowController *gameWindowController;

@property NSMutableString *gameTitle;

@property NSScrollView *outputTextScrollView;
@property (unsafe_unretained) XTOutputTextView *outputTextView;

@property NSUInteger commandPromptPosition;
@property BOOL htmlMode;
@property BOOL nonstopMode;
@property BOOL paginationActive;

+ (instancetype)handler;

- (void)setHiliteMode:(BOOL)hiliteMode;

- (void)resetToDefaults;

- (void)resetForNextCommand;

- (void)resetForGameHasEndedMsg;

- (BOOL)appendOutput:(NSString *)string;

- (BOOL)pumpOutput;

- (void)flushOutput;

- (void)appendInput:(NSString *)string;

- (BOOL)handleCommandLinkClicked:(NSString *)linkString atIndex:(NSUInteger)charIndex;

- (void)ensureInputFontIsInEffect;

- (void)clearText;

- (NSString *)getCommand;

- (void)noteStartOfPagination;

// the index where new output text should be appended
- (NSUInteger)endOfOutputPosition;

- (void)moveCursorToEndOfOutputPosition;

- (void)scrollToEnd;

// the index where new input text is appended
- (NSInteger)insertionPoint;

- (NSInteger)minInsertionPoint;

- (void)replaceCommandText:(NSString *)newCommandText;

- (BOOL)allowTextInsertion:(NSRange)affectedCharRange;

- (void)goToPreviousCommand;

- (void)goToNextCommand;

@end
