//
//  XTFileUtils.h
//  TadsTerp
//
//  Created by Rune Berg on 04/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "osxtads.h"

#define XTADS_FILESYSTEM_C_STRING_TO_NSSTRING(fsCStr) \
	(fsCStr == NULL ? nil : [NSString stringWithUTF8String:fsCStr])
	//TODO check if encoding necessarily right
	//TODO use

#define XTADS_FILESYSTEM_C_STRING_LEN_TO_NSSTRING(fsCStr, fsCStrLen) \
	(fsCStr == NULL ? nil : [[NSString alloc] initWithBytes:fsCStr length:fsCStrLen encoding:NSUTF8StringEncoding])
	//TODO check if encoding necessarily right

#define XTADS_NSSTRING_TO_FILESYSTEM_C_STRING(nsStr) \
	[nsStr cStringUsingEncoding:NSUTF8StringEncoding]
	//TODO check if encoding necessarily right


@interface XTFileUtils : NSObject

+ (NSUInteger)sizeOfFileObj:(osfildef *)fileObj;

+ (NSUInteger)sizeOfFile:(NSString *)filename;

+ (NSURL *)urlForDirectory:(NSString *)path;

+ (BOOL)fileExists:(NSURL *)filenameUrl;

+ (BOOL)isExistingFileUrl:(NSURL *)url;

+ (BOOL)fileUrl:(NSURL *)url hasExtensionIn:(NSArray *)extensions;

+ (NSURL *)urlIfAbsolute:(NSString *)filename;

+ (BOOL)directory:(NSURL *)dirUrl containsFile:(NSURL *)fileUrl;

+ (NSURL *)existingDirectoryUrlFor:(NSURL *)fileOrDirectoryUrl;

+ (BOOL)createDirectoryAtUrl:(NSURL *)url withIntermediateDirectories:(BOOL)createIntermediates;

+ (BOOL)removeDirectoryAtUrl:(NSURL *)url;

//TODO fix stat visibility warnings
+ (void)stat:(struct stat*)stat toMode:(unsigned long*)mode forFileName:(const char*)fileName;

+ (int)stat:(const struct stat*)stat toAttrs:(unsigned long *)attrs forFileName:(const char*)fileName;

+ (BOOL)resolveLinkFully:(const char *)filename toFilename:(char *)resolvedFilename ofMaxLength:(size_t)maxLenOfResolvedFilename;

+ (NSURL *)urlForApplicationSupportDirectory;

@end
