/*
 *   input tests - input, inputKey, inputEvent, inputDialog
 */

#include "t3.h"
#include "tads.h"

_say_embed(str) { tadsSay(str); }

class RuntimeError: object
    construct(errno, ...) { errno_ = errno; }
    display = "Runtime Error: <<errno_>>"
    errno_ = 0
;

_main(args)
{
    try
    {
        t3SetSay(_say_embed);
        main();
    }
    catch (RuntimeError rte)
    {
        "\n<<rte.display>>\n";
    }
}

function main()
{
    local x;

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconNone, 'Custom dialog: Hello(=default) / Goodbye(=cancel) / Anyway',
                    ['Hello', 'Goodbye', 'Anyway'], 1, 2);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconQuestion,
                    'A standard ok(=default&cancel) dialog!', InDlgOk, 1, 1);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconQuestion,
                    'A standard ok(=default) / cancel(=cancel) dialog!', InDlgOkCancel, 1, 2);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconQuestion,
                    'A standard yes(=default) / no(=cancel) dialog!', InDlgYesNo, 1, 2);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconQuestion,
                    'A standard yes / no / cancel(=cancel) dialog!', InDlgYesNoCancel, 0, 3);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconInfo,
                    'Another dialog! (no default or cancel)', [InDlgLblOk, InDlgLblNo],
                    nil, nil);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconNone, 'Custom dialog w/ custom key equivs: Human / Elf / Orc / Dwarf',
                    ['&Human', '&Elf', '&Orc', '&Dwarf'], 0, 0);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconNone, 'Custom dialog w/ custom key equivs and default/esc: Human / Elf(=default) / Orc(=cancel) / Dwarf',
                    ['&Human', '&Elf', '&Orc', '&Dwarf'], 2, 3);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconNone, 'Custom dialog WITHOUT custom key equivs: Human / Elf / Orc',
                    ['Human', 'Elf', 'Orc'], 0, 0);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconNone, 'Custom dialog w/ labels for which we don\'t want built-in Apple behaviour: OK / Cancel',
                    ['OK', 'Cancel'], 0, 0);
    "Response = <<x>>\n";

   //-------------

    "Press a key...";
    x = inputKey();

    x = inputDialog(InDlgIconNone, 'Custom dialog w/ labels for which we don\'t want built-in Apple behaviour: Cancel / Do it',
                    ['Cancel', 'Do it'], 0, 0);
    "Response = <<x>>\n";

    "Done!!!\n";
}

