//
//  osxtads_banners.m
//  XTads
//
//  Created by Rune Berg on 12/07/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "osxtads_support.h"


void *os_banner_create(void *parent, int where, void *other, int wintype,
                       int align, int siz, int siz_units,
                       unsigned long style)
{
	void *res = [getGameRunner() bannerCreate:parent
										where:where
										other:other
									  wintype:wintype
										align:align
										 size:siz
									sizeUnits:siz_units
										style:style];
	return res;
}

void os_banner_delete(void *banner_handle)
{
	[getGameRunner() bannerDelete:banner_handle];
}

void os_banner_orphan(void *banner_handle)
{
	[getGameRunner() bannerOrphan:banner_handle];
}

int os_banner_getinfo(void *banner_handle, os_banner_info_t *info)
{
	BOOL gotInfo = [getGameRunner() bannerInfo:banner_handle info:info];
	return gotInfo;
}

int os_banner_get_charwidth(void *banner_handle)
{
	NSUInteger res = [getGameRunner() bannerWidthInChars:banner_handle];
	return (int)res;
}

int os_banner_get_charheight(void *banner_handle)
{
	NSUInteger res = [getGameRunner() bannerHeightInChars:banner_handle];
	return (int)res;
}

void os_banner_clear(void *banner_handle)
{
	[getGameRunner() bannerClear:banner_handle];
}

void os_banner_disp(void *banner_handle, const char *txt, size_t len)
{
	NSString *s = [getGameRunner() makeString:txt len:len];
	[getGameRunner() bannerDisplay:banner_handle text:s];
}

void os_banner_set_attr(void *banner_handle, int attrs)
{
	//LOG_CALL_TO_UNIMPLEMENTED_FUNCTION(@"os_banner_set_attr");
}

void os_banner_set_color(void *banner_handle, os_color_t fg, os_color_t bg)
{
	[getGameRunner() bannerSetTextColors:banner_handle foregroundColor:fg backgroundColor:bg];
}

void os_banner_set_screen_color(void *banner_handle, os_color_t color)
{
	[getGameRunner() bannerSetScreenColor:banner_handle screenColor:color];
}

void os_banner_flush(void *banner_handle)
{
	[getGameRunner() bannerFlush:banner_handle];
}

void os_banner_set_size(void *banner_handle, int siz, int siz_units,
                        int is_advisory)
{
	[getGameRunner() bannerSetSize:banner_handle size:siz sizeUnits:siz_units isAdvisory:is_advisory];
}

void os_banner_size_to_contents(void *banner_handle)
{
	[getGameRunner() bannerSizeToContents:banner_handle];
}

void os_banner_start_html(void *banner_handle)
{
	[getGameRunner() bannerSetHtmlMode:banner_handle on:YES];
}

void os_banner_end_html(void *banner_handle)
{
	[getGameRunner() bannerSetHtmlMode:banner_handle on:NO];
}

void os_banner_goto(void *banner_handle, int row, int col)
{
	[getGameRunner() bannerGoto:banner_handle row:row column:col];
}

//-----------------------------------

void os_set_text_color(os_color_t c1, os_color_t c2)
{
    /* we ignore this - callers must use HTML tags to set colors */
}

void os_set_screen_color(os_color_t color)
{
    /* we ignore this - callers must use HTML tags to set colors */
}
