//
//  XTHtmlTagTab.m
//  TadsTerp
//
//  Created by Rune Berg on 05/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagTab.h"
#import "XTBaseTextHandler.h"
#import "XTAllocDeallocCounter.h"


@implementation XTHtmlTagTab

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

#define XT_ALIGN_ATTR_NAME @"align"
#define XT_ID_ATTR_NAME @"id"
#define XT_ALIGN_ATTR_VALUE_RIGHT @"right"
#define XT_XTADS_HORIZ_RULER_ATTR_NAME @"xtads_horiz_ruler"

+ (NSString *)name
{
	return @"tab";
}

+ (BOOL)standalone
{
	return YES;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler;
{
	NSArray *formattedElements = [formatter handleHtmlTagTab:self];
	[textHandler receiveFormattedElements:formattedElements];
}

+ (instancetype)rightAligned
{
	XTHtmlTagTab *tabTag = [XTHtmlTagTab new];
	[tabTag addAttribute:XT_ALIGN_ATTR_NAME value:XT_ALIGN_ATTR_VALUE_RIGHT];
	return tabTag;
}

+ (instancetype)forPlainTextMode
{
	XTHtmlTagTab *tabTag = [XTHtmlTagTab new];
	[tabTag addAttribute:@"multiple" value:@"4"];
	return tabTag;
}

+ (instancetype)forHorizontalRulerLhsWithAlignment:(XTTextAlignMode)alignment
								 widthAsPercentage:(NSNumber *)widthAsPercentage
									 widthAsPoints:(NSNumber *)widthAsPoints
{
	BOOL hasCenterOrRightAlignment = (alignment == XT_TEXT_ALIGN_CENTER || alignment == XT_TEXT_ALIGN_RIGHT);
	BOOL hasSpecdWidth = (widthAsPercentage.unsignedIntegerValue > 0 && widthAsPercentage.unsignedIntegerValue < 100) || (widthAsPoints.unsignedIntegerValue > 0);
	BOOL needsLhsTab = (hasCenterOrRightAlignment && hasSpecdWidth);
	
	XTHtmlTagTab *tabTag = nil;
	if (needsLhsTab) {
		tabTag = [XTHtmlTagTab new];
		[tabTag addAttribute:XT_XTADS_HORIZ_RULER_ATTR_NAME value:@"left"];
		tabTag.horizRulerAlignment = alignment;
		tabTag.horizRulerWidthAsPercentage = widthAsPercentage;
		tabTag.horizRulerWidthAsPoints = widthAsPoints;
	}
	
	return tabTag;
}

+ (instancetype)forHorizontalRulerRhsWithAlignment:(XTTextAlignMode)alignment
								 widthAsPercentage:(NSNumber *)widthAsPercentage
									 widthAsPoints:(NSNumber *)widthAsPoints
{
	XTHtmlTagTab *tabTag = [XTHtmlTagTab new];
	[tabTag addAttribute:XT_XTADS_HORIZ_RULER_ATTR_NAME value:@"right"];
	tabTag.horizRulerAlignment = alignment;
	tabTag.horizRulerWidthAsPercentage = widthAsPercentage;
	tabTag.horizRulerWidthAsPoints = widthAsPoints;
	return tabTag;
}

- (BOOL)isRightAligned
{
	NSString *align = [self attributeAsString:XT_ALIGN_ATTR_NAME];
	BOOL res = (align != nil && [align isEqualToString:XT_ALIGN_ATTR_VALUE_RIGHT]);
	return res;
}

- (BOOL)isForId
{
	NSString *id = [self attributeAsString:XT_ID_ATTR_NAME];
	BOOL res = (id != nil);
	return res;
}

- (BOOL)isForHorizontalRuler
{
	NSString *id = [self attributeAsString:XT_XTADS_HORIZ_RULER_ATTR_NAME];
	BOOL res = (id != nil);
	return res;
}

- (BOOL)isForHorizontalRulerLhs
{
	NSString *id = [self attributeAsString:XT_XTADS_HORIZ_RULER_ATTR_NAME];
	BOOL res = ([id isEqualTo:@"left"]);
	return res;
}

@end
