//
//  osxtads_support.h
//  XTads
//
//  Created by Rune Berg on 11/07/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import "XTLogger.h"
#import "XTGameRunnerProtocol.h"

#ifndef osxtads_support_h
#define osxtads_support_h


#define XTOSIFC_DEF_SELNAME(sn) NSString *selName = sn;
#define XTOSIFC_TRACE_ENTRY(sn) XTOSIFC_DEF_SELNAME(sn); [osifcLogger() trace:@"%@", XT_SELNAME];
#define XTOSIFC_WARN_ENTRY(sn) XTOSIFC_DEF_SELNAME(sn); [osifcLogger() warn:@"%@", XT_SELNAME];

#define XTOSIFC_TRACE_0(fmt) [osifcLogger() trace:@"%@ " fmt, XT_SELNAME];
#define XTOSIFC_TRACE_1(fmt,arg1) [osifcLogger() trace:@"%@ " fmt, XT_SELNAME, arg1];
#define XTOSIFC_TRACE_2(fmt,arg1,arg2) [osifcLogger() trace:@"%@ " fmt, XT_SELNAME, arg1, arg2];
#define XTOSIFC_TRACE_4(fmt,arg1,arg2,arg3,arg4) [osifcLogger() trace:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4];
#define XTOSIFC_TRACE_6(fmt,arg1,arg2,arg3,arg4,arg5,arg6) [osifcLogger() trace:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5, arg6];

#define XTOSIFC_WARN_0(fmt) [osifcLogger() warn:@"%@ " fmt, XT_SELNAME];
#define XTOSIFC_WARN_1(fmt,arg1) [osifcLogger() warn:@"%@ " fmt, XT_SELNAME, arg1];

#define XTOSIFC_ERROR_0(fmt) [osifcLogger() error:@"%@ " fmt, XT_SELNAME];
#define XTOSIFC_ERROR_1(fmt,arg1) [osifcLogger() error:@"%@ " fmt, XT_SELNAME, arg1];
#define XTOSIFC_ERROR_2(fmt,arg1,arg2) [osifcLogger() error:@"%@ " fmt, XT_SELNAME, arg1, arg2];

#define XTOSIFC_TRACE_ON ([XTLogConfig levelForName:osifcLogger().name] >= XT_LEVEL_TRACE)

#define LOG_CALL_TO_UNIMPLEMENTED_FUNCTION(funcName) \
	{ \
	NSString *msg = [NSString stringWithFormat:@"%@ not implemented!", funcName]; \
	[osifcLogger() error:msg]; \
	}

XTLogger *osifcLogger();

void osxtads_init();

id<XTGameRunnerProtocol> getGameRunner();

#endif /* osxtads_support_h */
